/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.batch.internal.core.impl;

import java.util.Collection;
import java.util.HashSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.jdt.core.IField;
import org.jboss.tools.batch.core.IBatchArtifact;
import org.jboss.tools.batch.core.IBatchProperty;
import org.jboss.tools.batch.internal.core.impl.BatchAnnotationDeclaration;
import org.jboss.tools.batch.internal.core.impl.BatchArtifact;
import org.jboss.tools.batch.internal.core.impl.BatchUtil;
import org.jboss.tools.batch.internal.core.impl.definition.FieldDefinition;
import org.jboss.tools.common.java.IAnnotationDeclaration;
import org.jboss.tools.common.text.ITextSourceReference;

public class BatchProperty
implements IBatchProperty {
    BatchArtifact parent;
    FieldDefinition definition;

    public void setArtifact(BatchArtifact parent) {
        this.parent = parent;
    }

    public void setDefinition(FieldDefinition definition) {
        this.definition = definition;
    }

    @Override
    public IAnnotationDeclaration getInjectDeclaration() {
        return this.definition.getInjectAnnotation();
    }

    @Override
    public IAnnotationDeclaration getBatchPropertyDeclaration() {
        return this.definition.getBatchPropertyAnnotation();
    }

    @Override
    public String getPropertyName() {
        Object o;
        BatchAnnotationDeclaration d = this.definition.getBatchPropertyAnnotation();
        if (d != null && (o = d.getMemberValue("name", true)) != null) {
            return o.toString();
        }
        return this.getField().getElementName();
    }

    @Override
    public IField getField() {
        return this.definition.getField();
    }

    @Override
    public IBatchArtifact getArtifact() {
        return this.parent;
    }

    @Override
    public Collection<ITextSourceReference> getReferences() {
        HashSet<ITextSourceReference> result = new HashSet<ITextSourceReference>();
        for (IFile file : this.parent.project.getDeclaredBatchJobs()) {
            String expression = "//*[@ref=\"" + this.parent.getName() + "\"]" + "/*[name()=\"" + "properties" + "\"]" + "/*[name()=\"" + "property" + "\" and @" + "name" + "=\"" + this.getPropertyName() + "\"]" + "/@" + "name";
            BatchUtil.AttrReferencesRequestor<BatchUtil.TextSourceReference> requestor = new BatchUtil.AttrReferencesRequestor<BatchUtil.TextSourceReference>(file, expression, BatchUtil.TextSourceReference.class);
            BatchUtil.scanXMLFile(file, requestor);
            result.addAll(requestor.getResults());
        }
        return result;
    }
}

