/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.batch.internal.core.preferences;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.jboss.tools.batch.core.BatchCorePlugin;
import org.jboss.tools.common.validation.ValidationSeverityPreferences;

public class BatchSeverityPreferences
extends ValidationSeverityPreferences {
    public static final Set<String> SEVERITY_OPTION_NAMES = new HashSet<String>();
    private static BatchSeverityPreferences INSTANCE = new BatchSeverityPreferences();
    public static final String WARNING_GROUP_ID = "batch";
    public static final String INVALID_JOB_RESTARTABLE = INSTANCE.createSeverityOption("invalidJobRestartable", new String[]{"invalid-restartable"});
    public static final String UNKNOWN_ARTIFACT_NAME = INSTANCE.createSeverityOption("unknownArtifactName", new String[]{"unknown-artifact"});
    public static final String WRONG_ARTIFACT_TYPE = INSTANCE.createSeverityOption("wrongArtifactType", new String[]{"wrong-artifact"});
    public static final String UNUSED_PROPERTY = INSTANCE.createSeverityOption("unusedProperty", new String[]{"unused-property"});
    public static final String UNKNOWN_PROPERTY = INSTANCE.createSeverityOption("unknownProperty", new String[]{"unknown-property"});
    public static final String TARGET_NOT_FOUND = INSTANCE.createSeverityOption("targetNotFound", new String[]{"unfound-target"});
    public static final String LOOP_IS_DETECTED = INSTANCE.createSeverityOption("loopIsDetected", new String[]{"loop-detected"});
    public static final String UNKNOWN_EXCEPTION_CLASS = INSTANCE.createSeverityOption("unknownExceptionClass", new String[]{"unknown-exception"});
    public static final String WRONG_EXCEPTION_CLASS = INSTANCE.createSeverityOption("wrongExceptionClass", new String[]{"not-exception"});

    public static BatchSeverityPreferences getInstance() {
        return INSTANCE;
    }

    private BatchSeverityPreferences() {
    }

    protected String createSeverityOption(String shortName) {
        String name = String.valueOf(this.getPluginId()) + ".validator.problem." + shortName;
        SEVERITY_OPTION_NAMES.add(name);
        return name;
    }

    protected String getPluginId() {
        return BatchCorePlugin.PLUGIN_ID;
    }

    protected Set<String> getSeverityOptionNames() {
        return SEVERITY_OPTION_NAMES;
    }

    public String getWarningGroupID() {
        return WARNING_GROUP_ID;
    }

    public static boolean isValidationEnabled(IProject project) {
        return INSTANCE.isEnabled(project);
    }

    public static int getMaxNumberOfProblemMarkersPerFile(IProject project) {
        return INSTANCE.getMaxNumberOfProblemMarkersPerResource(project);
    }
}

