/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.batch.internal.core.scanner.lib;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.jboss.tools.batch.core.BatchCorePlugin;
import org.jboss.tools.batch.core.IBatchProject;
import org.jboss.tools.batch.internal.core.impl.BatchProject;
import org.jboss.tools.batch.internal.core.impl.BatchProjectFactory;
import org.jboss.tools.batch.internal.core.scanner.BatchArchiveDetector;
import org.jboss.tools.batch.internal.core.scanner.lib.AbstractClassPathMonitor;
import org.jboss.tools.batch.internal.core.scanner.lib.JarSet;
import org.jboss.tools.batch.internal.core.scanner.lib.Libs;
import org.jboss.tools.common.EclipseUtil;

public class ClassPathMonitor
extends AbstractClassPathMonitor {
    IBatchProject batchProject;
    IPath[] srcs = new IPath[0];
    Set<IPath> removedPaths = new HashSet<IPath>();

    public ClassPathMonitor(IBatchProject project) {
        this.batchProject = project;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JarSet process() {
        JarSet newJars = new JarSet();
        for (String p : this.syncProcessedPaths()) {
            Set<IPath> set = this.removedPaths;
            synchronized (set) {
                this.removedPaths.add((IPath)new Path(p));
            }
        }
        HashSet processed = new HashSet();
        ClassPathMonitor classPathMonitor = this;
        synchronized (classPathMonitor) {
            processed.addAll(this.processedPaths);
        }
        int i = 0;
        while (i < this.paths.size()) {
            String p = (String)this.paths.get(i);
            if (this.requestForLoad(p)) {
                this.removedPaths.add((IPath)new Path(p));
                String fileName = new File(p).getName();
                if (!Libs.SYSTEM_JAR_SET.contains(fileName)) {
                    this.detectBatchModule(p, newJars);
                }
            }
            ++i;
        }
        this.validateProjectDependencies();
        return newJars;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSrcs(IPath[] newSrcs) {
        IPath s;
        HashSet<IPath> ss = new HashSet<IPath>();
        IPath[] iPathArray = newSrcs;
        int n = newSrcs.length;
        int n2 = 0;
        while (n2 < n) {
            s = iPathArray[n2];
            ss.add(s);
            ++n2;
        }
        iPathArray = this.srcs;
        n = this.srcs.length;
        n2 = 0;
        while (n2 < n) {
            s = iPathArray[n2];
            if (!ss.contains(s)) {
                Set<IPath> set = this.removedPaths;
                synchronized (set) {
                    this.removedPaths.add(s);
                }
            }
            ++n2;
        }
        this.srcs = newSrcs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applyRemovedPaths() {
        Set<IPath> set = this.removedPaths;
        synchronized (set) {
            for (IPath p : this.removedPaths) {
                ((BatchProject)this.batchProject).pathRemoved(p);
            }
            this.removedPaths.clear();
        }
    }

    public void validateProjectDependencies() {
        List<IBatchProject> ps = null;
        try {
            ps = ClassPathMonitor.getProjects(this.batchProject.getProject());
        }
        catch (CoreException e) {
            BatchCorePlugin.pluginLog().logError((Throwable)e);
        }
        if (ps != null) {
            Set set = this.batchProject.getUsedProjects();
            HashSet removable = new HashSet();
            removable.addAll(set);
            removable.removeAll(ps);
            ps.removeAll(set);
            for (IBatchProject p : ps) {
                this.batchProject.addUsedProject(p);
            }
            for (IBatchProject p : removable) {
                this.batchProject.removeUsedProject(p);
            }
        }
    }

    public boolean hasToUpdateProjectDependencies() {
        List<IBatchProject> ps = null;
        try {
            ps = ClassPathMonitor.getProjects(this.batchProject.getProject());
        }
        catch (CoreException e) {
            BatchCorePlugin.pluginLog().logError((Throwable)e);
        }
        if (ps != null) {
            Set set = this.batchProject.getUsedProjects();
            HashSet removable = new HashSet();
            removable.addAll(set);
            removable.removeAll(ps);
            ps.removeAll(set);
            return !ps.isEmpty() || !removable.isEmpty();
        }
        return false;
    }

    public static List<IBatchProject> getProjects(IProject project) throws CoreException {
        ArrayList<IBatchProject> list = new ArrayList<IBatchProject>();
        IJavaProject javaProject = EclipseUtil.getJavaProject((IProject)project);
        if (javaProject != null) {
            IClasspathEntry[] es = javaProject.getResolvedClasspath(true);
            int i = 0;
            while (i < es.length) {
                BatchProject sp;
                IProject p;
                if (es[i].getEntryKind() == 2 && (p = ResourcesPlugin.getWorkspace().getRoot().getProject(es[i].getPath().lastSegment())) != null && p.isAccessible() && (sp = BatchProjectFactory.getBatchProject(p, false)) != null) {
                    list.add(sp);
                }
                ++i;
            }
        }
        return list;
    }

    private void detectBatchModule(String path, JarSet newJars) {
        newJars.getFileSystems().add(path);
        int archiveType = BatchArchiveDetector.getInstance().getBatchArchive(path);
        if (archiveType == -1) {
            try {
                archiveType = BatchArchiveDetector.getInstance().resolve(path, this.batchProject);
            }
            catch (JavaModelException e) {
                BatchCorePlugin.pluginLog().logError((Throwable)e);
                return;
            }
        }
        if (archiveType != 0) {
            newJars.getBatchModules().add(path);
        }
    }

    @Override
    public IProject getProjectResource() {
        return this.batchProject.getProject();
    }

    @Override
    public synchronized void libraryChanged(String path) {
        super.libraryChanged(path);
        this.removedPaths.add((IPath)new Path(path));
    }
}

