/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.cdi.seam.text.ext.hyperlink;

import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMAttr;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.jboss.tools.cdi.seam.config.core.util.Util;
import org.jboss.tools.cdi.seam.text.ext.hyperlink.SeamConfigTagNameHyperlink;
import org.jboss.tools.common.text.ext.hyperlink.AbstractHyperlinkPartitioner;
import org.jboss.tools.common.text.ext.hyperlink.HyperlinkRegion;
import org.jboss.tools.common.text.ext.hyperlink.IHyperlinkPartitionRecognizer;
import org.jboss.tools.common.text.ext.hyperlink.IHyperlinkRegion;
import org.jboss.tools.common.text.ext.util.StructuredModelWrapper;
import org.jboss.tools.common.text.ext.util.Utils;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class SeamConfigTagNameHyperlinkPartitioner
extends AbstractHyperlinkPartitioner
implements IHyperlinkPartitionRecognizer {
    public static final String SEAM_CONFIG_TAG_NAME_PARTITION = "org.jboss.tools.common.text.ext.jsp.SEAM_CONFIG_TAG_NAME";

    protected IHyperlinkRegion parse(IDocument document, int offset, IHyperlinkRegion superRegion) {
        StructuredModelWrapper smw = new StructuredModelWrapper();
        smw.init(document);
        try {
            Document xmlDocument = smw.getDocument();
            if (xmlDocument == null) {
                return null;
            }
            IRegion r = this.getRegion(document, offset);
            if (r == null) {
                return null;
            }
            String axis = this.getAxis(document, offset);
            String contentType = superRegion.getContentType();
            String type = SEAM_CONFIG_TAG_NAME_PARTITION;
            HyperlinkRegion hyperlinkRegion = new HyperlinkRegion(r.getOffset(), r.getLength(), axis, contentType, type);
            return hyperlinkRegion;
        }
        finally {
            smw.dispose();
        }
    }

    public boolean recognize(IDocument document, int offset, IHyperlinkRegion region) {
        StructuredModelWrapper smw = new StructuredModelWrapper();
        smw.init(document);
        try {
            IFile documentFile = smw.getFile();
            if (documentFile == null) {
                return false;
            }
            boolean bl = documentFile.getProject() != null;
            return bl;
        }
        finally {
            smw.dispose();
        }
    }

    protected IRegion getRegion(IDocument document, int offset) {
        StructuredModelWrapper smw = new StructuredModelWrapper();
        smw.init(document);
        try {
            Document xmlDocument = smw.getDocument();
            if (xmlDocument == null) {
                return null;
            }
            Node n = Utils.findNodeForOffset((Node)xmlDocument, (int)offset);
            if (n == null) {
                return null;
            }
            IDOMAttr attr = null;
            IDOMElement elem = null;
            if (n instanceof IDOMElement) {
                elem = (IDOMElement)n;
            } else if (n instanceof IDOMAttr && (attr = (IDOMAttr)n).getOwnerElement() instanceof IDOMElement) {
                elem = (IDOMElement)attr.getOwnerElement();
            }
            if (elem == null) {
                return null;
            }
            String tagName = elem.getTagName();
            String uri = SeamConfigTagNameHyperlink.getURI((Node)elem, document, offset);
            String[] pks = Util.getPackages((String)uri);
            if (pks.length == 0) {
                return null;
            }
            if (attr != null) {
                int nameStart = attr.getStartOffset();
                int nameEnd = nameStart + attr.getName().length();
                Region region = new Region(nameStart, nameEnd - nameStart);
                return region;
            }
            int start = Utils.getValueStart((Node)elem);
            int nameStart = start + (elem.isEndTag() ? "</" : "<").length();
            int nameEnd = nameStart + tagName.length();
            if (nameStart > offset || nameEnd <= offset) {
                return null;
            }
            Region region = new Region(nameStart, nameEnd - nameStart);
            return region;
        }
        finally {
            smw.dispose();
        }
    }
}

