/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.cdi.seam.text.ext.hyperlink;

import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.jboss.tools.cdi.core.CDICoreNature;
import org.jboss.tools.cdi.core.CDIUtil;
import org.jboss.tools.cdi.seam.config.core.CDISeamConfigExtension;
import org.jboss.tools.cdi.seam.config.core.definition.SeamBeansDefinition;
import org.jboss.tools.cdi.seam.config.core.definition.SeamFieldDefinition;
import org.jboss.tools.cdi.seam.config.core.definition.SeamMemberDefinition;
import org.jboss.tools.cdi.seam.config.core.definition.SeamMethodDefinition;
import org.jboss.tools.cdi.seam.config.core.util.Util;
import org.jboss.tools.cdi.seam.text.ext.CDISeamExtPlugin;
import org.jboss.tools.cdi.text.ext.hyperlink.InjectedPointHyperlinkDetector;
import org.jboss.tools.common.model.ui.editor.EditorPartWrapper;
import org.jboss.tools.common.text.ext.util.StructuredModelWrapper;
import org.jboss.tools.common.text.ext.util.Utils;
import org.jboss.tools.jst.web.ui.internal.text.ext.hyperlink.jsp.JSPRootHyperlinkPartitioner;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class XMLInjectedPointHyperlinkDetector
extends InjectedPointHyperlinkDetector {
    private static final String INJECT_NAME = "Inject";
    private static final String INJECT_URI = "urn:java:ee";

    public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
        this.viewer = textViewer;
        if (region == null || !canShowMultipleHyperlinks) {
            return null;
        }
        IEditorPart editor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        if (!(editor instanceof EditorPartWrapper)) {
            return null;
        }
        IEditorInput input = ((EditorPartWrapper)editor).getEditorInput();
        if (!(input instanceof FileEditorInput)) {
            return null;
        }
        this.file = ((FileEditorInput)input).getFile();
        if (this.file == null) {
            return null;
        }
        CDICoreNature cdiNature = CDIUtil.getCDINatureWithProgress((IProject)this.file.getProject());
        if (cdiNature == null) {
            return null;
        }
        this.document = textViewer.getDocument();
        ArrayList hyperlinks = new ArrayList();
        Node node = this.getTagNode(region.getOffset());
        if (node == null) {
            return null;
        }
        int offset = ((IndexedRegion)node).getStartOffset();
        String uri = this.getURI(node);
        IType element = null;
        IType type = Util.resolveType((String)node.getLocalName(), (String)uri, (CDICoreNature)cdiNature);
        if (type != null) {
            element = type;
        } else {
            SeamMemberDefinition def = this.find(cdiNature, offset, this.file);
            if (def instanceof SeamFieldDefinition) {
                element = ((SeamFieldDefinition)def).getField();
            } else if (def instanceof SeamMethodDefinition) {
                element = ((SeamMethodDefinition)def).getMethod();
            }
        }
        if (element != null) {
            IFile elementFile = null;
            try {
                elementFile = (IFile)element.getUnderlyingResource();
            }
            catch (JavaModelException ex) {
                CDISeamExtPlugin.getDefault().logError(ex);
            }
            if (elementFile != null) {
                this.findInjectedBeans(cdiNature, (IJavaElement)element, offset, elementFile.getFullPath(), hyperlinks, editor.isDirty());
            }
            if (hyperlinks != null && !hyperlinks.isEmpty()) {
                return hyperlinks.toArray(new IHyperlink[hyperlinks.size()]);
            }
        }
        return null;
    }

    private Node getTagNode(int offset) {
        StructuredModelWrapper smw = new StructuredModelWrapper();
        smw.init(this.document);
        try {
            Document xmlDocument = smw.getDocument();
            if (xmlDocument == null) {
                return null;
            }
            Node node = Utils.findNodeForOffset((Node)xmlDocument, (int)offset);
            if (node == null) {
                return null;
            }
            if (node instanceof IDOMElement) {
                if (INJECT_NAME.equals(node.getLocalName()) && INJECT_URI.equals(node.getNamespaceURI())) {
                    Node node2 = node.getParentNode();
                    return node2;
                }
                if (offset >= ((IDOMElement)node).getStartOffset() && offset <= ((IDOMElement)node).getStartEndOffset()) {
                    Node node3 = node;
                    return node3;
                }
            }
            return null;
        }
        finally {
            smw.dispose();
        }
    }

    SeamMemberDefinition find(CDICoreNature cdi, int offset, IFile documentFile) {
        CDISeamConfigExtension ext = CDISeamConfigExtension.getExtension((CDICoreNature)cdi);
        if (ext == null) {
            return null;
        }
        SeamBeansDefinition def = ext.getContext().getDefinition(documentFile.getFullPath());
        if (def == null) {
            return null;
        }
        return def.findExactly(offset);
    }

    private String getURI(Node node) {
        String nodeName = node.getNodeName();
        if (nodeName.indexOf(58) == -1) {
            return null;
        }
        String nodePrefix = nodeName.substring(0, nodeName.indexOf(":"));
        if (nodePrefix == null || nodePrefix.length() == 0) {
            return null;
        }
        Map trackers = JSPRootHyperlinkPartitioner.getTrackersMap((IDocument)this.document, (int)((IndexedRegion)node).getStartOffset());
        return trackers == null ? null : trackers.get(nodePrefix);
    }
}

