/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.el.refactoring;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RefactoringParticipant;
import org.eclipse.ltk.core.refactoring.participants.SharableParticipants;
import org.eclipse.ltk.internal.core.refactoring.Messages;
import org.jboss.tools.common.el.core.ElCoreMessages;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.project.IModelNature;
import org.jboss.tools.common.model.refactoring.RenameModelObjectChange;
import org.jboss.tools.common.model.util.EclipseResourceUtil;
import org.jboss.tools.jsf.el.refactoring.ELRenameProcessor;
import org.jboss.tools.jsf.model.pv.JSFBeanSearcher;

public class RenameELVariableProcessor
extends ELRenameProcessor {
    private static final String MANAGED_BEAN_NAME_ATTRIBUTE = "managed-bean-name";
    IFile file;

    public RenameELVariableProcessor(IFile file, String oldName) {
        super(file, oldName);
        this.file = file;
        this.setOldName(oldName);
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm, CheckConditionsContext context) throws CoreException, OperationCanceledException {
        this.status = new RefactoringStatus();
        this.rootChange = new CompositeChange(ElCoreMessages.RENAME_EL_VARIABLE_PROCESSOR_TITLE);
        this.renameELVariable(pm, this.file);
        return this.status;
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        RefactoringStatus result = new RefactoringStatus();
        if (RenameELVariableProcessor.findManagedBean(this.file, this.getOldName()) == null) {
            result.addFatalError(Messages.format((String)ElCoreMessages.RENAME_EL_VARIABLE_PROCESSOR_CAN_NOT_FIND_EL_VARIABLE, (Object)this.getOldName()));
        }
        return result;
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        return this.rootChange;
    }

    public Object[] getElements() {
        return new String[]{this.getNewName()};
    }

    public String getIdentifier() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public String getProcessorName() {
        return ElCoreMessages.RENAME_EL_VARIABLE_PROCESSOR_TITLE;
    }

    public boolean isApplicable() throws CoreException {
        return this.getNewName() != null;
    }

    public RefactoringParticipant[] loadParticipants(RefactoringStatus status, SharableParticipants sharedParticipants) throws CoreException {
        return EMPTY_REF_PARTICIPANT;
    }

    private void renameELVariable(IProgressMonitor pm, IFile file) {
        XModelObject managedBean = RenameELVariableProcessor.findManagedBean(file, this.getOldName());
        if (managedBean != null) {
            RenameModelObjectChange managedBeanChange = RenameModelObjectChange.createChange((XModelObject[])new XModelObject[]{managedBean}, (String)this.getNewName(), (String)MANAGED_BEAN_NAME_ATTRIBUTE);
            this.rootChange.add((Change)managedBeanChange);
            this.getSearcher().findELReferences(pm);
        }
    }

    public static XModelObject findManagedBean(IFile file, String name) {
        IModelNature nature = EclipseResourceUtil.getModelNature((IProject)file.getProject());
        if (nature == null) {
            return null;
        }
        XModel model = nature.getModel();
        if (model == null) {
            return null;
        }
        JSFBeanSearcher beanSearcher = new JSFBeanSearcher(model);
        beanSearcher.parse(name);
        XModelObject managedBean = beanSearcher.getBean();
        return managedBean;
    }

    public static String getManagedBeanName(IFile file, String text) {
        XModelObject managedBean = RenameELVariableProcessor.findManagedBean(file, text);
        if (managedBean != null) {
            return managedBean.getAttributeValue(MANAGED_BEAN_NAME_ATTRIBUTE);
        }
        return null;
    }
}

