/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.jsf2.bean.model;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.jboss.tools.jsf.JSFModelPlugin;
import org.jboss.tools.jsf.jsf2.bean.model.IJSF2Project;
import org.jboss.tools.jsf.jsf2.bean.model.impl.JSF2Project;
import org.jboss.tools.jsf.messages.JSFUIMessages;
import org.jboss.tools.jst.web.kb.KbProjectFactory;
import org.jboss.tools.jst.web.kb.internal.KbProject;

public class JSF2ProjectFactory {
    private static final String MODEL_ID = "JSF2";

    public static IJSF2Project getJSF2Project(IProject project, boolean resolve) {
        JSF2Project result = null;
        KbProject kb = (KbProject)KbProjectFactory.getKbProject((IProject)project, (boolean)resolve);
        if (kb != null && (result = (JSF2Project)kb.getExtensionModel(MODEL_ID)) == null) {
            result = new JSF2Project();
            result.setProject(project);
            kb.setExtensionModel(MODEL_ID, (Object)result);
        }
        if (result != null && resolve) {
            result.resolve();
        }
        return result;
    }

    public static IJSF2Project getJSF2ProjectWithProgress(final IProject project) {
        IJSF2Project jsf = JSF2ProjectFactory.getJSF2Project(project, false);
        if (jsf != null && !jsf.isStorageResolved()) {
            if (Display.getCurrent() != null) {
                try {
                    PlatformUI.getWorkbench().getProgressService().busyCursorWhile(new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                            monitor.beginTask(JSFUIMessages.BUILD_JSF2_MODEL, 10);
                            monitor.worked(3);
                            JSF2ProjectFactory.getJSF2Project(project, true);
                            monitor.worked(7);
                        }
                    });
                }
                catch (InterruptedException ie) {
                    JSFModelPlugin.getDefault().logError(ie);
                }
                catch (InvocationTargetException ite) {
                    JSFModelPlugin.getDefault().logError(ite);
                }
            } else {
                JSF2ProjectFactory.getJSF2Project(project, true);
            }
        }
        return jsf;
    }
}

