/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.jsf2.bean.model.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.jboss.tools.common.model.util.EclipseResourceUtil;
import org.jboss.tools.jsf.jsf2.bean.model.impl.FacesConfigDefinition;
import org.jboss.tools.jsf.jsf2.bean.model.impl.JSF2Project;
import org.jboss.tools.jsf.jsf2.bean.model.impl.TypeDefinition;

public class DefinitionContext {
    protected JSF2Project project;
    protected IJavaProject javaProject;
    private Set<String> types = new HashSet<String>();
    private Map<IPath, Set<IPath>> childPaths = new HashMap<IPath, Set<IPath>>();
    private Map<IPath, Set<String>> resources = new HashMap<IPath, Set<String>>();
    private Map<String, TypeDefinition> typeDefinitions = new HashMap<String, TypeDefinition>();
    FacesConfigDefinition facesConfig = null;
    private DefinitionContext workingCopy;
    private DefinitionContext original;

    private synchronized DefinitionContext copy(boolean clean) {
        DefinitionContext copy = new DefinitionContext();
        copy.project = this.project;
        copy.javaProject = this.javaProject;
        if (!clean) {
            HashSet<String> s1;
            Set<String> set;
            copy.types.addAll(this.types);
            copy.typeDefinitions.putAll(this.typeDefinitions);
            copy.facesConfig = this.facesConfig;
            for (IPath p : this.resources.keySet()) {
                set = this.resources.get(p);
                if (set == null) continue;
                s1 = new HashSet<String>();
                s1.addAll(set);
                copy.resources.put(p, s1);
            }
            for (IPath p : this.childPaths.keySet()) {
                set = this.childPaths.get(p);
                if (set == null) continue;
                s1 = new HashSet();
                s1.addAll(set);
                copy.childPaths.put(p, s1);
            }
        }
        return copy;
    }

    public void setProject(JSF2Project project) {
        this.project = project;
        this.javaProject = EclipseResourceUtil.getJavaProject((IProject)project.getProject());
    }

    public JSF2Project getProject() {
        return this.project;
    }

    public IJavaProject getJavaProject() {
        return this.javaProject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addType(IPath file, String typeName, TypeDefinition def) {
        this.addType(file, typeName);
        if (def != null) {
            DefinitionContext definitionContext = this;
            synchronized (definitionContext) {
                this.typeDefinitions.put(def.getQualifiedName(), def);
            }
        }
    }

    public void setFacesConfig(FacesConfigDefinition def) {
        this.facesConfig = def;
        if (def != null) {
            this.addToParents(def.getPath());
        }
    }

    public synchronized void addType(IPath file, String typeName) {
        if (file != null) {
            Set<String> ts = this.resources.get(file);
            if (ts == null) {
                ts = new HashSet<String>();
                this.resources.put(file, ts);
            }
            ts.add(typeName);
            this.types.add(typeName);
            this.addToParents(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToParents(IPath file) {
        if (file == null) {
            return;
        }
        if (file.segmentCount() < 2) {
            return;
        }
        IPath q = file;
        while (q.segmentCount() >= 2) {
            q = q.removeLastSegments(1);
            DefinitionContext definitionContext = this;
            synchronized (definitionContext) {
                Set<IPath> cs = this.childPaths.get(q);
                if (cs == null) {
                    cs = new HashSet<IPath>();
                    this.childPaths.put(q, cs);
                }
                cs.add(file);
            }
        }
    }

    public synchronized void clean() {
        this.childPaths.clear();
        this.resources.clear();
        this.types.clear();
        this.facesConfig = null;
        this.typeDefinitions.clear();
    }

    public synchronized void clean(IPath path) {
        Set<IPath> cs;
        Set<String> ts = this.resources.remove(path);
        if (ts != null) {
            for (String t : ts) {
                this.clean(t);
            }
        }
        if (this.facesConfig != null && path.equals((Object)this.facesConfig.getPath())) {
            this.facesConfig = null;
        }
        if ((cs = this.childPaths.get(path)) != null) {
            IPath[] ps;
            IPath[] iPathArray = ps = cs.toArray(new IPath[0]);
            int n = ps.length;
            int n2 = 0;
            while (n2 < n) {
                IPath p = iPathArray[n2];
                this.clean(p);
                ++n2;
            }
        } else {
            this.removeFromParents(path);
        }
    }

    public synchronized void clean(String typeName) {
        this.types.remove(typeName);
        this.typeDefinitions.remove(typeName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeFromParents(IPath file) {
        if (file == null) {
            return;
        }
        IPath q = file;
        while (q.segmentCount() >= 2) {
            q = q.removeLastSegments(1);
            DefinitionContext definitionContext = this;
            synchronized (definitionContext) {
                Set<IPath> cs = this.childPaths.get(q);
                if (cs != null) {
                    cs.remove(file);
                    if (cs.isEmpty()) {
                        this.childPaths.remove(q);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getAnnotationKind(IType annotationType) {
        if (annotationType == null) {
            return -1;
        }
        if (!annotationType.exists()) {
            return -1;
        }
        String name = annotationType.getFullyQualifiedName();
        DefinitionContext definitionContext = this;
        synchronized (definitionContext) {
            if (this.types.contains(name)) {
                return 0;
            }
        }
        if ("javax.faces.bean.ManagedBean".equals(name)) {
            return 1;
        }
        return 0;
    }

    public void newWorkingCopy(boolean forFullBuild) {
        if (this.original != null) {
            return;
        }
        this.workingCopy = this.copy(forFullBuild);
        this.workingCopy.original = this;
    }

    public DefinitionContext getWorkingCopy() {
        if (this.original != null) {
            return this;
        }
        if (this.workingCopy != null) {
            return this.workingCopy;
        }
        this.workingCopy = this.copy(false);
        this.workingCopy.original = this;
        return this.workingCopy;
    }

    public void applyWorkingCopy() {
        if (this.original != null) {
            this.original.applyWorkingCopy();
            return;
        }
        if (this.workingCopy == null) {
            return;
        }
        HashSet<TypeDefinition> newTypeDefinitions = new HashSet<TypeDefinition>();
        for (String typeName : this.workingCopy.typeDefinitions.keySet()) {
            TypeDefinition nd = this.workingCopy.typeDefinitions.get(typeName);
            TypeDefinition od = this.typeDefinitions.get(typeName);
            if (od == nd) continue;
            newTypeDefinitions.add(nd);
        }
        this.types = this.workingCopy.types;
        this.resources = this.workingCopy.resources;
        this.childPaths = this.workingCopy.childPaths;
        this.typeDefinitions = this.workingCopy.typeDefinitions;
        this.facesConfig = this.workingCopy.facesConfig;
        this.project.update(true);
        this.workingCopy = null;
    }

    public void dropWorkingCopy() {
        if (this.original != null) {
            this.original.dropWorkingCopy();
        } else {
            this.workingCopy = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TypeDefinition> getTypeDefinitions() {
        ArrayList<TypeDefinition> result = new ArrayList<TypeDefinition>();
        DefinitionContext definitionContext = this;
        synchronized (definitionContext) {
            result.addAll(this.typeDefinitions.values());
        }
        return result;
    }

    public synchronized TypeDefinition getTypeDefinition(String fullyQualifiedName) {
        return this.typeDefinitions.get(fullyQualifiedName);
    }

    public FacesConfigDefinition getFacesConfig() {
        return this.facesConfig;
    }
}

