/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.jsf2.refactoring;

import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RenameParticipant;
import org.eclipse.ui.ide.IDE;
import org.jboss.tools.jsf.jsf2.refactoring.JSf2MoveParticipant;
import org.jboss.tools.jsf.jsf2.refactoring.RefactoringChangesFactory;
import org.jboss.tools.jsf.jsf2.refactoring.core.StructuredChanges;
import org.jboss.tools.jsf.messages.JSFUIMessages;

public class JSF2RenameParticipant
extends RenameParticipant {
    private IProject project;
    private String URI;
    private String oldFileName;
    private Object element;
    private Map<String, String> urisMap;

    public RefactoringStatus checkConditions(IProgressMonitor pm, CheckConditionsContext context) throws OperationCanceledException {
        return new RefactoringStatus();
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        String newFileName = this.getArguments().getNewName();
        if (this.element instanceof IFolder) {
            IFolder folder = (IFolder)this.element;
            IPath newPath = folder.getFullPath().removeLastSegments(1).append(newFileName);
            if (JSf2MoveParticipant.checkDistContainerPath(newPath)) {
                this.urisMap = JSf2MoveParticipant.invokePossibleURIs((IContainer)folder, newPath, false);
                return RefactoringChangesFactory.createRenameURIChanges((IResource)this.project, this.urisMap);
            }
            return null;
        }
        if (this.project == null || newFileName == null || this.oldFileName == null) {
            return null;
        }
        this.oldFileName = this.oldFileName.substring(0, this.oldFileName.lastIndexOf(46));
        newFileName = newFileName.substring(0, newFileName.lastIndexOf(46));
        StructuredChanges changes = RefactoringChangesFactory.createRenameCompositeComponentsChanges((IResource)this.project, this.URI, this.oldFileName, newFileName);
        this.project = null;
        this.URI = null;
        this.oldFileName = null;
        return changes;
    }

    public String getName() {
        return JSFUIMessages.Rename_JSF_2_Composite_Components;
    }

    protected boolean initialize(Object element) {
        IFolder folder;
        this.element = element;
        if (element instanceof IFile) {
            IFile file = (IFile)element;
            this.URI = this.calcURIFromPath(file.getFullPath());
            if (this.checkContentType(file)) {
                this.project = file.getProject();
                this.oldFileName = file.getName();
                return true;
            }
        } else if (element instanceof IFolder && JSf2MoveParticipant.checkResourceContainerPath((folder = (IFolder)element).getFullPath())) {
            this.project = folder.getProject();
            this.oldFileName = folder.getName();
            return true;
        }
        return false;
    }

    private boolean checkContentType(IFile file) {
        if (this.URI == null || this.URI.equals("")) {
            return false;
        }
        if (!"xhtml".equals(file.getFileExtension())) {
            return false;
        }
        IContentType contentType = IDE.getContentType((IFile)file);
        return "jsf.facelet.composite".equals(contentType.getId()) || "jsf.facelet".equals(contentType.getId());
    }

    private String calcURIFromPath(IPath path) {
        StringBuilder uri = new StringBuilder("");
        String[] segments = path.segments();
        if (segments.length > 3 && segments[2].equals("resources")) {
            int i = 3;
            while (i < segments.length - 1) {
                uri.append("/" + segments[i]);
                ++i;
            }
            uri.insert(0, "http://java.sun.com/jsf/composite");
        }
        return uri.toString();
    }
}

