/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.jboss.tools.common.el.core.ELCorePlugin;
import org.jboss.tools.common.el.core.model.ELExpression;
import org.jboss.tools.common.el.core.model.ELInvocationExpression;
import org.jboss.tools.common.el.core.resolver.ELContext;
import org.jboss.tools.common.el.core.resolver.ELResolution;
import org.jboss.tools.common.el.core.resolver.ELResolutionImpl;
import org.jboss.tools.common.el.core.resolver.TypeInfoCollector;
import org.jboss.tools.common.model.util.EclipseJavaUtil;
import org.jboss.tools.common.model.util.EclipseResourceUtil;
import org.jboss.tools.jsf.JSFModelPlugin;
import org.jboss.tools.jsf.model.JSFELCompletionEngine;
import org.jboss.tools.jst.web.kb.PageContextFactory;
import org.jboss.tools.jst.web.kb.internal.XmlContextImpl;
import org.jboss.tools.jst.web.kb.taglib.IELFunction;
import org.jboss.tools.jst.web.kb.taglib.IFunctionLibrary;
import org.jboss.tools.jst.web.kb.taglib.INameSpace;
import org.jboss.tools.jst.web.kb.taglib.ITagLibrary;
import org.jboss.tools.jst.web.kb.taglib.TagLibraryManager;

public class JSFFuncsELCompletionEngine
extends JSFELCompletionEngine {
    @Override
    protected TypeInfoCollector.MemberInfo getMemberInfoByVariable(JSFELCompletionEngine.IJSFVariable var, ELContext context, boolean onlyEqualNames, int offset) {
        if (!(var instanceof Variable)) {
            return null;
        }
        Variable variable = (Variable)var;
        IType sourceMember = (IType)variable.getSourceMember();
        if (variable.funcResolvedMethod == null) {
            return null;
        }
        TypeInfoCollector.ArtificialTypeInfo result = null;
        try {
            result = new TypeInfoCollector.ArtificialTypeInfo(sourceMember, variable.funcResolvedMethod, variable.funcName);
        }
        catch (JavaModelException e) {
            ELCorePlugin.getPluginLog().logError((Throwable)e);
        }
        return result;
    }

    public ELResolution resolve(ELContext context, ELExpression operand, int offset) {
        if (operand.getText().indexOf(58) > 0) {
            return super.resolve(context, operand, offset);
        }
        return new ELResolutionImpl(operand);
    }

    @Override
    public List<JSFELCompletionEngine.IJSFVariable> resolveVariables(IFile file, ELContext context, ELInvocationExpression expr, boolean isFinal, boolean onlyEqualNames, int offset) {
        return this.resolveVariablesInternal(file, expr, isFinal, onlyEqualNames, offset);
    }

    private List<JSFELCompletionEngine.IJSFVariable> resolveVariablesInternal(IFile file, ELInvocationExpression expr, boolean isFinal, boolean onlyEqualNames, int offset) {
        ELContext context = PageContextFactory.createPageContext((IFile)file);
        if (!(context instanceof XmlContextImpl)) {
            return Collections.emptyList();
        }
        ITagLibrary[] libraries = TagLibraryManager.getLibraries((IProject)file.getProject());
        if (libraries.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<JSFELCompletionEngine.IJSFVariable> result = new ArrayList<JSFELCompletionEngine.IJSFVariable>();
        String varName = expr.toString();
        Map namespacesByOffset = ((XmlContextImpl)context).getNameSpaces(offset);
        ITagLibrary[] iTagLibraryArray = libraries;
        int n = libraries.length;
        int n2 = 0;
        while (n2 < n) {
            String uri;
            Collection namespaces;
            ITagLibrary l = iTagLibraryArray[n2];
            if (l instanceof IFunctionLibrary && (namespaces = (Collection)namespacesByOffset.get(uri = l.getURI())) != null) {
                for (INameSpace ns : namespaces) {
                    IELFunction[] functions;
                    String name = ns.getPrefix();
                    if ((!isFinal || onlyEqualNames) && !name.equals(varName) || !name.startsWith(varName) || varName.lastIndexOf(46) > name.length() || (functions = ((IFunctionLibrary)l).getFunctions()) == null) continue;
                    IELFunction[] iELFunctionArray = functions;
                    int n3 = functions.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IELFunction f = iELFunctionArray[n4];
                        String funcClass = f.getFunctionClass();
                        String funcSignature = f.getFunctionSignature();
                        String funcName = f.getName();
                        Variable v = new Variable(name, file, funcName, funcClass, funcSignature);
                        result.add(v);
                        ++n4;
                    }
                }
            }
            ++n2;
        }
        return result;
    }

    static class Variable
    implements JSFELCompletionEngine.IJSFVariable {
        IFile f;
        String name;
        String funcName;
        String funcClass;
        String funcSignature;
        IMethod funcResolvedMethod;
        IType funcSourceMember;

        public Variable(String name, IFile f, String funcName, String funcClass, String funcSignature) {
            this.name = name;
            this.f = f;
            this.funcName = funcName;
            this.funcClass = funcClass;
            this.funcSignature = funcSignature;
            this.funcResolvedMethod = null;
        }

        public String getName() {
            return this.name;
        }

        public Collection<String> getKeys() {
            ArrayList<String> result = new ArrayList<String>();
            if (this.funcResolvedMethod != null) {
                return result;
            }
            if (this.f == null || this.f.getProject() == null) {
                return result;
            }
            this.funcSourceMember = EclipseResourceUtil.getValidType((IProject)this.f.getProject(), (String)this.funcClass);
            if (this.funcSourceMember == null) {
                return result;
            }
            IType currentType = this.funcSourceMember;
            try {
                while (currentType != null) {
                    IMethod[] binMethods = currentType.getMethods();
                    if (binMethods != null) {
                        IMethod[] iMethodArray = binMethods;
                        int n = binMethods.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IMethod method = iMethodArray[n2];
                            if (!method.isConstructor() && (method.getFlags() & 8) != 0) {
                                String methodReturnType;
                                String methodName = method.getElementName();
                                String methodReturnTypeSimple = methodReturnType = method.getReturnType();
                                if (Signature.getTypeSignatureKind((String)methodReturnType) == 2) {
                                    methodReturnTypeSimple = methodReturnType = Signature.toString((String)methodReturnType);
                                } else {
                                    methodReturnType = EclipseJavaUtil.resolveTypeAsString((IType)currentType, (String)methodReturnType);
                                    methodReturnTypeSimple = Signature.getSimpleName((String)methodReturnType);
                                }
                                String[] methodParamTypes = method.getParameterTypes();
                                int paramTypesCount = methodParamTypes == null ? 0 : methodParamTypes.length;
                                int startParamIndex = this.funcSignature.indexOf(40);
                                int endParamIndex = this.funcSignature.indexOf(41);
                                if (startParamIndex != -1 && endParamIndex != -1 && startParamIndex <= endParamIndex) {
                                    String paramsString = this.funcSignature.substring(startParamIndex + 1, endParamIndex);
                                    String[] params = paramsString.split(",");
                                    if ((this.funcSignature.substring(0, startParamIndex).contains(methodReturnType) || this.funcSignature.substring(0, startParamIndex).contains(methodReturnTypeSimple)) && this.funcSignature.substring(0, startParamIndex).contains(methodName)) {
                                        int paramsCount;
                                        int n3 = paramsCount = params == null ? 0 : params.length;
                                        if (paramTypesCount == paramsCount) {
                                            boolean paramsAreEqual = true;
                                            int i = 0;
                                            while (methodParamTypes != null && i < methodParamTypes.length) {
                                                String methodParamType;
                                                String methodParamTypeSimple = methodParamType = methodParamTypes[i];
                                                if (Signature.getTypeSignatureKind((String)methodParamType) == 2) {
                                                    methodReturnTypeSimple = methodParamType = Signature.toString((String)methodParamType);
                                                } else {
                                                    methodParamType = EclipseJavaUtil.resolveTypeAsString((IType)currentType, (String)methodParamType);
                                                    methodParamTypeSimple = Signature.getSimpleName((String)methodParamType);
                                                }
                                                if (params[i] == null || !params[i].trim().equals(methodParamType) && !params[i].trim().equals(methodParamTypeSimple)) {
                                                    paramsAreEqual = false;
                                                    break;
                                                }
                                                ++i;
                                            }
                                            if (paramsAreEqual) {
                                                this.funcResolvedMethod = method;
                                                result.add(this.funcName);
                                                break;
                                            }
                                        }
                                    }
                                }
                            }
                            ++n2;
                        }
                    }
                    currentType = TypeInfoCollector.getSuperclass((IType)currentType);
                }
            }
            catch (JavaModelException e) {
                JSFModelPlugin.getDefault().logError("An error occurred while retrieving methods for type '" + this.funcClass + "'", e);
            }
            return result;
        }

        @Override
        public IMember getSourceMember() {
            this.getKeys();
            return this.funcSourceMember;
        }
    }
}

