/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.model;

import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.impl.OrderedObjectImpl;
import org.jboss.tools.jsf.model.JSFConstants;
import org.jboss.tools.jst.web.model.ReferenceObject;

public class ReferenceGroupImpl
extends OrderedObjectImpl
implements ReferenceObject,
JSFConstants {
    private static final long serialVersionUID = 6904636256636930824L;
    private XModelObject[] reference = new XModelObject[0];
    private long[] referenceTimeStamp = new long[0];
    private boolean isUpToDate = true;

    public void setReference(XModelObject[] rs) {
        if (this.isReferenceEqual(rs)) {
            return;
        }
        this.isUpToDate = false;
        long[] rts = new long[rs.length];
        int i = 0;
        while (i < rs.length) {
            rts[i] = i < this.reference.length && this.reference[i] == rs[i] ? this.referenceTimeStamp[i] : -1L;
            ++i;
        }
        this.reference = rs;
        this.referenceTimeStamp = rts;
        this.saveShapeToReference(this.get("SHAPE"));
    }

    void saveShapeToReference(String shape) {
        if (shape != null && shape.length() > 0) {
            int i = 0;
            while (i < this.reference.length) {
                this.reference[i].set("_shape_g", shape);
                ++i;
            }
        }
    }

    public XModelObject[] getReferences() {
        return this.reference;
    }

    public boolean isUpToDate() {
        if (!this.isUpToDate) {
            return false;
        }
        int i = 0;
        while (i < this.reference.length) {
            if (!this.isUpToDate(i)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void notifyUpdate() {
        this.isUpToDate = true;
        int i = 0;
        while (i < this.reference.length) {
            this.notifyUpdate(i);
            ++i;
        }
    }

    public boolean isUpToDate(int i) {
        return this.reference[i].getTimeStamp() == this.referenceTimeStamp[i];
    }

    public void notifyUpdate(int i) {
        this.referenceTimeStamp[i] = this.reference[i].getTimeStamp();
    }

    boolean isReferenceEqual(XModelObject[] rs) {
        if (rs.length != this.reference.length) {
            return false;
        }
        int i = 0;
        while (i < rs.length) {
            if (rs[i] != this.reference[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public String getPresentationString() {
        String s = this.getAttributeValue("path");
        if (s.length() == 0) {
            s = "[any]";
        }
        return s;
    }

    public void set(String name, String value) {
        if ("SHAPE".equals(name)) {
            this.saveShapeToReference(value);
        }
        super.set(name, value);
    }

    public String getMainIconName() {
        String path = this.getAttributeValue("path");
        if (path == null || path.length() == 0 || path.indexOf(42) > 0) {
            return "main.file.unknow_file";
        }
        if (path.endsWith(".jsp")) {
            return "main.file.jsp_file";
        }
        if (path.endsWith(".html") || path.endsWith(".htm")) {
            return "main.file.html_file";
        }
        return "main.file.unknow_file";
    }

    public XModelObject getReference() {
        return this.reference.length == 0 ? null : this.reference[0];
    }
}

