/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.model.handlers;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Properties;
import org.jboss.tools.common.meta.action.impl.DefaultWizardDataValidator;
import org.jboss.tools.common.meta.constraint.XProperty;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelException;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.files.handlers.CreateFileSupport;
import org.jboss.tools.common.model.filesystems.impl.FileAnyImpl;
import org.jboss.tools.common.model.undo.XTransactionUndo;
import org.jboss.tools.common.model.undo.XUndoManager;
import org.jboss.tools.common.model.undo.XUndoable;
import org.jboss.tools.common.model.util.EclipseResourceUtil;
import org.jboss.tools.jsf.messages.JSFUIMessages;
import org.jboss.tools.jsf.model.FacesProcessImpl;
import org.jboss.tools.jsf.model.JSFConstants;
import org.jboss.tools.jsf.model.JSFXModelUtil;
import org.jboss.tools.jsf.web.JSFWebHelper;
import org.jboss.tools.jst.web.model.helpers.WebAppHelper;

public class CreateFacesConfigSupport
extends CreateFileSupport
implements JSFConstants {
    static String REGISTER = "register in web.xml";

    public void reset() {
        super.reset();
        this.initDefaultName();
        this.initRegister();
    }

    void initDefaultName() {
        String name;
        XModelObject[] cs = CreateFacesConfigSupport.getFacesConfigs(this.getTarget());
        HashSet<String> names = new HashSet<String>();
        int i = 0;
        while (i < cs.length) {
            names.add(cs[i].getAttributeValue("name"));
            ++i;
        }
        if (cs.length == 0) {
            this.setAttributeValue(0, "name", "faces-config");
            return;
        }
        String namef = name = "faces-config";
        int i2 = 0;
        while (names.contains(namef)) {
            namef = String.valueOf(name) + "-" + ++i2;
        }
        this.setAttributeValue(0, "name", namef);
    }

    void initRegister() {
        if (this.checkRegister(this.getTarget(), this.getAttributeValue(0, REGISTER)) != null) {
            this.setAttributeValue(0, REGISTER, "no");
        }
    }

    protected void execute() throws XModelException {
        Properties p0 = this.extractStepData(0);
        XUndoManager undo = this.getTarget().getModel().getUndoManager();
        XTransactionUndo u = new XTransactionUndo(MessageFormat.format(JSFUIMessages.CreateFacesConfigSupport_CreateFacesConfig, this.getTarget().getAttributeValue("element type"), this.getTarget().getPresentationString()), 1);
        undo.addUndoable((XUndoable)u);
        try {
            try {
                this.doExecute(p0);
            }
            catch (RuntimeException e) {
                undo.rollbackTransactionInProgress();
                throw e;
            }
        }
        finally {
            u.commit();
        }
    }

    private void doExecute(Properties p0) throws XModelException {
        Properties p = this.extractStepData(0);
        String path = p.getProperty("name");
        XModelObject file = this.createFile(path = this.revalidatePath(path));
        if (file == null) {
            return;
        }
        FacesProcessImpl process = (FacesProcessImpl)file.getChildByPath("process");
        process.firePrepared();
        this.register(file.getParent(), file, p0);
        this.open(file);
    }

    private void register(XModelObject object, XModelObject created, Properties prop) throws XModelException {
        boolean register = "yes".equals(this.getAttributeValue(0, "register in web.xml"));
        if (!register) {
            return;
        }
        String uri = this.getURI(created);
        JSFWebHelper.registerFacesConfig(created.getModel(), uri);
    }

    private String getURI(XModelObject file) {
        String name;
        String result = "/" + FileAnyImpl.toFileName((XProperty)file);
        XModelObject o = file.getParent();
        while (o != null && o.getFileType() != 3) {
            result = "/" + o.getAttributeValue("name") + result;
            o = o.getParent();
        }
        String string = name = o == null ? null : o.getAttributeValue("name");
        if (o == null || !"WEB-ROOT".equals(name) && !name.startsWith("WEB-ROOT-")) {
            result = "/WEB-INF" + result;
        }
        return result;
    }

    protected DefaultWizardDataValidator createValidator() {
        return new CreateFacesConfigValidator();
    }

    private String checkRegister(XModelObject object, String register) {
        String fsn;
        if (!"yes".equals(register)) {
            return null;
        }
        XModelObject webxml = WebAppHelper.getWebApp((XModel)object.getModel());
        if (webxml == null) {
            if (!EclipseResourceUtil.hasNature((XModel)object.getModel(), (String)"org.jboss.tools.jsf.jsfnature")) {
                return JSFUIMessages.CreateFacesConfigHandler_JSFCapabilitiesAreMissing;
            }
            return JSFUIMessages.CreateFacesConfigHandler_WebXMLNotFound;
        }
        if ("yes".equals(webxml.get("isIncorrect"))) {
            return JSFUIMessages.CreateFacesConfigSupport_WebXMLIncorrect;
        }
        if (!webxml.isObjectEditable()) {
            return JSFUIMessages.CreateFacesConfigSupport_WebXMLReadOnly;
        }
        XModelObject fs = object;
        while (fs != null && fs.getFileType() != 3) {
            fs = fs.getParent();
        }
        if (!(fs == null || (fsn = fs.getAttributeValue("name")).equals("WEB-INF") || fsn.equals("WEB-ROOT") || fsn.startsWith("WEB-ROOT-"))) {
            return JSFUIMessages.CreateFacesConfigSupport_WebXMLCannotRegister;
        }
        return null;
    }

    public static XModelObject[] getFacesConfigs(XModelObject folder) {
        ArrayList<XModelObject> list = new ArrayList<XModelObject>();
        XModelObject[] xModelObjectArray = folder.getChildren();
        int n = xModelObjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            XModelObject o = xModelObjectArray[n2];
            if (JSFXModelUtil.isFacesConfig(o)) {
                list.add(o);
            }
            ++n2;
        }
        return list.toArray(new XModelObject[0]);
    }

    class CreateFacesConfigValidator
    extends CreateFileSupport.Validator {
        CreateFacesConfigValidator() {
            super((CreateFileSupport)CreateFacesConfigSupport.this);
        }

        public void validate(Properties data) {
            super.validate(data);
            if (this.message != null) {
                return;
            }
            this.message = CreateFacesConfigSupport.this.checkRegister(CreateFacesConfigSupport.this.getTargetFolder() == null ? CreateFacesConfigSupport.this.getTarget() : CreateFacesConfigSupport.this.getTargetFolder(), data.getProperty("register in web.xml"));
        }
    }
}

