/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.model.handlers;

import java.text.MessageFormat;
import java.util.Properties;
import org.jboss.tools.common.meta.constraint.XProperty;
import org.jboss.tools.common.model.ServiceDialog;
import org.jboss.tools.common.model.XModelException;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.filesystems.impl.DeleteFileHandler;
import org.jboss.tools.common.model.filesystems.impl.FileAnyImpl;
import org.jboss.tools.common.model.util.XModelObjectLoaderUtil;
import org.jboss.tools.jsf.messages.JSFUIMessages;
import org.jboss.tools.jsf.web.JSFWebHelper;

public class DeleteFacesConfigHandler
extends DeleteFileHandler {
    public void executeHandler(XModelObject object, Properties p) throws XModelException {
        String path = XModelObjectLoaderUtil.getResourcePath((XModelObject)object);
        if (object.getModel().getByPath("FileSystems/WEB-INF" + path) == object) {
            path = "/WEB-INF" + path;
        }
        boolean unregister = false;
        if (JSFWebHelper.isRegisterFacesConfig(object.getModel(), path)) {
            ServiceDialog d = object.getModel().getService();
            Properties pd = new Properties();
            String message = MessageFormat.format(JSFUIMessages.DeleteFacesConfigHandler_DeleteFacesConfig, FileAnyImpl.toFileName((XProperty)object));
            pd.setProperty("message", message);
            pd.setProperty("checkboxMessage", JSFUIMessages.DeleteFacesConfigHandler_DeleteReferenceFromWebXML);
            pd.put("checked", Boolean.TRUE);
            if (!d.openConfirm(pd)) {
                return;
            }
            Boolean b = (Boolean)pd.get("checked");
            unregister = b;
        }
        super.executeHandler(object, p);
        if (object.isActive()) {
            return;
        }
        if (unregister) {
            JSFWebHelper.unregisterFacesConfig(object.getModel(), path);
        }
    }

    public boolean getSignificantFlag(XModelObject object) {
        String path = XModelObjectLoaderUtil.getResourcePath((XModelObject)object);
        return !JSFWebHelper.isRegisterFacesConfig(object.getModel(), path);
    }
}

