/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.model.handlers;

import java.text.MessageFormat;
import java.util.Properties;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IType;
import org.jboss.tools.common.meta.action.SignificanceMessageFactory;
import org.jboss.tools.common.meta.action.impl.SpecialWizardSupport;
import org.jboss.tools.common.meta.action.impl.handlers.DefaultRemoveHandler;
import org.jboss.tools.common.model.ServiceDialog;
import org.jboss.tools.common.model.XModelException;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.plugin.ModelPlugin;
import org.jboss.tools.jsf.messages.JSFUIMessages;
import org.jboss.tools.jsf.model.pv.JSFProjectBeans;
import org.jboss.tools.jsf.model.pv.JSFProjectsRoot;
import org.jboss.tools.jsf.model.pv.JSFProjectsTree;

public class DeleteManagedBeanHandler
extends DefaultRemoveHandler {
    public void executeHandler(XModelObject object, Properties p) throws XModelException {
        ServiceDialog d;
        boolean unregister = false;
        IFile f = this.getJavaFile(object);
        if (f != null) {
            d = object.getModel().getService();
            Properties pd = new Properties();
            String message = String.valueOf(SignificanceMessageFactory.getInstance().getMessage(this.action, object, null)) + "?";
            pd.setProperty("message", message);
            pd.setProperty("checkboxMessage", JSFUIMessages.DELETE_JAVA_SOURCE);
            pd.put("checked", Boolean.FALSE);
            if (!d.openConfirm(pd)) {
                return;
            }
            Boolean b = (Boolean)pd.get("checked");
            unregister = b;
        }
        super.executeHandler(object, p);
        if (object.isActive()) {
            return;
        }
        if (unregister) {
            try {
                if (f != null && f.exists()) {
                    f.delete(true, null);
                }
            }
            catch (CoreException coreException) {
                d = object.getModel().getService();
                d.showDialog(JSFUIMessages.DeleteManagedBeanHandler_Failure, MessageFormat.format(JSFUIMessages.DeleteManagedBeanHandler_CannotDeleteFile, f), new String[]{SpecialWizardSupport.CLOSE}, null, 1);
            }
        }
    }

    public boolean getSignificantFlag(XModelObject object) {
        return this.getJavaFile(object) == null;
    }

    IFile getJavaFile(XModelObject object) {
        JSFProjectsRoot o = JSFProjectsTree.getProjectsRoot(object.getModel());
        if (o == null) {
            return null;
        }
        JSFProjectBeans beans = (JSFProjectBeans)o.getChildByPath("Beans");
        if (beans == null) {
            return null;
        }
        IType type = beans.getType(object.getAttributeValue("managed-bean-class"));
        if (type == null || type.isBinary()) {
            return null;
        }
        ICompilationUnit u = type.getCompilationUnit();
        if (u == null || u.getPath() == null) {
            return null;
        }
        IFile file = ModelPlugin.getWorkspace().getRoot().getFile(u.getPath());
        return file == null || !file.isAccessible() || !file.exists() ? null : file;
    }
}

