/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.model.handlers.bean;

import java.text.MessageFormat;
import java.util.Properties;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.ui.refactoring.RenameSupport;
import org.eclipse.swt.widgets.Display;
import org.jboss.tools.common.meta.action.impl.AbstractHandler;
import org.jboss.tools.common.meta.action.impl.handlers.DefaultCreateHandler;
import org.jboss.tools.common.model.XModelException;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.plugin.ModelPlugin;
import org.jboss.tools.common.model.undo.XTransactionUndo;
import org.jboss.tools.common.model.undo.XUndoManager;
import org.jboss.tools.common.model.undo.XUndoable;
import org.jboss.tools.common.reporting.ProblemReportingHelper;
import org.jboss.tools.jsf.messages.JSFUIMessages;
import org.jboss.tools.jsf.model.helpers.bean.ManagedBeanHelper;

public class RenameManagedBeanHandler
extends AbstractHandler {
    boolean isLight = false;

    public boolean isEnabled(XModelObject object) {
        if (this.isLight) {
            return false;
        }
        if (object == null || !object.isObjectEditable()) {
            return false;
        }
        return ManagedBeanHelper.getType(object) != null;
    }

    public void executeHandler(XModelObject object, Properties p) throws XModelException {
        if (!this.isEnabled(object)) {
            return;
        }
        XUndoManager undo = object.getModel().getUndoManager();
        XTransactionUndo u = new XTransactionUndo(MessageFormat.format(JSFUIMessages.RenameManagedBeanHandler_Rename, DefaultCreateHandler.title((XModelObject)object, (boolean)false)), 0);
        undo.addUndoable((XUndoable)u);
        try {
            try {
                this.transaction(object, p);
            }
            catch (XModelException e) {
                undo.rollbackTransactionInProgress();
                throw e;
            }
        }
        finally {
            u.commit();
        }
    }

    protected void transaction(XModelObject object, Properties p) throws XModelException {
        IType type = ManagedBeanHelper.getType(object);
        if (type != null && !type.isBinary()) {
            RenameManagedBeanClassRunnable r = new RenameManagedBeanClassRunnable(object, type);
            Display.getDefault().syncExec((Runnable)r);
        }
    }

    private void renameClass(XModelObject object, String qualifiedName) throws XModelException {
        object.getModel().changeObjectAttribute(object, "managed-bean-class", qualifiedName);
    }

    private class JavaElementChangedListener
    implements IElementChangedListener {
        private IType type;
        private XModelObject object;

        public JavaElementChangedListener(XModelObject object, IType type) {
            this.type = type;
            this.object = object;
        }

        public void elementChanged(ElementChangedEvent event) {
            block8: {
                IJavaElementDelta delta = event.getDelta();
                IJavaElement fromElement = this.getMovedFromElement(delta);
                if (this.type.getCompilationUnit().equals(fromElement)) {
                    try {
                        IJavaElement toElement = this.getMovedToElement(delta);
                        if (!(toElement instanceof ICompilationUnit)) break block8;
                        String packageName = toElement.getParent().getElementName();
                        String className = toElement.getElementName();
                        if (className.endsWith(".java")) {
                            className = className.substring(0, className.length() - 5);
                        }
                        if (packageName.length() > 0) {
                            className = String.valueOf(packageName) + "." + className;
                        }
                        try {
                            RenameManagedBeanHandler.this.renameClass(this.object, className);
                        }
                        catch (XModelException e) {
                            throw new RuntimeException(e);
                        }
                    }
                    finally {
                        JavaCore.removeElementChangedListener((IElementChangedListener)this);
                    }
                }
            }
        }

        private IJavaElement getMovedFromElement(IJavaElementDelta delta) {
            IJavaElement element = delta.getMovedFromElement();
            if (element == null) {
                IJavaElementDelta[] deltas = delta.getAffectedChildren();
                int i = 0;
                while (i < deltas.length && element == null) {
                    element = this.getMovedFromElement(deltas[i]);
                    ++i;
                }
            }
            return element;
        }

        private IJavaElement getMovedToElement(IJavaElementDelta delta) {
            IJavaElement element = delta.getMovedToElement();
            if (element == null) {
                IJavaElementDelta[] deltas = delta.getAffectedChildren();
                int i = 0;
                while (i < deltas.length && element == null) {
                    element = this.getMovedToElement(deltas[i]);
                    ++i;
                }
            }
            return element;
        }
    }

    class RenameManagedBeanClassRunnable
    implements Runnable {
        XModelObject object;
        IType type;

        public RenameManagedBeanClassRunnable(XModelObject object, IType type) {
            this.object = object;
            this.type = type;
        }

        @Override
        public void run() {
            try {
                this.runInternal();
            }
            catch (CoreException e) {
                ProblemReportingHelper.reportProblem((String)"org.jboss.tools.jsf", (Throwable)e);
            }
        }

        public void runInternal() throws CoreException {
            RenameSupport renameSupport = RenameSupport.create((IType)this.type, null, (int)1);
            if (!renameSupport.preCheck().isOK()) {
                return;
            }
            JavaElementChangedListener listener = new JavaElementChangedListener(this.object, this.type);
            JavaCore.addElementChangedListener((IElementChangedListener)listener);
            try {
                renameSupport.openDialog(ModelPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell());
            }
            finally {
                JavaCore.removeElementChangedListener((IElementChangedListener)listener);
            }
        }
    }
}

