/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.model.helpers.pages;

import java.util.Properties;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.osgi.util.NLS;
import org.jboss.tools.common.meta.action.XAction;
import org.jboss.tools.common.meta.action.XActionInvoker;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.util.EclipseResourceUtil;
import org.jboss.tools.jsf.messages.JSFUIMessages;
import org.jboss.tools.jsf.model.pv.JSFProjectsRoot;
import org.jboss.tools.jsf.model.pv.JSFProjectsTree;
import org.jboss.tools.jst.web.model.pv.WebProjectNode;
import org.jboss.tools.jst.web.project.WebProject;

public class OpenCaseHelper {
    public String run(XModel model, IFile jsp, String action) {
        if (model == null || jsp == null || action == null) {
            return null;
        }
        XModelObject jspObject = EclipseResourceUtil.getObjectByResource((IResource)jsp);
        if (jspObject == null) {
            return null;
        }
        WebProject p = WebProject.getInstance((XModel)model);
        String jspLocation = jsp.getLocation().toString().replace('\\', '/');
        String webRoot = p.getWebRootLocation().replace('\\', '/');
        if (webRoot.endsWith("/")) {
            webRoot = webRoot.substring(0, webRoot.length() - 1);
        }
        if (!jspLocation.startsWith(webRoot)) {
            return null;
        }
        String viewPath = jspLocation.substring(webRoot.length());
        CaseSearchResult result = this.findCase(model, viewPath, action);
        if (result.ruleObject == null) {
            return NLS.bind((String)JSFUIMessages.CANNOT_FIND_MATCHING_RULE_FOR_PATH, (Object)viewPath);
        }
        XModelObject object = result.getObject();
        XAction xaction = XActionInvoker.getAction((String)"Select", (XModelObject)object);
        if (xaction != null && xaction.isEnabled(object)) {
            XActionInvoker.invoke((String)"Select", (XModelObject)object, (Properties)new Properties());
        }
        return null;
    }

    private CaseSearchResult findCase(XModel model, String viewPath, String action) {
        CaseSearchResult result = new CaseSearchResult();
        JSFProjectsRoot root = JSFProjectsTree.getProjectsRoot(model);
        if (root == null) {
            return result;
        }
        WebProjectNode n = (WebProjectNode)root.getChildByPath("Configuration");
        if (n == null) {
            return result;
        }
        XModelObject[] os = n.getTreeChildren();
        int i = 0;
        while (i < os.length) {
            XModelObject r = os[i].getChildByPath("Navigation Rules");
            if (r != null) {
                XModelObject[] rs = r.getChildren();
                int j = 0;
                while (j < rs.length) {
                    String fromViewId = rs[j].getAttributeValue("from-view-id");
                    if (OpenCaseHelper.isPatternMatches(fromViewId, viewPath)) {
                        XModelObject[] cs = rs[j].getChildren();
                        int k = 0;
                        while (k < cs.length) {
                            String q1 = cs[k].getAttributeValue("from-outcome");
                            String q2 = cs[k].getAttributeValue("from-action");
                            if ((action.equals(q1) || action.equals(q2)) && (result.match == null || result.match.length() < fromViewId.length() || result.caseObject == null)) {
                                result.caseObject = cs[k];
                                result.ruleObject = rs[j];
                                result.match = fromViewId;
                            }
                            ++k;
                        }
                        if (result.match == null || result.match.length() < fromViewId.length() && result.caseObject == null || result.ruleObject == null) {
                            result.ruleObject = rs[j];
                            result.match = fromViewId;
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
        return result;
    }

    public static boolean isPatternMatches(String pattern, String fromViewId) {
        if (pattern.length() == 0 || "*".equals(pattern)) {
            return true;
        }
        pattern = pattern.toLowerCase().replace('\\', '/');
        fromViewId = fromViewId.toLowerCase().replace('\\', '/');
        if (pattern.indexOf(42) < 0) {
            return pattern.equals(fromViewId);
        }
        StringTokenizer st = new StringTokenizer(pattern, "*", true);
        boolean f = true;
        while (st.hasMoreTokens()) {
            String t = st.nextToken();
            if ("*".equals(t)) {
                f = false;
                continue;
            }
            int i = fromViewId.indexOf(t);
            if (i < 0 || f && i > 0) {
                return false;
            }
            fromViewId = fromViewId.substring(i);
        }
        return true;
    }

    class CaseSearchResult {
        String match = null;
        XModelObject caseObject = null;
        XModelObject ruleObject = null;

        CaseSearchResult() {
        }

        public XModelObject getObject() {
            return this.caseObject != null ? this.caseObject : this.ruleObject;
        }
    }
}

