/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.project;

import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.JarPackageFragmentRoot;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.jboss.tools.common.util.FileUtil;

public class JSF2Util {
    public static boolean isJSF2(IProject project) throws CoreException {
        int v = JSF2Util.getJSFImplementationVersion(project);
        return v > 1 || JSF2Util.isJSF2FacetedProject(project);
    }

    public static int getJSFImplementationVersion(IProject project) throws CoreException {
        block5: {
            String attr;
            String content;
            block6: {
                content = JSF2Util.readManifest(project, "jsf-api.jar");
                if (content == null) break block5;
                attr = "Implementation-Version";
                int i = content.indexOf(attr);
                if (i >= 0) break block6;
                return -1;
            }
            try {
                int j = i += attr.length();
                while (j < content.length()) {
                    char ch = content.charAt(j);
                    if (Character.isDigit(ch)) {
                        return ch - 48;
                    }
                    ++j;
                }
            }
            catch (IOException e) {
                throw new CoreException((IStatus)new Status(4, "org.jboss.tools.jsf", "Failed to read manifest in jsf-api.jar in project " + project.getName(), (Throwable)e));
            }
        }
        return -1;
    }

    public static String readManifest(IProject project, String jarName) throws CoreException, IOException {
        InputStream is;
        ZipFile zip;
        ZipEntry entry;
        IPackageFragmentRoot library = JSF2Util.findLibrary(project, jarName);
        if (library instanceof JarPackageFragmentRoot && (entry = (zip = ((JarPackageFragmentRoot)library).getJar()).getEntry("META-INF/MANIFEST.MF")) != null && (is = zip.getInputStream(entry)) != null) {
            return FileUtil.readStream((InputStream)is);
        }
        return null;
    }

    public static IPackageFragmentRoot findLibrary(IProject project, String jarName) throws JavaModelException {
        if (project == null || !project.isAccessible()) {
            return null;
        }
        IJavaProject javaProject = JavaCore.create((IProject)project);
        if (javaProject == null || !javaProject.exists()) {
            return null;
        }
        IPackageFragmentRoot[] iPackageFragmentRootArray = javaProject.getAllPackageFragmentRoots();
        int n = iPackageFragmentRootArray.length;
        int n2 = 0;
        while (n2 < n) {
            IPackageFragmentRoot fragmentRoot = iPackageFragmentRootArray[n2];
            IPath resource = fragmentRoot.getPath();
            if (resource != null && resource.lastSegment().equals(jarName)) {
                return fragmentRoot;
            }
            ++n2;
        }
        return null;
    }

    public static boolean isJSF2FacetedProject(IProject project) throws CoreException {
        IProjectFacetVersion v;
        IProjectFacet facet = ProjectFacetsManager.getProjectFacet((String)"jst.jsf");
        IFacetedProject fp = ProjectFacetsManager.create((IProject)project);
        if (fp != null && (v = fp.getProjectFacetVersion(facet)) != null) {
            String vs = v.getVersionString();
            return vs != null && vs.startsWith("2.");
        }
        return false;
    }
}

