/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.project.capabilities;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Properties;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.osgi.util.NLS;
import org.jboss.tools.common.meta.action.impl.handlers.DefaultCreateHandler;
import org.jboss.tools.common.model.ServiceDialog;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelConstants;
import org.jboss.tools.common.model.XModelException;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.filesystems.FileSystemsHelper;
import org.jboss.tools.common.model.filesystems.impl.Libs;
import org.jboss.tools.common.model.plugin.ModelPlugin;
import org.jboss.tools.common.model.util.EclipseResourceUtil;
import org.jboss.tools.common.model.util.XModelObjectLoaderUtil;
import org.jboss.tools.common.util.FileUtil;
import org.jboss.tools.jsf.JSFModelPlugin;
import org.jboss.tools.jsf.messages.JSFUIMessages;
import org.jboss.tools.jsf.project.capabilities.CapabilityPerformer;
import org.jboss.tools.jsf.project.capabilities.IPerformerItem;
import org.jboss.tools.jsf.project.capabilities.JarPerformer;
import org.jboss.tools.jsf.project.capabilities.PerformerContext;
import org.jboss.tools.jsf.project.capabilities.PerformerItem;
import org.jboss.tools.jst.web.project.WebProject;
import org.jboss.tools.jst.web.project.helpers.LibrarySet;
import org.jboss.tools.jst.web.project.helpers.LibrarySets;

public class LibrariesPerformer
extends PerformerItem {
    XModel model;
    XModelObject lib;
    IContainer libResource;
    JarPerformer[] jarPerformers;
    IFile[] conflictingFiles;

    @Override
    public String getDisplayName() {
        return "Libraries";
    }

    @Override
    public IPerformerItem[] getChildren() {
        return this.jarPerformers;
    }

    public void init(XModel model, XModelObject[] libraryReferences, XModelObject[] conflictingLibraryReferences) {
        IContainer r;
        XModelObject webinf;
        this.model = model;
        this.lib = model.getByPath("FileSystems/lib");
        if (this.lib == null && (webinf = FileSystemsHelper.getWebInf((XModel)model)) != null) {
            this.lib = webinf.getChildByPath("lib");
        }
        if (this.lib != null) {
            this.libResource = (IContainer)EclipseResourceUtil.getResource((XModelObject)this.lib);
        }
        ArrayList<LibrarySet> l = new ArrayList<LibrarySet>();
        int i = 0;
        while (i < libraryReferences.length) {
            String n = libraryReferences[i].getAttributeValue("name");
            LibrarySet set = LibrarySets.getInstance().getLibrarySet(n);
            if (set != null) {
                l.add(set);
            }
            ++i;
        }
        LibrarySet[] sets = l.toArray(new LibrarySet[0]);
        ArrayList<JarPerformer> l2 = new ArrayList<JarPerformer>();
        int i2 = 0;
        while (i2 < sets.length) {
            File libraryTemplateRoot = new File(sets[i2].getPath());
            if (libraryTemplateRoot.isDirectory()) {
                String[] ss = sets[i2].getJarList();
                int j = 0;
                while (j < ss.length) {
                    JarPerformer p = new JarPerformer();
                    p.setParent(this);
                    p.init(model, sets[i2], ss[j]);
                    l2.add(p);
                    ++j;
                }
                File[] zs = this.getZipList(sets[i2]);
                int j2 = 0;
                while (j2 < zs.length) {
                    JarPerformer p = new JarPerformer();
                    p.setParent(this);
                    p.init(model, sets[i2], zs[j2].getName());
                    l2.add(p);
                    ++j2;
                }
            }
            ++i2;
        }
        this.jarPerformers = l2.toArray(new JarPerformer[0]);
        this.conflictingFiles = null;
        IContainer iContainer = r = this.lib == null ? null : (IContainer)this.lib.getAdapter(IResource.class);
        if (conflictingLibraryReferences != null && this.lib != null && r != null) {
            ArrayList<IFile> cfjs = new ArrayList<IFile>();
            int i3 = 0;
            while (i3 < conflictingLibraryReferences.length) {
                String name = conflictingLibraryReferences[i3].getAttributeValue("name");
                this.collectFiles(r, name, cfjs);
                ++i3;
            }
            this.conflictingFiles = cfjs.toArray(new IFile[0]);
        }
    }

    private void collectFiles(IContainer r, String name, ArrayList<IFile> cfjs) {
        int wildcard = name.indexOf(42);
        if (wildcard < 0) {
            IFile f = r.getFile((IPath)new Path(name));
            if (f.exists()) {
                cfjs.add(f);
            }
        } else {
            IResource[] rs = null;
            try {
                rs = r.members();
            }
            catch (CoreException e) {
                ModelPlugin.getPluginLog().logError((Throwable)e);
            }
            if (rs != null) {
                String prefix = name.substring(0, wildcard);
                String suffix = name.substring(wildcard);
                int i = 0;
                while (i < rs.length) {
                    if (rs[i] instanceof IFile) {
                        String n = rs[i].getName();
                        if ((prefix.length() <= 0 || n.startsWith(prefix)) && (suffix.length() <= 0 || n.endsWith(suffix))) {
                            cfjs.add((IFile)rs[i]);
                        }
                    }
                    ++i;
                }
            }
        }
    }

    public boolean check(PerformerContext context) {
        String[] existing;
        if (!this.isSelected()) {
            return true;
        }
        if (this.libResource == null) {
            return false;
        }
        ServiceDialog d = this.model.getService();
        if (this.conflictingFiles != null && this.conflictingFiles.length > 0) {
            String message = NLS.bind((String)JSFUIMessages.PROJECT_HAS_COFLICTING_LIBRARIES, (Object)this.conflictingFiles[0].getName());
            int q = d.showDialog(JSFUIMessages.WARNING, message, new String[]{JSFUIMessages.YES, JSFUIMessages.NO, JSFUIMessages.CANCEL}, null, 2);
            if (q == 2) {
                return false;
            }
            if (q == 1) {
                this.conflictingFiles = null;
                if (this.jarPerformers != null) {
                    int i = 0;
                    while (i < this.jarPerformers.length) {
                        this.jarPerformers[i].setSelected(false);
                        ++i;
                    }
                }
                return true;
            }
        }
        if ((existing = this.getExistingJars()).length == 0) {
            return true;
        }
        String message = existing.length > 1 ? NLS.bind((String)JSFUIMessages.PROJECT_ALREADY_HAS_SOME_OF_LIBRARIES_INCLUDED_2, (Object)existing[0], (Object)("" + (existing.length - 1))) : NLS.bind((String)JSFUIMessages.PROJECT_ALREADY_HAS_SOME_OF_LIBRARIES_INCLUDED, (Object)existing[0]);
        int q = d.showDialog(JSFUIMessages.WARNING, message, new String[]{JSFUIMessages.OVERWRITE, JSFUIMessages.CANCEL}, null, 2);
        return q == 0;
    }

    private String[] getExistingJars() {
        ArrayList<String> l = new ArrayList<String>();
        int i = 0;
        while (i < this.jarPerformers.length) {
            IResource r;
            if (this.jarPerformers[i].isSelected() && (r = this.libResource.findMember(this.jarPerformers[i].jar)) != null && r.exists()) {
                l.add(this.jarPerformers[i].jar);
            }
            ++i;
        }
        return l.toArray(new String[0]);
    }

    @Override
    public boolean execute(PerformerContext context) throws XModelException {
        IProject p;
        if (!this.isSelected()) {
            return true;
        }
        boolean changed = false;
        boolean zip = false;
        XModelObject fss = FileSystemsHelper.getFileSystems((XModel)this.model);
        File location = this.libResource.getLocation().toFile();
        String libName = null;
        XModelObject webinf = FileSystemsHelper.getWebInf((XModel)this.model);
        File webInfDir = ((IResource)webinf.getAdapter(IResource.class)).getLocation().toFile();
        libName = location.getParentFile().equals(webInfDir) ? String.valueOf(XModelConstants.WORKSPACE_REF) + "/lib/" : String.valueOf(location.getAbsolutePath().replace('\\', '/')) + "/";
        CapabilityPerformer pp = (CapabilityPerformer)this.getParent();
        String capability = pp.capability.getAttributeValue("name");
        int i = 0;
        while (i < this.jarPerformers.length) {
            block19: {
                String n;
                File source;
                block20: {
                    String postfix;
                    String task;
                    File target;
                    block21: {
                        String ss;
                        if (!this.jarPerformers[i].isSelected()) break block19;
                        context.monitor.worked(1);
                        LibrarySet set = this.jarPerformers[i].set;
                        File libraryTemplateRoot = new File(set.getPath());
                        if (!libraryTemplateRoot.isDirectory() || !(source = new File(libraryTemplateRoot, ss = this.jarPerformers[i].jar)).isFile()) break block19;
                        n = source.getName();
                        if (!n.endsWith(".jar")) break block20;
                        target = new File(location, ss);
                        task = String.valueOf(capability) + ": " + "Added ";
                        postfix = "to";
                        if (!target.isFile()) break block21;
                        task = String.valueOf(capability) + ": " + "Replaced ";
                        postfix = "in";
                        if (!target.delete()) break block19;
                    }
                    FileUtil.copyFile((File)source, (File)target, (boolean)true);
                    changed = true;
                    String fsName = String.valueOf(Libs.LIB_PREFIX) + n;
                    if (fss.getChildByPath(fsName) == null) {
                        Properties fsProp = new Properties();
                        fsProp.setProperty("name", fsName);
                        fsProp.setProperty("location", String.valueOf(libName) + n);
                        fsProp.setProperty("info", "hidden=yes");
                        XModelObject fsJar = XModelObjectLoaderUtil.createValidObject((XModel)this.model, (String)"FileSystemJar", (Properties)fsProp);
                        if (fss.getChildByPath(fsJar.getPathPart()) == null) {
                            DefaultCreateHandler.addCreatedObject((XModelObject)fss, (XModelObject)fsJar, (boolean)false, (int)-1);
                        }
                    }
                    context.changeList.add(String.valueOf(task) + n + " " + postfix + " WEB-INF/lib");
                    break block19;
                }
                if (n.endsWith(".zip") && source.isFile()) {
                    String webRoot = WebProject.getInstance((XModel)this.model).getWebRootLocation();
                    try {
                        FileUtil.unzip((File)new File(webRoot), (String)source.getAbsolutePath());
                    }
                    catch (IOException iOException) {}
                    zip = true;
                    context.changeList.add(String.valueOf(capability) + ": " + "Unpacked " + n + " to " + new File(webRoot).getName());
                }
            }
            ++i;
        }
        if (changed) {
            try {
                this.libResource.refreshLocal(2, null);
            }
            catch (CoreException e) {
                throw new XModelException((Throwable)e);
            }
            this.model.save();
        }
        if (zip && (p = EclipseResourceUtil.getProject((XModelObject)this.model.getRoot())) != null) {
            try {
                p.refreshLocal(2, null);
            }
            catch (CoreException coreException) {}
        }
        if (this.conflictingFiles != null) {
            i = 0;
            while (i < this.conflictingFiles.length) {
                try {
                    this.conflictingFiles[i].delete(true, context.monitor);
                    context.changeList.add(String.valueOf(capability) + ": Removed " + this.conflictingFiles[i].getName() + " from WEB-INF/lib");
                }
                catch (CoreException ce) {
                    JSFModelPlugin.getPluginLog().logError((Throwable)ce);
                }
                ++i;
            }
        }
        context.monitor.worked(1);
        return true;
    }

    private File[] getZipList(LibrarySet set) {
        File[] fs;
        ArrayList<File> list = new ArrayList<File>();
        String path = set.getPath();
        File f = new File(path);
        File[] fileArray = fs = f.isDirectory() ? f.listFiles() : null;
        if (fs != null) {
            int i = 0;
            while (i < fs.length) {
                if (fs[i].getName().endsWith(".zip")) {
                    list.add(fs[i]);
                }
                ++i;
            }
        }
        return list.toArray(new File[0]);
    }
}

