/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.web.validation;

import java.util.Locale;
import org.eclipse.core.resources.IFile;
import org.eclipse.wst.validation.internal.core.Message;
import org.jboss.tools.jsf.web.validation.IJSFValidationComponent;
import org.jboss.tools.jsf.web.validation.jsf2.JSF2XMLValidator;
import org.jboss.tools.jsf.web.validation.jsf2.components.JSF2AttrTempComponent;
import org.jboss.tools.jsf.web.validation.jsf2.components.JSF2CompositeTempComponent;
import org.jboss.tools.jsf.web.validation.jsf2.components.JSF2URITempComponent;

public class LocalizedMessage
extends Message {
    private IJSFValidationComponent component;

    private LocalizedMessage() {
    }

    public static LocalizedMessage createJSF2LocalizedMessage(IJSFValidationComponent component, IFile validateFile) {
        String[] attrNames;
        LocalizedMessage jsf2LocMessage = new LocalizedMessage();
        jsf2LocMessage.component = component;
        jsf2LocMessage.setAttribute("problemType", JSF2XMLValidator.JSF2_PROBLEM_ID);
        jsf2LocMessage.setAttribute("JSF2_TYPE_KEY", component.getType());
        jsf2LocMessage.setAttribute("validateResourcePath", validateFile == null ? "" : validateFile.getFullPath().toString());
        jsf2LocMessage.setAttribute("component_resource_path_key", component.getComponentResourceLocation());
        jsf2LocMessage.setAttribute("lineNumber", jsf2LocMessage.getLineNumber());
        jsf2LocMessage.setAttribute("severity", 1);
        jsf2LocMessage.setAttribute("ValidationId", "org.jboss.tools.jsf.jsf2.source");
        if (component instanceof JSF2URITempComponent) {
            jsf2LocMessage.setAttribute("JSF2_URI_NAME_KEY", ((JSF2URITempComponent)component).getURI());
        } else if (component instanceof JSF2AttrTempComponent) {
            jsf2LocMessage.setAttribute("ATTR_NAME_KEY", ((JSF2AttrTempComponent)component).getName());
            jsf2LocMessage.setAttribute("jsf2_resource_name", ((JSF2AttrTempComponent)component).getElementName());
        } else if (component instanceof JSF2CompositeTempComponent && (attrNames = ((JSF2CompositeTempComponent)component).getAttrNames()) != null) {
            int i = 0;
            while (i < attrNames.length) {
                jsf2LocMessage.setAttribute("ATTR_NAME_KEY" + String.valueOf(i), attrNames[i]);
                ++i;
            }
            jsf2LocMessage.setAttribute("jsf2_resource_name", ((JSF2CompositeTempComponent)component).getElement().getLocalName());
        }
        jsf2LocMessage.setAttribute("message", jsf2LocMessage.getText());
        return jsf2LocMessage;
    }

    public int getLineNumber() {
        return this.component.getLine();
    }

    public int getLength() {
        return this.component.getLength();
    }

    public int getOffset() {
        return this.component.getStartOffSet();
    }

    public String getText() {
        return this.component.getValidationMessage();
    }

    public String getText(Locale locale) {
        return this.component.getValidationMessage();
    }

    public String getText(Locale locale, ClassLoader classLoader) {
        return this.component.getValidationMessage();
    }

    public String getText(ClassLoader classLoader) {
        return this.component.getValidationMessage();
    }

    public int getSeverity() {
        return 2;
    }
}

