/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.web.validation;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.text.MessageFormat;
import org.apache.xerces.parsers.SAXParser;
import org.apache.xerces.xni.XMLResourceIdentifier;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.parser.XMLEntityResolver;
import org.apache.xerces.xni.parser.XMLInputSource;
import org.apache.xerces.xni.parser.XMLParseException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.wst.validation.ValidationResult;
import org.eclipse.wst.validation.ValidationState;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.xml.core.internal.validation.XMLValidationInfo;
import org.eclipse.wst.xml.core.internal.validation.core.NestedValidatorContext;
import org.eclipse.wst.xml.core.internal.validation.core.ValidationMessage;
import org.eclipse.wst.xml.core.internal.validation.core.ValidationReport;
import org.eclipse.wst.xml.core.internal.validation.eclipse.Validator;
import org.jboss.tools.common.util.FileUtil;
import org.jboss.tools.jsf.JSFModelPlugin;
import org.jboss.tools.jsf.web.validation.JSFValidationMessage;
import org.jboss.tools.jsf.web.validation.XHTMLDetector;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.LocatorImpl;

public class XHTMLValidator
extends Validator {
    public static final String PROBLEM_ID = "org.jboss.tools.jsfxhtmlsyntaxproblem";
    private static final String XHML_VALIDATOR_CONTEXT = "org.jboss.tools.jsf.web.validation.xhtmlValidatorContext";
    IProgressMonitor monitor;
    IResource resource;
    private String[] SAX_PARSER_FEATURES_TO_DISABLE = new String[]{"http://xml.org/sax/features/namespaces", "http://xml.org/sax/features/use-entity-resolver2", "http://xml.org/sax/features/validation", "http://apache.org/xml/features/validation/dynamic", "http://apache.org/xml/features/validation/schema", "http://apache.org/xml/features/validation/schema-full-checking", "http://apache.org/xml/features/nonvalidating/load-external-dtd", "http://apache.org/xml/features/nonvalidating/load-dtd-grammar", "http://apache.org/xml/features/xinclude", "http://xml.org/sax/features/resolve-dtd-uris"};

    private void setSAXParserFeatures(XMLReader reader, String[] features, boolean set) {
        String[] stringArray = features;
        int n = features.length;
        int n2 = 0;
        while (n2 < n) {
            String feature = stringArray[n2];
            try {
                reader.setFeature(feature, set);
            }
            catch (SAXException e) {
                JSFModelPlugin.getDefault().logError(e);
            }
            ++n2;
        }
    }

    private void setSAXParserProperty(XMLReader reader, String property, Object value) {
        try {
            reader.setProperty(property, value);
        }
        catch (SAXException e) {
            JSFModelPlugin.getDefault().logError(e);
        }
    }

    private IDocument getDocument(IFile file) {
        String content;
        if (file == null) {
            return null;
        }
        try {
            content = FileUtil.readStream((IFile)file);
        }
        catch (CoreException e) {
            JSFModelPlugin.getDefault().logError(e);
            return null;
        }
        return content == null ? null : new Document(content);
    }

    public ValidationResult validate(IResource resource, int kind, ValidationState state, IProgressMonitor monitor) {
        this.displaySubtask(monitor, JSFValidationMessage.XHTML_VALIDATION, resource.getFullPath());
        this.resource = resource;
        return super.validate(resource, kind, state, monitor);
    }

    public ValidationReport validate(String uri, InputStream inputstream, NestedValidatorContext context) {
        this.displaySubtask(JSFValidationMessage.XHTML_VALIDATION, uri);
        this.resource = null;
        return super.validate(uri, inputstream, context);
    }

    public ValidationReport validate(String uri, InputStream inputstream, NestedValidatorContext context, ValidationResult result) {
        this.displaySubtask(JSFValidationMessage.XHTML_VALIDATION, uri);
        IDocument doc = this.resource instanceof IFile ? this.getDocument((IFile)this.resource) : null;
        XMLValidationInfo report = new XMLValidationInfo(uri);
        if (doc == null || !this.isXHTML(doc)) {
            return report;
        }
        XHTMLElementHandler handler = new XHTMLElementHandler(uri, this.resource instanceof IFile ? this.getDocument((IFile)this.resource) : null, report);
        try {
            MySAXParser xmlReader = new MySAXParser();
            this.setSAXParserFeatures((XMLReader)((Object)xmlReader), this.SAX_PARSER_FEATURES_TO_DISABLE, false);
            this.setSAXParserProperty((XMLReader)((Object)xmlReader), "http://xml.org/sax/properties/lexical-handler", handler);
            xmlReader.setProperty("http://apache.org/xml/properties/internal/entity-resolver", new NullXMLEntityResolver());
            xmlReader.setContentHandler(handler);
            xmlReader.setDTDHandler(handler);
            xmlReader.setErrorHandler(handler);
            xmlReader.setEntityResolver(handler);
            xmlReader.parse(uri);
        }
        catch (IOException e) {
            JSFModelPlugin.getDefault().logError(e);
        }
        catch (SAXNotRecognizedException e) {
            JSFModelPlugin.getDefault().logError(e);
        }
        catch (SAXNotSupportedException e) {
            JSFModelPlugin.getDefault().logError(e);
        }
        catch (SAXException e) {
            int max = handler.document.getLength();
            int currentLocation = handler.getCurrentLocation();
            int length = 0;
            if (max > 0) {
                if (currentLocation + 1 > max) {
                    --currentLocation;
                } else {
                    length = 1;
                }
            }
            ElementLocation location = new ElementLocation(handler.locator.getLineNumber(), handler.locator.getColumnNumber(), currentLocation, length);
            report.addError(e.getLocalizedMessage(), handler.locator.getLineNumber(), handler.locator.getColumnNumber(), uri, null, new Object[]{location});
        }
        return report;
    }

    public boolean isXHTML(IDocument document) {
        XHTMLDetector detector = new XHTMLDetector(new StringReader(document.get()));
        return detector.detect();
    }

    protected void addInfoToMessage(ValidationMessage validationMessage, IMessage message) {
        ElementLocation location;
        ElementLocation elementLocation = location = validationMessage.getMessageArguments() == null || validationMessage.getMessageArguments().length < 1 ? null : (ElementLocation)validationMessage.getMessageArguments()[0];
        if (location != null) {
            message.setLineNo(location.getLine());
            message.setOffset(location.getStart());
            message.setLength(location.getLength());
        }
    }

    public void validationStarting(IProject project, ValidationState state, IProgressMonitor monitor) {
        if (project != null) {
            NestedValidatorContext context = this.getNestedContext(state, false);
            if (context == null) {
                context = this.getNestedContext(state, true);
                if (context != null) {
                    context.setProject(project);
                }
                this.setupValidation(context);
                state.put(XHML_VALIDATOR_CONTEXT, (Object)context);
            }
            this.monitor = monitor;
        }
    }

    public void validationFinishing(IProject project, ValidationState state, IProgressMonitor monitor) {
        if (project != null) {
            super.validationFinishing(project, state, monitor);
            NestedValidatorContext context = this.getNestedContext(state, false);
            if (context != null) {
                this.teardownValidation(context);
                state.put(XHML_VALIDATOR_CONTEXT, null);
            }
        }
    }

    private void displaySubtask(String message, Object ... arguments) {
        this.displaySubtask(this.monitor, message, arguments);
    }

    private void displaySubtask(IProgressMonitor monitor, String message, Object ... arguments) {
        if (monitor != null) {
            monitor.subTask(MessageFormat.format(message, arguments));
        }
    }

    class ElementLocation {
        int line;
        int column;
        int start;
        int length;

        ElementLocation(int line, int column, int start, int length) {
            this.line = line;
            this.column = column;
            this.start = start;
            this.length = length;
        }

        int getLine() {
            return this.line;
        }

        int getColumn() {
            return this.column;
        }

        int getStart() {
            return this.start;
        }

        int getLength() {
            return this.length;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("'");
            sb.append("Line: ");
            sb.append(this.line);
            sb.append(", Column: ");
            sb.append(this.column);
            sb.append(", start: ");
            sb.append(this.start);
            sb.append(", end: ");
            sb.append(this.start + this.length);
            sb.append(", length: ");
            sb.append(this.length);
            return sb.toString();
        }
    }

    class MySAXParser
    extends SAXParser {
        MySAXParser() {
        }

        public void parse(String systemId) throws SAXException, IOException {
            MyXMLInputSource source = new MyXMLInputSource(null, systemId, null);
            try {
                this.parse(source);
            }
            catch (XMLParseException e) {
                Exception ex = e.getException();
                if (ex == null) {
                    LocatorImpl locatorImpl = new LocatorImpl(){

                        public String getXMLVersion() {
                            return MySAXParser.this.fVersion;
                        }

                        public String getEncoding() {
                            return null;
                        }
                    };
                    locatorImpl.setPublicId(e.getPublicId());
                    locatorImpl.setSystemId(e.getExpandedSystemId());
                    locatorImpl.setLineNumber(e.getLineNumber());
                    locatorImpl.setColumnNumber(e.getColumnNumber());
                    throw new SAXParseException(e.getMessage(), locatorImpl);
                }
                if (ex instanceof SAXException) {
                    throw (SAXException)ex;
                }
                if (ex instanceof IOException) {
                    throw (IOException)ex;
                }
                throw new SAXException(ex);
            }
            catch (XNIException e) {
                Exception ex = e.getException();
                if (ex == null) {
                    throw new SAXException(e.getMessage());
                }
                if (ex instanceof SAXException) {
                    throw (SAXException)ex;
                }
                if (ex instanceof IOException) {
                    throw (IOException)ex;
                }
                throw new SAXException(ex);
            }
        }

        public void parse(InputSource inputSource) throws SAXException, IOException {
            try {
                XMLInputSource xmlInputSource = new XMLInputSource(inputSource.getPublicId(), inputSource.getSystemId(), null);
                xmlInputSource.setByteStream(inputSource.getByteStream());
                xmlInputSource.setCharacterStream(inputSource.getCharacterStream());
                xmlInputSource.setEncoding(inputSource.getEncoding());
                this.parse(xmlInputSource);
            }
            catch (XMLParseException e) {
                Exception ex = e.getException();
                if (ex == null) {
                    LocatorImpl locatorImpl = new LocatorImpl(){

                        public String getXMLVersion() {
                            return MySAXParser.this.fVersion;
                        }

                        public String getEncoding() {
                            return null;
                        }
                    };
                    locatorImpl.setPublicId(e.getPublicId());
                    locatorImpl.setSystemId(e.getExpandedSystemId());
                    locatorImpl.setLineNumber(e.getLineNumber());
                    locatorImpl.setColumnNumber(e.getColumnNumber());
                    throw new SAXParseException(e.getMessage(), locatorImpl);
                }
                if (ex instanceof SAXException) {
                    throw (SAXException)ex;
                }
                if (ex instanceof IOException) {
                    throw (IOException)ex;
                }
                throw new SAXException(ex);
            }
            catch (XNIException e) {
                Exception ex = e.getException();
                if (ex == null) {
                    throw new SAXException(e.getMessage());
                }
                if (ex instanceof SAXException) {
                    throw (SAXException)ex;
                }
                if (ex instanceof IOException) {
                    throw (IOException)ex;
                }
                throw new SAXException(ex);
            }
        }
    }

    class MyXMLInputSource
    extends XMLInputSource {
        public MyXMLInputSource(String publicId, String systemId, String baseSystemId) {
            super(publicId, systemId, baseSystemId);
        }

        public InputStream getByteStream() {
            InputStream stream = null;
            try {
                URLConnection connect;
                URL location = new URL(this.getSystemId());
                String protocol = location.getProtocol();
                if (!("http".equalsIgnoreCase(protocol) || "https".equalsIgnoreCase(protocol) || (connect = location.openConnection()) instanceof HttpURLConnection)) {
                    stream = connect.getInputStream();
                }
            }
            catch (MalformedURLException e) {
                JSFModelPlugin.getPluginLog().logError((Throwable)e);
            }
            catch (IOException e) {
                JSFModelPlugin.getPluginLog().logError((Throwable)e);
            }
            return stream;
        }
    }

    class NullXMLEntityResolver
    implements XMLEntityResolver {
        NullXMLEntityResolver() {
        }

        public XMLInputSource resolveEntity(XMLResourceIdentifier rid) throws XNIException, IOException {
            return new XMLInputSource(rid.getPublicId(), rid.getBaseSystemId() == null ? rid.getLiteralSystemId() : rid.getExpandedSystemId(), rid.getBaseSystemId(), (Reader)new StringReader(""), null);
        }
    }

    class XHTMLElementHandler
    extends DefaultHandler
    implements LexicalHandler {
        private Locator locator;
        private IDocument document;

        public XHTMLElementHandler(String uri, IDocument document, XMLValidationInfo valinfo) {
            this.document = document;
        }

        @Override
        public void setDocumentLocator(Locator locator) {
            this.locator = locator;
        }

        @Override
        public InputSource resolveEntity(String publicId, String systemId) throws IOException, SAXException {
            return new InputSource(new StringReader(""));
        }

        private int getCurrentLocation() {
            if (this.locator == null) {
                return 0;
            }
            int line = this.locator.getLineNumber() - 1;
            int lineOffset = this.locator.getColumnNumber() - 1;
            try {
                return this.document.getLineOffset(line) + lineOffset;
            }
            catch (BadLocationException e) {
                JSFModelPlugin.getDefault().logError(e);
                return 0;
            }
        }

        @Override
        public void endDTD() throws SAXException {
        }

        @Override
        public void startEntity(String name) throws SAXException {
        }

        @Override
        public void endEntity(String name) throws SAXException {
        }

        @Override
        public void startCDATA() throws SAXException {
        }

        @Override
        public void endCDATA() throws SAXException {
        }

        @Override
        public void comment(char[] ch, int start, int length) throws SAXException {
        }

        @Override
        public void startDTD(String name, String publicId, String systemId) throws SAXException {
        }
    }
}

