/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.web.validation.jsf2;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMAttr;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.validation.core.ValidationReport;
import org.jboss.tools.common.el.core.resolver.ELContext;
import org.jboss.tools.jsf.jsf2.model.JSF2ComponentModelManager;
import org.jboss.tools.jsf.jsf2.util.JSF2ComponentUtil;
import org.jboss.tools.jsf.web.validation.IJSFValidationComponent;
import org.jboss.tools.jsf.web.validation.jsf2.JSF2ValidationInfo;
import org.jboss.tools.jsf.web.validation.jsf2.util.JSF2ComponentRecognizer;
import org.jboss.tools.jst.web.kb.IPageContext;
import org.jboss.tools.jst.web.kb.PageContextFactory;
import org.jboss.tools.jst.web.kb.internal.XmlContextImpl;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class JSF2XMLValidator {
    public static String JSF2_PROBLEM_ID = "org.jboss.tools.jsf.jsf2problemmarker";
    private JSF2ValidationInfo validationInfo;
    private static JSF2XMLValidator instance = new JSF2XMLValidator();

    public ValidationReport validate(IFile file, String uri) {
        this.validationInfo = new JSF2ValidationInfo(uri);
        this.validate(file);
        return this.validationInfo;
    }

    private JSF2XMLValidator() {
    }

    public static JSF2XMLValidator getInstance() {
        return instance;
    }

    private void validate(IFile file) {
        ELContext elContext = PageContextFactory.createPageContext((IFile)file);
        if (elContext instanceof IPageContext) {
            this.validateAsDOM(file);
        } else if (elContext instanceof XmlContextImpl && "xhtml".equals(file.getFileExtension())) {
            this.validateAsDOM(file);
        }
    }

    private void validateAsDOM(IFile file) {
        IDOMDocument document = JSF2ComponentModelManager.getReadableDOMDocument(file);
        IJSFValidationComponent[] components = JSF2XMLValidator.getValidationComponents((Node)document, file);
        if (components != null) {
            int i = 0;
            while (i < components.length) {
                this.createMarkerForComponent(components[i]);
                ++i;
            }
        }
    }

    private void createMarkerForComponent(IJSFValidationComponent jsf2ValidationComponent) {
        this.validationInfo.addWarning(jsf2ValidationComponent.getValidationMessage(), jsf2ValidationComponent.getLine(), 0, this.validationInfo.getFileURI(), null, jsf2ValidationComponent.getMessageParams());
    }

    public static IJSFValidationComponent[] getValidationComponents(Node node, IFile file) {
        ArrayList<IJSFValidationComponent> components = new ArrayList<IJSFValidationComponent>(0);
        Map<String, List<Element>> compositeComponentsMap = JSF2ComponentUtil.findCompositeComponents(node);
        Set<Map.Entry<String, List<Element>>> entries = compositeComponentsMap.entrySet();
        for (Map.Entry<String, List<Element>> entry : entries) {
            List<Element> elements = entry.getValue();
            for (Element element : elements) {
                IJSFValidationComponent[] validationComponents = JSF2ComponentRecognizer.recognizeCompositeValidationComponents(file, (IDOMElement)element);
                int i = 0;
                while (i < validationComponents.length) {
                    components.add(validationComponents[i]);
                    ++i;
                }
            }
        }
        IDOMAttr[] attrs = JSF2ComponentUtil.findURIContainers(node);
        HashSet<String> attrValuesSet = new HashSet<String>(0);
        int i = 0;
        while (i < attrs.length) {
            if (!attrValuesSet.contains(attrs[i].getValue())) {
                attrValuesSet.add(attrs[i].getValue());
                IJSFValidationComponent validationComponent = JSF2ComponentRecognizer.recognizeURIValidationComponent(file.getProject(), attrs[i]);
                if (validationComponent != null) {
                    components.add(validationComponent);
                }
            }
            ++i;
        }
        return components.toArray(new IJSFValidationComponent[0]);
    }
}

