/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.cdi.seam.text.ext.test;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jdt.internal.ui.javaeditor.CompilationUnitEditor;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.AbstractHyperlinkDetector;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.ITextEditor;
import org.jboss.tools.cdi.seam.config.core.test.SeamConfigTest;
import org.jboss.tools.cdi.seam.text.ext.CDISeamExtPlugin;
import org.jboss.tools.cdi.seam.text.ext.hyperlink.SeamConfigInjectedPointHyperlink;
import org.jboss.tools.cdi.seam.text.ext.hyperlink.SeamConfigInjectedPointHyperlinkDetector;
import org.jboss.tools.cdi.text.ext.test.CDIHyperlinkTestUtil;
import org.jboss.tools.common.util.FileUtil;

public class SeamConfigInjectedPointHyperlinkTest
extends SeamConfigTest {
    static final String HYPERLINK_NAME = SeamConfigInjectedPointHyperlink.class.getName();

    public void testClassBean() throws Exception {
        IHyperlink hyperlink = SeamConfigInjectedPointHyperlinkTest.checkHyperLinkInJava("src/org/jboss/beans/injection/Injections.java", this.project, "@Inject MyBean5", 1, (AbstractHyperlinkDetector)new SeamConfigInjectedPointHyperlinkDetector(), HYPERLINK_NAME);
        hyperlink.open();
        SeamConfigInjectedPointHyperlinkTest.checkResult("seam-beans.xml", "<test04:MyBean5>");
    }

    public void testProducerField() throws Exception {
        IHyperlink hyperlink = SeamConfigInjectedPointHyperlinkTest.checkHyperLinkInJava("src/org/jboss/beans/injection/Injections.java", this.project, "@Inject @MyQualifier", 1, (AbstractHyperlinkDetector)new SeamConfigInjectedPointHyperlinkDetector(), HYPERLINK_NAME);
        hyperlink.open();
        SeamConfigInjectedPointHyperlinkTest.checkResult("seam-beans.xml", "<test04:myType3>");
    }

    public void testProducerMethod() throws Exception {
        IHyperlink hyperlink = SeamConfigInjectedPointHyperlinkTest.checkHyperLinkInJava("src/org/jboss/beans/injection/Injections.java", this.project, "@Inject @org.jboss.beans.test05.MyQualifier", 1, (AbstractHyperlinkDetector)new SeamConfigInjectedPointHyperlinkDetector(), HYPERLINK_NAME);
        hyperlink.open();
        SeamConfigInjectedPointHyperlinkTest.checkResult("seam-beans.xml", "<test05:createType>");
    }

    public void testVirtualProducerField() throws Exception {
        IHyperlink hyperlink = SeamConfigInjectedPointHyperlinkTest.checkHyperLinkInJava("src/org/jboss/beans/injection/Injections.java", this.project, "@Inject @org.jboss.beans.test06.MyQualifier", 1, (AbstractHyperlinkDetector)new SeamConfigInjectedPointHyperlinkDetector(), HYPERLINK_NAME);
        hyperlink.open();
        SeamConfigInjectedPointHyperlinkTest.checkResult("seam-beans.xml", "<s:String>");
    }

    static void checkResult(String name, String selectedText) throws CoreException {
        IEditorPart editor = CDISeamExtPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        IFileEditorInput input = (IFileEditorInput)editor.getEditorInput();
        IFile f = input.getFile();
        SeamConfigInjectedPointHyperlinkTest.assertEquals((String)name, (String)f.getName());
        ITextSelection textSelection = SeamConfigInjectedPointHyperlinkTest.getSelection(editor);
        String text = FileUtil.readStream((IFile)f).substring(textSelection.getOffset(), textSelection.getOffset() + textSelection.getLength());
        SeamConfigInjectedPointHyperlinkTest.assertEquals((String)selectedText, (String)text);
    }

    public static ITextSelection getSelection(IEditorPart editor) {
        ITextEditor textEditor = (ITextEditor)editor.getAdapter(ITextEditor.class);
        SeamConfigInjectedPointHyperlinkTest.assertNotNull((Object)textEditor);
        ISelection s = textEditor.getSelectionProvider().getSelection();
        SeamConfigInjectedPointHyperlinkTest.assertTrue((boolean)(s instanceof ITextSelection));
        return (ITextSelection)s;
    }

    public static IHyperlink checkHyperLinkInJava(String fileName, IProject project, String substring, int innerOffset, AbstractHyperlinkDetector detector, String hyperlinkClassName) throws Exception {
        IFile file = project.getFile(fileName);
        SeamConfigInjectedPointHyperlinkTest.assertNotNull((String)("The file \"" + fileName + "\" is not found"), (Object)file);
        SeamConfigInjectedPointHyperlinkTest.assertTrue((String)("The file \"" + fileName + "\" is not found"), (boolean)file.isAccessible());
        String text = FileUtil.readStream((IFile)file);
        int offset = text.indexOf(substring);
        SeamConfigInjectedPointHyperlinkTest.assertTrue((offset > 0 ? 1 : 0) != 0);
        Region region = new Region(offset += innerOffset, 0);
        new FileEditorInput(file);
        IEditorPart part = CDIHyperlinkTestUtil.openFileInEditor((IFile)file);
        CompilationUnitEditor editor = (CompilationUnitEditor)part;
        ISourceViewer viewer = editor.getViewer();
        detector.setContext((IAdaptable)editor);
        IHyperlink[] links = detector.detectHyperlinks((ITextViewer)viewer, (IRegion)region, true);
        if (links != null) {
            IHyperlink[] iHyperlinkArray = links;
            int n = links.length;
            int n2 = 0;
            while (n2 < n) {
                IHyperlink hyperlink = iHyperlinkArray[n2];
                if (hyperlink.getClass().getName().equals(hyperlinkClassName)) {
                    return hyperlink;
                }
                ++n2;
            }
        }
        SeamConfigInjectedPointHyperlinkTest.fail((String)"Can't find HyperLink");
        return null;
    }
}

