/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.cdi.seam.solder.core.generic;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IAnnotatable;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.osgi.util.NLS;
import org.jboss.tools.cdi.core.CDICoreNature;
import org.jboss.tools.cdi.core.CDIUtil;
import org.jboss.tools.cdi.core.IBean;
import org.jboss.tools.cdi.core.IClassBean;
import org.jboss.tools.cdi.core.IProducer;
import org.jboss.tools.cdi.core.IQualifierDeclaration;
import org.jboss.tools.cdi.internal.core.impl.AnnotationDeclaration;
import org.jboss.tools.cdi.internal.core.impl.CDIProject;
import org.jboss.tools.cdi.internal.core.impl.definition.AbstractMemberDefinition;
import org.jboss.tools.cdi.internal.core.impl.definition.AnnotationDefinition;
import org.jboss.tools.cdi.internal.core.impl.definition.TypeDefinition;
import org.jboss.tools.cdi.internal.core.validation.CDICoreValidator;
import org.jboss.tools.cdi.seam.solder.core.CDISeamSolderCorePlugin;
import org.jboss.tools.cdi.seam.solder.core.CDISeamSolderPreferences;
import org.jboss.tools.cdi.seam.solder.core.Version;
import org.jboss.tools.cdi.seam.solder.core.generic.GenericBeanDefinitionContext;
import org.jboss.tools.cdi.seam.solder.core.generic.GenericConfiguration;
import org.jboss.tools.cdi.seam.solder.core.validation.SeamSolderValidationMessages;
import org.jboss.tools.common.java.IParametedType;
import org.jboss.tools.common.text.ITextSourceReference;

public class GenericBeanValidator {
    Version version;

    public GenericBeanValidator(Version version) {
        this.version = version;
    }

    public void validateResource(IFile file, CDICoreValidator validator, CDICoreNature project, GenericBeanDefinitionContext context) {
        Map<String, GenericConfiguration> cs = context.getGenericConfigurations();
        for (GenericConfiguration c : cs.values()) {
            if (!c.getInvolvedTypes().contains(file.getFullPath())) continue;
            try {
                this.validateConfiguration(file, c, validator, project, context);
            }
            catch (CoreException e) {
                CDISeamSolderCorePlugin.getDefault().logError(e);
            }
        }
    }

    public void validateConfiguration(IFile file, GenericConfiguration c, CDICoreValidator validator, CDICoreNature project, GenericBeanDefinitionContext context) throws CoreException {
        IParametedType t = c.getConfigType();
        AnnotationDefinition genericType = c.getGenericTypeDefinition();
        if (genericType == null) {
            String n = c.getGenericTypeName();
            for (TypeDefinition typeDefinition : c.getGenericBeans()) {
                if (typeDefinition.getResource() == null || !typeDefinition.getResource().equals((Object)file)) continue;
                AnnotationDeclaration a = typeDefinition.getAnnotation(this.version.getGenericConfigurationAnnotationTypeName());
                validator.addError(SeamSolderValidationMessages.WRONG_GENERIC_CONFIGURATION_ANNOTATION_REFERENCE, CDISeamSolderPreferences.WRONG_GENERIC_CONFIGURATION_ANNOTATION_REFERENCE, new String[]{n}, (ITextSourceReference)a, (IResource)file);
            }
        } else if (file.equals((Object)genericType.getResource()) && t != null && context.isGenericBean(t.getType().getFullyQualifiedName())) {
            AnnotationDeclaration a = genericType.getAnnotation(this.version.getGenericTypeAnnotationTypeName());
            validator.addError(SeamSolderValidationMessages.GENERIC_CONFIGURATION_TYPE_IS_A_GENERIC_BEAN, CDISeamSolderPreferences.GENERIC_CONFIGURATION_TYPE_IS_A_GENERIC_BEAN, new String[0], (ITextSourceReference)a, (IResource)file);
        }
        Map<AbstractMemberDefinition, List<IQualifierDeclaration>> bs = c.getGenericConfigurationPoints();
        for (AbstractMemberDefinition abstractMemberDefinition : bs.keySet()) {
            if (abstractMemberDefinition.getResource() == null || !abstractMemberDefinition.getResource().equals((Object)file) || abstractMemberDefinition.getTypeDefinition().isVetoed()) continue;
            ITextSourceReference reference = CDIUtil.convertToSourceReference((ISourceRange)((IMember)abstractMemberDefinition.getMember()).getNameRange(), (IResource)file, (IMember)((IMember)abstractMemberDefinition.getMember()));
            StringBuffer duplicates = new StringBuffer();
            List<IQualifierDeclaration> ds = bs.get(abstractMemberDefinition);
            for (AbstractMemberDefinition d1 : bs.keySet()) {
                List<IQualifierDeclaration> ds2 = bs.get(d1);
                if (ds2 == ds || d1.getTypeDefinition().isVetoed() || !CDIProject.areMatchingQualifiers(ds, ds2) || !CDIProject.areMatchingQualifiers(ds2, ds)) continue;
                duplicates.append(", ").append(this.definitionToString(d1));
            }
            if (duplicates.length() > 0) {
                duplicates.insert(0, this.definitionToString(abstractMemberDefinition));
                String message = NLS.bind((String)SeamSolderValidationMessages.AMBIGUOUS_GENERIC_CONFIGURATION_POINT, (Object)duplicates.toString());
                validator.addError(message, CDISeamSolderPreferences.AMBIGUOUS_GENERIC_CONFIGURATION_POINT, new String[0], reference, (IResource)file);
            }
            IBean b = this.findGenericBean(file, (IMember)abstractMemberDefinition.getMember(), project);
            if (t != null && b != null && CDIProject.containsType((Collection)b.getAllTypes(), (IParametedType)t)) continue;
            validator.addError(SeamSolderValidationMessages.WRONG_TYPE_OF_GENERIC_CONFIGURATION_POINT, CDISeamSolderPreferences.WRONG_TYPE_OF_GENERIC_CONFIGURATION_POINT, new String[0], reference, (IResource)file);
        }
    }

    private String definitionToString(AbstractMemberDefinition d) {
        IAnnotatable e = d.getMember();
        String result = "";
        if (e instanceof IType) {
            result = ((IType)e).getElementName();
        } else if (e instanceof IMember) {
            IMember m = (IMember)e;
            result = String.valueOf(m.getDeclaringType().getElementName()) + "." + m.getElementName();
            if (e instanceof IMethod) {
                result = String.valueOf(result) + "()";
            }
        }
        return result;
    }

    private IBean findGenericBean(IFile file, IMember member, CDICoreNature project) {
        for (IBean b : project.getDelegate().getBeans(file.getFullPath())) {
            if (!(b instanceof IClassBean ? member.equals(((IClassBean)b).getBeanClass()) : b instanceof IProducer && member.equals(((IProducer)b).getSourceMember()))) continue;
            return b;
        }
        return null;
    }
}

