/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.cdi.deltaspike.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.jboss.tools.cdi.core.CDICoreNature;
import org.jboss.tools.cdi.core.IRootDefinitionContext;
import org.jboss.tools.cdi.core.IStereotypeDeclaration;
import org.jboss.tools.cdi.core.extension.ICDIExtension;
import org.jboss.tools.cdi.core.extension.feature.IBuildParticipantFeature;
import org.jboss.tools.cdi.core.extension.feature.IProcessAnnotatedMemberFeature;
import org.jboss.tools.cdi.core.extension.feature.IProcessAnnotatedTypeFeature;
import org.jboss.tools.cdi.core.extension.feature.IValidatorFeature;
import org.jboss.tools.cdi.deltaspike.core.DeltaspikeAuthorityMethod;
import org.jboss.tools.cdi.deltaspike.core.DeltaspikeConstants;
import org.jboss.tools.cdi.deltaspike.core.DeltaspikeCorePlugin;
import org.jboss.tools.cdi.deltaspike.core.DeltaspikeSecurityBindingConfiguration;
import org.jboss.tools.cdi.deltaspike.core.DeltaspikeSecurityDefinitionContext;
import org.jboss.tools.cdi.deltaspike.core.DeltaspikeSeverityPreferences;
import org.jboss.tools.cdi.deltaspike.core.SecurityBindingDeclaration;
import org.jboss.tools.cdi.deltaspike.core.validation.DeltaspikeValidationMessages;
import org.jboss.tools.cdi.internal.core.impl.AnnotationDeclaration;
import org.jboss.tools.cdi.internal.core.impl.CDIProject;
import org.jboss.tools.cdi.internal.core.impl.definition.AbstractMemberDefinition;
import org.jboss.tools.cdi.internal.core.impl.definition.AnnotationDefinition;
import org.jboss.tools.cdi.internal.core.impl.definition.BeanMemberDefinition;
import org.jboss.tools.cdi.internal.core.impl.definition.MethodDefinition;
import org.jboss.tools.cdi.internal.core.impl.definition.TypeDefinition;
import org.jboss.tools.cdi.internal.core.scanner.FileSet;
import org.jboss.tools.cdi.internal.core.validation.CDICoreValidator;
import org.jboss.tools.common.java.IAnnotated;
import org.jboss.tools.common.java.IAnnotationDeclaration;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.preferences.SeverityPreferences;
import org.jboss.tools.common.text.ITextSourceReference;

public class DeltaspikeSecurityExtension
implements ICDIExtension,
IBuildParticipantFeature,
IProcessAnnotatedTypeFeature,
IProcessAnnotatedMemberFeature,
IValidatorFeature,
DeltaspikeConstants {
    public static String ID = "org.apache.deltaspike.security.impl.extension.SecurityExtension";
    DeltaspikeSecurityDefinitionContext context = new DeltaspikeSecurityDefinitionContext();
    static List<SecurityBindingDeclaration> EMPTY = Collections.emptyList();

    public static DeltaspikeSecurityExtension getExtension(CDICoreNature project) {
        return (DeltaspikeSecurityExtension)project.getExtensionManager().getExtensionByRuntime(ID);
    }

    public DeltaspikeSecurityDefinitionContext getContext() {
        return this.context;
    }

    public void beginVisiting() {
    }

    public void visitJar(IPath path, IPackageFragmentRoot root, XModelObject beansXML) {
    }

    public void visit(IFile file, IPath src, IPath webinf) {
    }

    public void buildDefinitions() {
    }

    public void buildDefinitions(FileSet fileSet) {
    }

    public void buildBeans(CDIProject target) {
    }

    public void processAnnotatedMember(BeanMemberDefinition memberDefinition, IRootDefinitionContext context) {
        if (!(memberDefinition instanceof MethodDefinition)) {
            return;
        }
        if (memberDefinition.isAnnotationPresent("org.apache.deltaspike.security.api.authorization.Secures")) {
            MethodDefinition method = (MethodDefinition)memberDefinition;
            method.setCDIAnnotated(true);
            DeltaspikeAuthorityMethod authorizer = new DeltaspikeAuthorityMethod(method);
            DeltaspikeSecurityDefinitionContext contextCopy = (DeltaspikeSecurityDefinitionContext)this.context.getWorkingCopy();
            contextCopy.allAuthorizerMethods.getAuthorizerMembers().add(authorizer);
            List<SecurityBindingDeclaration> ds = this.findAnnotationAnnotatedWithSecurityBindingType((AbstractMemberDefinition)memberDefinition, contextCopy.getRootContext());
            for (SecurityBindingDeclaration d : ds) {
                DeltaspikeSecurityBindingConfiguration c = contextCopy.getConfiguration(d.getBinding().getTypeName());
                authorizer.addBinding(d, c);
                c.getAuthorizerMembers().add(authorizer);
                this.addToDependencies(c, (AbstractMemberDefinition)authorizer.getMethod(), context);
            }
        } else {
            this.addSecurityMember((AbstractMemberDefinition)memberDefinition, context);
        }
    }

    public void processAnnotatedType(TypeDefinition typeDefinition, IRootDefinitionContext context) {
        this.addSecurityMember((AbstractMemberDefinition)typeDefinition, context);
    }

    private void addSecurityMember(AbstractMemberDefinition def, IRootDefinitionContext context) {
        List<SecurityBindingDeclaration> ds = this.findAnnotationAnnotatedWithSecurityBindingType(def, context);
        for (SecurityBindingDeclaration d : ds) {
            this.addBoundMember(def, d, context);
        }
    }

    private void addBoundMember(AbstractMemberDefinition def, SecurityBindingDeclaration d, IRootDefinitionContext context) {
        String securityBindingType = d.getBinding().getTypeName();
        if (def instanceof MethodDefinition) {
            ((MethodDefinition)def).setCDIAnnotated(true);
        }
        DeltaspikeSecurityBindingConfiguration c = ((DeltaspikeSecurityDefinitionContext)this.context.getWorkingCopy()).getConfiguration(securityBindingType);
        c.getBoundMembers().put(def, d);
        this.addToDependencies(c, def, context);
    }

    private void addToDependencies(DeltaspikeSecurityBindingConfiguration c, AbstractMemberDefinition def, IRootDefinitionContext context) {
        IResource r = def.getResource();
        if (r != null && r.exists() && !c.getInvolvedTypes().contains(r.getFullPath())) {
            IPath newPath = r.getFullPath();
            Set<IPath> ps = c.getInvolvedTypes();
            for (IPath p : ps) {
                context.addDependency(p, newPath);
                context.addDependency(newPath, p);
            }
            ps.add(newPath);
        }
    }

    private List<SecurityBindingDeclaration> findAnnotationAnnotatedWithSecurityBindingType(AbstractMemberDefinition m, IRootDefinitionContext context) {
        ArrayList<SecurityBindingDeclaration> result = null;
        List ds = m.getAnnotations();
        for (IAnnotationDeclaration d : ds) {
            List<IAnnotationDeclaration> ds1;
            if (d instanceof IStereotypeDeclaration) {
                AnnotationDefinition t = context.getAnnotation(d.getTypeName());
                if (t == null || (ds1 = this.findSecurityBindingAnnotations((IAnnotated)t, null, context)) == null) continue;
                if (result == null) {
                    result = new ArrayList();
                }
                for (IAnnotationDeclaration d1 : ds1) {
                    result.add(new SecurityBindingDeclaration(d, d1));
                }
                continue;
            }
            if (d.getTypeName() == null) continue;
            AnnotationDefinition a = context.getAnnotation(d.getTypeName());
            if (a != null && a.isAnnotationPresent("org.apache.deltaspike.security.api.authorization.SecurityBindingType")) {
                if (result == null) {
                    result = new ArrayList<SecurityBindingDeclaration>();
                }
                result.add(new SecurityBindingDeclaration(d, d));
                continue;
            }
            if (a == null || !(d instanceof IStereotypeDeclaration) || (ds1 = this.findSecurityBindingAnnotations((IAnnotated)a, null, context)) == null) continue;
            if (result == null) {
                result = new ArrayList();
            }
            for (IAnnotationDeclaration d1 : ds1) {
                result.add(new SecurityBindingDeclaration(d, d1));
            }
        }
        return result == null ? EMPTY : result;
    }

    private List<IAnnotationDeclaration> findSecurityBindingAnnotations(IAnnotated s, List<IAnnotationDeclaration> result, IRootDefinitionContext context) {
        List ds = s.getAnnotations();
        for (IAnnotationDeclaration d : ds) {
            List<IAnnotationDeclaration> ds1;
            if (d.getTypeName() == null) continue;
            AnnotationDefinition a = context.getAnnotation(d.getTypeName());
            if (a != null && a.isAnnotationPresent("org.apache.deltaspike.security.api.authorization.SecurityBindingType")) {
                if (result == null) {
                    result = new ArrayList<IAnnotationDeclaration>();
                }
                result.add(d);
                continue;
            }
            if (a == null || !(d instanceof IStereotypeDeclaration) || (ds1 = this.findSecurityBindingAnnotations((IAnnotated)a, null, context)) == null) continue;
            if (result == null) {
                result = new ArrayList<IAnnotationDeclaration>();
            }
            result.addAll(ds1);
        }
        return result;
    }

    public void validateResource(IFile file, CDICoreValidator validator) {
        Set<DeltaspikeAuthorityMethod> authorizers = this.context.getAuthorityMethods(file.getFullPath());
        for (DeltaspikeAuthorityMethod authorizer : authorizers) {
            AnnotationDeclaration a = authorizer.getMethod().getAnnotation("org.apache.deltaspike.security.api.authorization.Secures");
            if (authorizer.getBindings().isEmpty()) {
                validator.addError(DeltaspikeValidationMessages.INVALID_AUTHORIZER_NO_BINDINGS, DeltaspikeSeverityPreferences.INVALID_AUTHORIZER, new String[]{authorizer.getMethod().getMethod().getElementName()}, (ITextSourceReference)a, (IResource)file);
            } else if (authorizer.getBindings().size() > 1) {
                validator.addError(DeltaspikeValidationMessages.INVALID_AUTHORIZER_MULTIPLE_BINDINGS, DeltaspikeSeverityPreferences.INVALID_AUTHORIZER, new String[]{authorizer.getMethod().getMethod().getElementName()}, (ITextSourceReference)a, (IResource)file);
            }
            try {
                String returnType = authorizer.getMethod().getMethod().getReturnType();
                if ("Z".equals(returnType)) continue;
                validator.addError(DeltaspikeValidationMessages.INVALID_AUTHORIZER_NOT_BOOLEAN, DeltaspikeSeverityPreferences.INVALID_AUTHORIZER, new String[]{authorizer.getMethod().getMethod().getElementName()}, (ITextSourceReference)a, (IResource)file);
            }
            catch (JavaModelException e) {
                DeltaspikeCorePlugin.getDefault().logError(e);
            }
        }
        Set<DeltaspikeSecurityExtension> parents = null;
        for (DeltaspikeSecurityBindingConfiguration c : this.context.getConfigurations().values()) {
            if (!c.getInvolvedTypes().contains(file.getFullPath())) continue;
            if (parents == null) {
                parents = DeltaspikeSecurityExtension.getParents(this.getContext().getRootContext().getProject());
            }
            Set<DeltaspikeAuthorityMethod> authorizers2 = DeltaspikeSecurityExtension.collectAuthorizerMethods(parents, c.getSecurityBindingTypeName());
            authorizers2.addAll(c.getAuthorizerMembers());
            HashSet<String> x = new HashSet<String>();
            Iterator<DeltaspikeAuthorityMethod> it = authorizers2.iterator();
            while (it.hasNext()) {
                DeltaspikeAuthorityMethod a = it.next();
                String key = a.getKey();
                if (x.contains(key)) {
                    it.remove();
                    continue;
                }
                x.add(key);
            }
            Map<AbstractMemberDefinition, SecurityBindingDeclaration> bound = c.getBoundMembers();
            for (AbstractMemberDefinition d : bound.keySet()) {
                String name;
                String string = d instanceof MethodDefinition ? ((MethodDefinition)d).getMethod().getElementName() : (name = d instanceof TypeDefinition ? ((TypeDefinition)d).getQualifiedName() : "");
                if (!file.getFullPath().equals((Object)d.getTypeDefinition().getType().getPath())) continue;
                SecurityBindingDeclaration dc = bound.get(d);
                int k = 0;
                for (DeltaspikeAuthorityMethod a : authorizers2) {
                    try {
                        if (!a.isMatching(dc.getBinding())) continue;
                        ++k;
                    }
                    catch (CoreException e) {
                        DeltaspikeCorePlugin.getDefault().logError(e);
                    }
                }
                if (k == 0) {
                    validator.addError(DeltaspikeValidationMessages.UNRESOLVED_AUTHORIZER, DeltaspikeSeverityPreferences.UNRESOLVED_AUTHORIZER, new String[]{dc.getBinding().getTypeName(), name}, (ITextSourceReference)dc.getDeclaration(), (IResource)file);
                    continue;
                }
                if (k <= true) continue;
                validator.addError(DeltaspikeValidationMessages.AMBIGUOUS_AUTHORIZER, DeltaspikeSeverityPreferences.AMBIGUOUS_AUTHORIZER, new String[]{dc.getBinding().getTypeName(), name}, (ITextSourceReference)dc.getDeclaration(), (IResource)file);
            }
        }
    }

    public SeverityPreferences getSeverityPreferences() {
        return DeltaspikeSeverityPreferences.getInstance();
    }

    public static Set<DeltaspikeSecurityExtension> getParents(CDICoreNature nature) {
        Set ps = nature.getCDIProjects(true);
        HashSet<DeltaspikeSecurityExtension> parents = new HashSet<DeltaspikeSecurityExtension>();
        for (CDICoreNature p : ps) {
            DeltaspikeSecurityExtension ext = DeltaspikeSecurityExtension.getExtension(p);
            if (ext == null) continue;
            parents.add(ext);
        }
        return parents;
    }

    public static Set<DeltaspikeAuthorityMethod> collectAuthorizerMethods(Set<DeltaspikeSecurityExtension> parents, String securityBindingTypeName) {
        HashSet<DeltaspikeAuthorityMethod> result = new HashSet<DeltaspikeAuthorityMethod>();
        for (DeltaspikeSecurityExtension ext : parents) {
            DeltaspikeSecurityBindingConfiguration c = ext.getContext().getConfiguration(securityBindingTypeName);
            if (c == null) continue;
            result.addAll(c.getAuthorizerMembers());
        }
        return result;
    }
}

