/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.seam.xml.test;

import junit.framework.TestCase;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.filesystems.impl.AbstractExtendedXMLFileImpl;
import org.jboss.tools.common.model.markers.XMarkerManager;
import org.jboss.tools.common.model.util.EclipseResourceUtil;
import org.jboss.tools.test.util.JobUtils;

public class SeamXMLModelTest
extends TestCase {
    IProject project = null;

    protected void setUp() throws Exception {
        this.project = ResourcesPlugin.getWorkspace().getRoot().getProject("Test");
    }

    public void testXMLModel() {
        IFile f = this.project.getFile((IPath)new Path("components22.xml"));
        SeamXMLModelTest.assertTrue((String)"File components22.xml is not accessible in Test project.", (boolean)f.isAccessible());
        XModelObject fileObject = EclipseResourceUtil.createObjectForResource((IResource)f);
        SeamXMLModelTest.assertNotNull((String)"Cannot create XModel object for file components22.xml.", (Object)fileObject);
        String entity = fileObject.getModelEntity().getName();
        SeamXMLModelTest.assertEquals((String)"File components22.xml is incorrectly parsed by XModel.", (String)"FileSeamComponents22", (String)entity);
    }

    public void testComponentFile() {
        XModelObject fileObject = this.getComponent22Object();
        String entity = fileObject.getModelEntity().getName();
        SeamXMLModelTest.assertEquals((String)"File XYZ.component.xml is incorrectly parsed by XModel.", (String)"FileSeamComponent22", (String)entity);
    }

    protected XModelObject getComponents22Object() {
        IFile f = this.project.getFile((IPath)new Path("components22.xml"));
        SeamXMLModelTest.assertTrue((boolean)f.exists());
        return EclipseResourceUtil.createObjectForResource((IResource)f);
    }

    protected XModelObject getComponent22Object() {
        IFile f = this.project.getFile((IPath)new Path("XYZ.component.xml"));
        SeamXMLModelTest.assertNotNull((Object)f);
        SeamXMLModelTest.assertTrue((boolean)f.exists());
        return EclipseResourceUtil.createObjectForResource((IResource)f);
    }

    protected XModelObject getComponents23Object() {
        IFile f = this.project.getFile((IPath)new Path("components23.xml"));
        SeamXMLModelTest.assertTrue((boolean)f.exists());
        return EclipseResourceUtil.createObjectForResource((IResource)f);
    }

    public void testNavigationPagesComponent() {
        XModelObject fileObject = this.getComponents22Object();
        SeamXMLModelTest.assertNotNull((String)"Cannot create XModel object for file components22.xml.", (Object)fileObject);
        XModelObject navigationPages = fileObject.getChildByPath("org.jboss.seam.navigation.pages");
        SeamXMLModelTest.assertNotNull((String)"Cannot find org.jboss.seam.navigation.pages", (Object)navigationPages);
        XModelObject resources = navigationPages.getChildByPath("resources");
        SeamXMLModelTest.assertNotNull((String)"Cannot find resources in org.jboss.seam.navigation.pages", (Object)resources);
        XModelObject[] resourcesList = resources.getChildren();
        SeamXMLModelTest.assertEquals((int)1, (int)resourcesList.length);
        this.assertAttribute(navigationPages, "no-conversation-view-id", "a.xhtml");
        this.assertAttribute(navigationPages, "login-view-id", "b.xhtml");
        this.assertAttribute(navigationPages, "http-port", "1111");
        this.assertAttribute(navigationPages, "https-port", "1112");
    }

    public void testDebugAttribute() {
        XModelObject fileObject = this.getComponents22Object();
        JobUtils.waitForIdle();
        SeamXMLModelTest.assertNotNull((String)"Cannot create XModel object for file components22.xml.", (Object)fileObject);
        ((AbstractExtendedXMLFileImpl)fileObject).check();
        XMarkerManager.getInstance().getErrorState(fileObject);
        XModelObject coreInit0 = fileObject.getChildByPath("org.jboss.seam.core.init");
        SeamXMLModelTest.assertNotNull((String)"Cannot find component org.jboss.seam.core.init.", (Object)coreInit0);
        SeamXMLModelTest.assertFalse((String)"Validator found wrong errors in component org.jboss.seam.core.init", (boolean)XMarkerManager.getInstance().hasErrors(coreInit0));
        XModelObject coreInit1 = fileObject.getChildByPath("org.jboss.seam.core.init1");
        SeamXMLModelTest.assertNotNull((String)"Cannot find component org.jboss.seam.core.init1.", (Object)coreInit1);
        SeamXMLModelTest.assertTrue((String)"Validator failed to report an error in component org.jboss.seam.core.init1", (boolean)XMarkerManager.getInstance().hasErrors(coreInit1));
        XModelObject coreInit2 = fileObject.getChildByPath("org.jboss.seam.core.init2");
        SeamXMLModelTest.assertNotNull((String)"Cannot find component org.jboss.seam.core.init2.", (Object)coreInit2);
        SeamXMLModelTest.assertFalse((String)"Validator found wrong errors in component org.jboss.seam.core.init2", (boolean)XMarkerManager.getInstance().hasErrors(coreInit2));
    }

    public void testXML23Model() {
        IFile f = this.project.getFile((IPath)new Path("components23.xml"));
        SeamXMLModelTest.assertTrue((String)"File components23.xml is not accessible in Test project.", (boolean)f.isAccessible());
        XModelObject fileObject = EclipseResourceUtil.createObjectForResource((IResource)f);
        SeamXMLModelTest.assertNotNull((String)"Cannot create XModel object for file components22.xml.", (Object)fileObject);
        String entity = fileObject.getModelEntity().getName();
        SeamXMLModelTest.assertEquals((String)"File components23.xml is incorrectly parsed by XModel.", (String)"FileSeamComponents23", (String)entity);
        XModelObject c = fileObject.getChildByPath("myComponent");
        SeamXMLModelTest.assertNotNull((Object)c);
        XModelObject p = c.getChildByPath("p");
        SeamXMLModelTest.assertNotNull((Object)p);
        XModelObject[] vs = p.getChildren();
        SeamXMLModelTest.assertEquals((int)2, (int)vs.length);
        SeamXMLModelTest.assertEquals((String)"v", (String)vs[0].getAttributeValue("value"));
        SeamXMLModelTest.assertEquals((String)"v", (String)vs[1].getAttributeValue("value"));
        c = fileObject.getChildByPath("myType");
        SeamXMLModelTest.assertNotNull((Object)c);
        vs = c.getChildren();
        SeamXMLModelTest.assertEquals((int)2, (int)vs.length);
        SeamXMLModelTest.assertEquals((String)"a", (String)vs[0].getAttributeValue("execute"));
        SeamXMLModelTest.assertEquals((String)"a", (String)vs[1].getAttributeValue("execute"));
        c = fileObject.getChildByPath("myFactory");
        SeamXMLModelTest.assertNotNull((Object)c);
        SeamXMLModelTest.assertEquals((String)"myFactory", (String)c.getAttributeValue("value"));
        c = fileObject.getChildByPath("org.jboss.seam.navigation.pages");
        SeamXMLModelTest.assertNotNull((Object)c);
        SeamXMLModelTest.assertEquals((String)"3", (String)c.getAttributeValue("http-port"));
        c = fileObject.getChildByPath("org.jboss.seam.remoting.remoting");
        SeamXMLModelTest.assertNotNull((Object)c);
        SeamXMLModelTest.assertEquals((String)"1", (String)c.getAttributeValue("poll-interval"));
        SeamXMLModelTest.assertEquals((String)"2", (String)c.getAttributeValue("poll-timeout"));
        c = fileObject.getChildByPath("entityQuery");
        SeamXMLModelTest.assertNotNull((Object)c);
        SeamXMLModelTest.assertEquals((String)"abc", (String)c.getAttributeValue("ejbql"));
        c = fileObject.getChildByPath("hibernateEntityQuery");
        SeamXMLModelTest.assertNotNull((Object)c);
        SeamXMLModelTest.assertEquals((String)"abc", (String)c.getAttributeValue("ejbql"));
        SeamXMLModelTest.assertEquals((String)"sss", (String)c.getAttributeValue("cache-region"));
        SeamXMLModelTest.assertEquals((String)"3", (String)c.getAttributeValue("fetch-size"));
        SeamXMLModelTest.assertEquals((String)"x", (String)c.getAttributeValue("session"));
        c = fileObject.getChildByPath("entityHome");
        SeamXMLModelTest.assertNotNull((Object)c);
        SeamXMLModelTest.assertEquals((String)"org.MyEntityHome", (String)c.getAttributeValue("entity-class"));
        c = fileObject.getChildByPath("hibernateEntityHome");
        SeamXMLModelTest.assertNotNull((Object)c);
        c = fileObject.getChildByPath("org.jboss.seam.security.identity");
        SeamXMLModelTest.assertNotNull((Object)c);
        SeamXMLModelTest.assertEquals((String)"#{m1}", (String)c.getAttributeValue("authenticate-method"));
        SeamXMLModelTest.assertEquals((String)"true", (String)c.getAttributeValue("remember-me"));
        c = fileObject.getChildByPath("org.jboss.seam.security.identityManager");
        SeamXMLModelTest.assertNotNull((Object)c);
        SeamXMLModelTest.assertEquals((String)"#{xyz}", (String)c.getAttributeValue("identity-store"));
        c = fileObject.getChildByPath("org.jboss.seam.security.jpaIdentityStore");
        SeamXMLModelTest.assertNotNull((Object)c);
        SeamXMLModelTest.assertEquals((String)"myManager", (String)c.getAttributeValue("entity-manager"));
        SeamXMLModelTest.assertEquals((String)"org.MyStore", (String)c.getAttributeValue("user-class"));
        c = fileObject.getChildByPath("org.jboss.seam.security.jpaTokenStore");
        SeamXMLModelTest.assertNotNull((Object)c);
        SeamXMLModelTest.assertEquals((String)"myEntityManager", (String)c.getAttributeValue("entity-manager"));
        SeamXMLModelTest.assertEquals((String)"String", (String)c.getAttributeValue("token-class"));
        c = fileObject.getChildByPath("org.jboss.seam.security.ldapIdentityStore");
        SeamXMLModelTest.assertNotNull((Object)c);
        SeamXMLModelTest.assertEquals((String)"777", (String)c.getAttributeValue("server-address"));
        SeamXMLModelTest.assertEquals((String)"555", (String)c.getAttributeValue("server-port"));
        c = fileObject.getChildByPath("org.jboss.seam.security.permissionManager");
        SeamXMLModelTest.assertNotNull((Object)c);
        SeamXMLModelTest.assertEquals((String)"#{permissionStore}", (String)c.getAttributeValue("permission-store"));
        c = fileObject.getChildByPath("org.jboss.seam.security.jpaPermissionStore");
        SeamXMLModelTest.assertNotNull((Object)c);
        SeamXMLModelTest.assertEquals((String)"myEntityManager", (String)c.getAttributeValue("entity-manager"));
        SeamXMLModelTest.assertEquals((String)"org.MyPermissionClass", (String)c.getAttributeValue("user-permission-class"));
        c = fileObject.getChildByPath("org.jboss.seam.security.ruleBasedPermissionResolver");
        SeamXMLModelTest.assertNotNull((Object)c);
        SeamXMLModelTest.assertEquals((String)"#{myRules}", (String)c.getAttributeValue("security-rules"));
        c = fileObject.getChildByPath("org.jboss.seam.security.persistentPermissionResolver");
        SeamXMLModelTest.assertNotNull((Object)c);
        SeamXMLModelTest.assertEquals((String)"#{myPermissionStore}", (String)c.getAttributeValue("permission-store"));
        c = fileObject.getChildByPath("org.jboss.seam.security.rememberMe");
        SeamXMLModelTest.assertNotNull((Object)c);
        SeamXMLModelTest.assertEquals((String)"101", (String)c.getAttributeValue("cookie-max-age"));
        SeamXMLModelTest.assertEquals((String)"disabled", (String)c.getAttributeValue("mode"));
        c = fileObject.getChildByPath("org.jboss.seam.transaction.transaction");
        SeamXMLModelTest.assertNotNull((Object)c);
        SeamXMLModelTest.assertEquals((String)"abc", (String)c.getAttributeValue("jndi-name"));
        c = fileObject.getChildByPath("org.jboss.seam.ui.jpaEntityLoader");
        SeamXMLModelTest.assertNotNull((Object)c);
        SeamXMLModelTest.assertEquals((String)"myEntityManager", (String)c.getAttributeValue("entity-manager"));
        c = fileObject.getChildByPath("org.jboss.seam.ui.hibernateEntityLoader");
        SeamXMLModelTest.assertNotNull((Object)c);
        SeamXMLModelTest.assertEquals((String)"mySession", (String)c.getAttributeValue("session"));
        c = fileObject.getChildByPath("org.jboss.seam.ui.entityConverter");
        SeamXMLModelTest.assertNotNull((Object)c);
        SeamXMLModelTest.assertEquals((String)"myEntityLoader", (String)c.getAttributeValue("entity-loader"));
        c = fileObject.getChildByPath("org.jboss.seam.web.contextFilter");
        SeamXMLModelTest.assertNotNull((Object)c);
        SeamXMLModelTest.assertEquals((String)"*", (String)c.getAttributeValue("url-pattern"));
        c = fileObject.getChildByPath("org.jboss.seam.web.exceptionFilter");
        SeamXMLModelTest.assertNotNull((Object)c);
        SeamXMLModelTest.assertEquals((String)"*", (String)c.getAttributeValue("url-pattern"));
        c = fileObject.getChildByPath("org.jboss.seam.web.multipartFilter");
        SeamXMLModelTest.assertNotNull((Object)c);
        SeamXMLModelTest.assertEquals((String)"*", (String)c.getAttributeValue("url-pattern"));
        c = fileObject.getChildByPath("org.jboss.seam.web.ajax4jsfFilter");
        SeamXMLModelTest.assertNotNull((Object)c);
        c = fileObject.getChildByPath("org.jboss.seam.web.authenticationFilter");
        SeamXMLModelTest.assertNotNull((Object)c);
        c = fileObject.getChildByPath("org.jboss.seam.web.cacheControlFilter");
        SeamXMLModelTest.assertNotNull((Object)c);
        c = fileObject.getChildByPath("org.jboss.seam.servlet.characterEncodingFilter");
        SeamXMLModelTest.assertNotNull((Object)c);
        c = fileObject.getChildByPath("org.jboss.seam.web.hotDeployFilter");
        SeamXMLModelTest.assertNotNull((Object)c);
        c = fileObject.getChildByPath("org.jboss.seam.web.identityFilter");
        SeamXMLModelTest.assertNotNull((Object)c);
        c = fileObject.getChildByPath("org.jboss.seam.web.loggingFilter");
        SeamXMLModelTest.assertNotNull((Object)c);
        c = fileObject.getChildByPath("org.jboss.seam.web.redirectFilter");
        SeamXMLModelTest.assertNotNull((Object)c);
        c = fileObject.getChildByPath("org.jboss.seam.web.rewriteFilter");
        SeamXMLModelTest.assertNotNull((Object)c);
        c = fileObject.getChildByPath("org.jboss.seam.web.session");
        SeamXMLModelTest.assertNotNull((Object)c);
        c = fileObject.getChildByPath("org.jboss.seam.web.wicketFilter");
        SeamXMLModelTest.assertNotNull((Object)c);
        SeamXMLModelTest.assertEquals((String)"myClass", (String)c.getAttributeValue("application-class"));
        c = fileObject.getChildByPath("myPersistentContext");
        SeamXMLModelTest.assertNotNull((Object)c);
        SeamXMLModelTest.assertEquals((String)"myname", (String)c.getAttributeValue("persistence-unit-jndi-name"));
        c = fileObject.getChildByPath("myManagerFactory");
        SeamXMLModelTest.assertNotNull((Object)c);
        SeamXMLModelTest.assertEquals((String)"myName", (String)c.getAttributeValue("persistence-unit-name"));
        c = fileObject.getChildByPath("myFilter");
        SeamXMLModelTest.assertNotNull((Object)c);
        SeamXMLModelTest.assertEquals((String)"myFilterName", (String)c.getAttributeValue("filter name"));
        c = fileObject.getChildByPath("mySession");
        SeamXMLModelTest.assertNotNull((Object)c);
        c = fileObject.getChildByPath("mySessionFactory");
        SeamXMLModelTest.assertNotNull((Object)c);
        c = fileObject.getChildByPath("org.jboss.seam.async.dispatcher");
        SeamXMLModelTest.assertNotNull((Object)c);
        c = fileObject.getChildByPath("myManagedWorkingMemory");
        SeamXMLModelTest.assertNotNull((Object)c);
        c = fileObject.getChildByPath("myRuleBase");
        SeamXMLModelTest.assertNotNull((Object)c);
        SeamXMLModelTest.assertEquals((String)"fff", (String)c.getAttributeValue("rule-files"));
        c = fileObject.getChildByPath("myRuleAgent");
        SeamXMLModelTest.assertNotNull((Object)c);
        SeamXMLModelTest.assertEquals((String)"fff", (String)c.getAttributeValue("configuration-file"));
        c = fileObject.getChildByPath("org.jboss.seam.international.localeSelector");
        SeamXMLModelTest.assertNotNull((Object)c);
        SeamXMLModelTest.assertEquals((String)"ss", (String)c.getAttributeValue("locale-string"));
        c = fileObject.getChildByPath("org.jboss.seam.international.timeZoneSelector");
        SeamXMLModelTest.assertNotNull((Object)c);
        SeamXMLModelTest.assertEquals((String)"22", (String)c.getAttributeValue("time-zone-id"));
        c = fileObject.getChildByPath("org.jboss.seam.international.localeConfig");
        SeamXMLModelTest.assertNotNull((Object)c);
        SeamXMLModelTest.assertEquals((String)"ru", (String)c.getAttributeValue("default-locale"));
        c = fileObject.getChildByPath("org.jboss.seam.wicket.webApplication");
        SeamXMLModelTest.assertNotNull((Object)c);
        SeamXMLModelTest.assertEquals((String)"org.MyApplication", (String)c.getAttributeValue("application-class"));
        c = fileObject.getChildByPath("myKeyStore");
        SeamXMLModelTest.assertNotNull((Object)c);
        SeamXMLModelTest.assertEquals((String)"a", (String)c.getAttributeValue("key-alias"));
        SeamXMLModelTest.assertEquals((String)"p", (String)c.getAttributeValue("key-password"));
        SeamXMLModelTest.assertEquals((String)"keyStore", (String)c.getAttributeValue("key-store"));
        SeamXMLModelTest.assertEquals((String)"q", (String)c.getAttributeValue("key-store-password"));
        c = fileObject.getChildByPath("org.jboss.seam.core.init");
        SeamXMLModelTest.assertNotNull((Object)c);
        SeamXMLModelTest.assertEquals((String)"pp", (String)c.getAttributeValue("jndi-pattern"));
        SeamXMLModelTest.assertEquals((String)"true", (String)c.getAttributeValue("security-enabled"));
        SeamXMLModelTest.assertEquals((String)"true", (String)c.getAttributeValue("transaction-management-enabled"));
        c = fileObject.getChildByPath("org.jboss.seam.core.manager");
        SeamXMLModelTest.assertNotNull((Object)c);
        SeamXMLModelTest.assertEquals((String)"1", (String)c.getAttributeValue("conversation-timeout"));
        SeamXMLModelTest.assertEquals((String)"1", (String)c.getAttributeValue("concurrent-request-timeout"));
        SeamXMLModelTest.assertEquals((String)"p", (String)c.getAttributeValue("conversation-id-parameter"));
        SeamXMLModelTest.assertEquals((String)"MANUAL", (String)c.getAttributeValue("default-flush-mode"));
        SeamXMLModelTest.assertEquals((String)"q", (String)c.getAttributeValue("parent-conversation-id-parameter"));
        c = fileObject.getChildByPath("org.jboss.seam.core.pojoCache");
        SeamXMLModelTest.assertNotNull((Object)c);
        SeamXMLModelTest.assertEquals((String)"nnn", (String)c.getAttributeValue("cfg-resource-name"));
        c = fileObject.getChildByPath("org.jboss.seam.core.resourceLoader");
        SeamXMLModelTest.assertNotNull((Object)c);
        SeamXMLModelTest.assertEquals((String)"n1,n2", (String)c.getAttributeValue("bundle-names"));
        c = fileObject.getChildByPath("mySelector");
        SeamXMLModelTest.assertNotNull((Object)c);
        SeamXMLModelTest.assertEquals((String)"x", (String)c.getAttributeValue("theme"));
        SeamXMLModelTest.assertEquals((String)"x,y", (String)c.getAttributeValue("available-themes"));
        SeamXMLModelTest.assertEquals((String)"true", (String)c.getAttributeValue("cookie-enabled"));
        SeamXMLModelTest.assertEquals((String)"100", (String)c.getAttributeValue("cookie-max-age"));
        c = fileObject.getChildByPath("org.jboss.seam.jms.queueConnection");
        SeamXMLModelTest.assertNotNull((Object)c);
        SeamXMLModelTest.assertEquals((String)"myName", (String)c.getAttributeValue("factory-jndi-name"));
        c = fileObject.getChildByPath("org.jboss.seam.jms.topicConnection");
        SeamXMLModelTest.assertNotNull((Object)c);
        SeamXMLModelTest.assertEquals((String)"factory", (String)c.getAttributeValue("factory-jndi-name"));
        c = fileObject.getChildByPath("myTopicPublisher");
        SeamXMLModelTest.assertNotNull((Object)c);
        SeamXMLModelTest.assertEquals((String)"jjj", (String)c.getAttributeValue("topic-jndi-name"));
        c = fileObject.getChildByPath("mySender");
        SeamXMLModelTest.assertNotNull((Object)c);
        SeamXMLModelTest.assertEquals((String)"nn", (String)c.getAttributeValue("queue-jndi-name"));
        c = fileObject.getChildByPath("org.jboss.seam.bpm.actor");
        SeamXMLModelTest.assertNotNull((Object)c);
        SeamXMLModelTest.assertEquals((String)"1", (String)c.getAttributeValue("group-actor-ids"));
        c = fileObject.getChildByPath("org.jboss.seam.bpm.jbpm");
        SeamXMLModelTest.assertNotNull((Object)c);
    }

    protected void assertAttribute(XModelObject object, String name, String value) {
        String actual = object.getAttributeValue(name);
        SeamXMLModelTest.assertEquals((String)("Attribute " + name + " in " + object.getPresentationString() + " is incorrect."), (String)value, (String)actual);
    }
}

