/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.seam.core.test;

import junit.framework.TestCase;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.jboss.tools.seam.core.ISeamProject;
import org.jboss.tools.seam.core.SeamCoreBuilder;
import org.jboss.tools.seam.internal.core.SeamProject;
import org.jboss.tools.test.util.JUnitUtils;
import org.jboss.tools.test.util.JobUtils;
import org.jboss.tools.test.util.ResourcesUtils;
import org.jboss.tools.test.util.TestProjectProvider;

public class ComponentsFromLibTest
extends TestCase {
    static String BUNDLE = "org.jboss.tools.seam.core.test";
    IProject project1;
    TestProjectProvider provider1;

    protected void setUp() throws Exception {
        this.provider1 = new TestProjectProvider(BUNDLE, "/projects/SeamJava", "SeamJava", true);
        this.project1 = this.provider1.getProject();
        boolean saveAutoBuild = ResourcesUtils.setBuildAutomatically((boolean)false);
        IFile source = this.project1.getFile((IPath)new Path("lib/jboss-seam-2.0.2.SP1.jar"));
        IFile target = this.project1.getFile((IPath)new Path("lib/jboss-seam.jar"));
        target.create(source.getContents(), 1, (IProgressMonitor)new NullProgressMonitor());
        this.project1.build(10, (IProgressMonitor)new NullProgressMonitor());
        this.project1.build(6, SeamCoreBuilder.BUILDER_ID, null, (IProgressMonitor)new NullProgressMonitor());
        JobUtils.waitForIdle();
        ResourcesUtils.setBuildAutomatically((boolean)saveAutoBuild);
    }

    public void testComponentsFromLib() {
        ISeamProject sp1 = this.getSeamProject1();
        String component = "org.jboss.seam.core.conversation";
        ComponentsFromLibTest.assertNotNull((String)("Bean " + component + " is not found in project CycleTest1"), (Object)sp1.getComponent(component));
    }

    private ISeamProject getSeamProject1() {
        ISeamProject seamProject = null;
        try {
            seamProject = (ISeamProject)this.project1.getNature("org.jboss.tools.seam.core.seamnature");
        }
        catch (Exception e) {
            JUnitUtils.fail((String)"Cannot get seam nature.", (Exception)e);
        }
        ComponentsFromLibTest.assertNotNull((String)"Seam project is null", (Object)seamProject);
        return seamProject;
    }

    protected void tearDown() throws Exception {
        ISeamProject sp1 = this.getSeamProject1();
        SeamProject impl1 = (SeamProject)sp1;
        if (impl1 != null) {
            impl1.clearStorage();
        }
        this.provider1.dispose();
    }
}

