/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.seam.core.test;

import junit.framework.TestCase;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.jboss.tools.seam.core.ISeamProject;
import org.jboss.tools.seam.internal.core.SeamProject;
import org.jboss.tools.test.util.JUnitUtils;
import org.jboss.tools.test.util.ResourcesUtils;
import org.jboss.tools.test.util.TestProjectProvider;

public class CyclicDependingProjectsTest
extends TestCase {
    static String BUNDLE = "org.jboss.tools.seam.base.test";
    IProject project1;
    TestProjectProvider provider1;
    IProject project2;
    TestProjectProvider provider2;

    protected void setUp() throws Exception {
        this.provider1 = new TestProjectProvider(BUNDLE, "/projects/CycleTest1", "CycleTest1", true);
        this.project1 = this.provider1.getProject();
        this.provider2 = new TestProjectProvider(BUNDLE, "/projects/CycleTest2", "CycleTest2", true);
        this.project2 = this.provider2.getProject();
        boolean saveAutoBuild = ResourcesUtils.setBuildAutomatically((boolean)false);
        this.project1.build(15, (IProgressMonitor)new NullProgressMonitor());
        this.project2.build(15, (IProgressMonitor)new NullProgressMonitor());
        this.project1.build(6, (IProgressMonitor)new NullProgressMonitor());
        this.project2.build(6, (IProgressMonitor)new NullProgressMonitor());
        ResourcesUtils.setBuildAutomatically((boolean)saveAutoBuild);
    }

    public void testCyclicDependingProjects() {
        ISeamProject sp1 = this.getSeamProject1();
        CyclicDependingProjectsTest.assertNotNull((String)"Bean test.bean1 is not found in project CycleTest1", (Object)sp1.getComponent("test.bean1"));
        CyclicDependingProjectsTest.assertNotNull((String)"Bean test.bean2 is not found in project CycleTest1", (Object)sp1.getComponent("test.bean2"));
        ISeamProject sp2 = this.getSeamProject2();
        CyclicDependingProjectsTest.assertNotNull((String)"Bean test.bean1 is not found in project CycleTest2", (Object)sp2.getComponent("test.bean1"));
        CyclicDependingProjectsTest.assertNotNull((String)"Bean test.bean2 is not found in project CycleTest2", (Object)sp2.getComponent("test.bean2"));
    }

    private ISeamProject getSeamProject1() {
        ISeamProject seamProject = null;
        try {
            seamProject = (ISeamProject)this.project1.getNature("org.jboss.tools.seam.core.seamnature");
        }
        catch (Exception e) {
            JUnitUtils.fail((String)"Cannot get seam nature.", (Exception)e);
        }
        CyclicDependingProjectsTest.assertNotNull((String)"Seam project is null", (Object)seamProject);
        return seamProject;
    }

    private ISeamProject getSeamProject2() {
        ISeamProject seamProject = null;
        try {
            seamProject = (ISeamProject)this.project2.getNature("org.jboss.tools.seam.core.seamnature");
        }
        catch (Exception e) {
            JUnitUtils.fail((String)"Cannot get seam nature.", (Exception)e);
        }
        CyclicDependingProjectsTest.assertNotNull((String)"Seam project is null", (Object)seamProject);
        return seamProject;
    }

    protected void tearDown() throws Exception {
        ISeamProject sp2;
        SeamProject impl2;
        ISeamProject sp1 = this.getSeamProject1();
        SeamProject impl1 = (SeamProject)sp1;
        if (impl1 != null) {
            impl1.clearStorage();
        }
        if ((impl2 = (SeamProject)(sp2 = this.getSeamProject2())) != null) {
            impl2.clearStorage();
        }
        this.provider1.dispose();
        this.provider2.dispose();
    }
}

