/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.seam.core.test;

import java.util.List;
import java.util.Set;
import junit.framework.TestCase;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.jboss.tools.common.text.ITextSourceReference;
import org.jboss.tools.seam.core.BeanType;
import org.jboss.tools.seam.core.BijectedAttributeType;
import org.jboss.tools.seam.core.IBijectedAttribute;
import org.jboss.tools.seam.core.ISeamAnnotatedFactory;
import org.jboss.tools.seam.core.ISeamComponent;
import org.jboss.tools.seam.core.ISeamComponentDeclaration;
import org.jboss.tools.seam.core.ISeamComponentMethod;
import org.jboss.tools.seam.core.ISeamFactory;
import org.jboss.tools.seam.core.ISeamJavaComponentDeclaration;
import org.jboss.tools.seam.core.ISeamProject;
import org.jboss.tools.seam.core.ISeamProperty;
import org.jboss.tools.seam.core.ISeamXmlComponentDeclaration;
import org.jboss.tools.seam.core.ISeamXmlFactory;
import org.jboss.tools.seam.core.ScopeType;
import org.jboss.tools.seam.core.SeamComponentMethodType;
import org.jboss.tools.seam.core.SeamCoreBuilder;
import org.jboss.tools.seam.core.event.ISeamValue;
import org.jboss.tools.seam.core.event.ISeamValueList;
import org.jboss.tools.seam.core.event.ISeamValueMap;
import org.jboss.tools.seam.core.event.ISeamValueMapEntry;
import org.jboss.tools.seam.core.event.ISeamValueString;
import org.jboss.tools.seam.internal.core.SeamProject;
import org.jboss.tools.seam.internal.core.scanner.IFileScanner;
import org.jboss.tools.seam.internal.core.scanner.LoadedDeclarations;
import org.jboss.tools.seam.internal.core.scanner.lib.ClassPath;
import org.jboss.tools.seam.internal.core.scanner.lib.LibraryScanner;
import org.jboss.tools.test.util.JUnitUtils;
import org.jboss.tools.test.util.TestProjectProvider;

public class ScannerTest
extends TestCase {
    IProject project = null;
    TestProjectProvider provider = null;
    boolean makeCopy = true;

    public ScannerTest() {
        super("Seam Scanner test");
    }

    protected void setUp() throws Exception {
        this.project = ResourcesPlugin.getWorkspace().getRoot().getProject("TestScanner");
        if (!this.project.exists()) {
            this.provider = new TestProjectProvider("org.jboss.tools.seam.base.test", null, "TestScanner", true);
            this.project = this.provider.getProject();
        }
        this.project.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
        this.project.build(6, null);
    }

    private ISeamProject getSeamProject() {
        ISeamProject seamProject = null;
        try {
            seamProject = (ISeamProject)this.project.getNature("org.jboss.tools.seam.core.seamnature");
        }
        catch (Exception e) {
            JUnitUtils.fail((String)"Cannot get seam nature.", (Exception)e);
        }
        ScannerTest.assertNotNull((String)"Seam project is null", (Object)seamProject);
        return seamProject;
    }

    public void testXMLScanner() {
        ISeamProject seamProject = this.getSeamProject();
        IFile f = this.project.getFile("WebContent/WEB-INF/components.xml");
        ScannerTest.assertTrue((String)"Cannot find components.xml in test project", (f != null && f.exists() ? 1 : 0) != 0);
        IFileScanner scanner = SeamCoreBuilder.createXMLScanner();
        ScannerTest.assertTrue((String)"Scanner cannot recognise components.xml", (boolean)scanner.isRelevant(f));
        ScannerTest.assertTrue((String)"Scanner cannot recognise components.xml content", (boolean)scanner.isLikelyComponentSource(f));
        ISeamComponentDeclaration[] cs = null;
        ISeamFactory[] fs = null;
        try {
            LoadedDeclarations ds = scanner.parse(f, seamProject);
            cs = ds.getComponents().toArray(new ISeamComponentDeclaration[0]);
            fs = ds.getFactories().toArray(new ISeamFactory[0]);
        }
        catch (Exception e) {
            JUnitUtils.fail((String)"Error in xml scanner", (Exception)e);
        }
        ScannerTest.assertTrue((String)"Components are not found in components.xml", (cs != null && cs.length > 0 ? 1 : 0) != 0);
        ISeamComponentDeclaration myComponent = this.findDeclaration(cs, "myComponent");
        ScannerTest.assertTrue((String)"Declaration of myComponent is not found", (boolean)(myComponent instanceof ISeamXmlComponentDeclaration));
        ISeamProperty property = ((ISeamXmlComponentDeclaration)myComponent).getProperty("myList");
        ScannerTest.assertTrue((String)"Property myList is not found in declaration 'myComponent'", (property != null ? 1 : 0) != 0);
        ISeamValue o = property.getValue();
        ScannerTest.assertTrue((String)"Property myList in myComponent must be instanceof ISeamValueList", (boolean)(o instanceof ISeamValueList));
        ISeamValueList oList = (ISeamValueList)o;
        ScannerTest.assertTrue((String)"Property myList misses value 'value1.", (boolean)"value1".equals(((ISeamValueString)oList.getValues().get(0)).getValue().getValue()));
        property = ((ISeamXmlComponentDeclaration)myComponent).getProperty("myMap");
        ScannerTest.assertTrue((String)"Property myMap is not found in declaration 'myComponent'", (property != null ? 1 : 0) != 0);
        o = property.getValue();
        ScannerTest.assertTrue((String)"Property myMap in myComponent must be instanceof ISeamValueMap", (boolean)(o instanceof ISeamValueMap));
        ISeamValueMap oMap = (ISeamValueMap)o;
        List es = oMap.getEntries();
        ScannerTest.assertTrue((String)"Property myMap in myComponent is empty", (es.size() > 0 ? 1 : 0) != 0);
        ScannerTest.assertTrue((String)"First entry in myMap must have key='key1'", (boolean)"key1".equals(((ISeamValueMapEntry)es.get(0)).getKey().getValue().getValue()));
        ScannerTest.assertTrue((String)"First entry in myMap must have value='map value 1'", (boolean)"map value 1".equals(((ISeamValueMapEntry)es.get(0)).getValue().getValue().getValue()));
        ISeamComponentDeclaration resourceBundle = this.findDeclaration(cs, "org.jboss.seam.core.resourceBundle");
        ScannerTest.assertTrue((String)"Declaration of org.jboss.seam.core.resourceBundle is not found", (boolean)(resourceBundle instanceof ISeamXmlComponentDeclaration));
        property = ((ISeamXmlComponentDeclaration)resourceBundle).getProperty("bundleNames");
        ScannerTest.assertTrue((String)"Property 'bundleNames' is not found in declaration 'org.jboss.seam.core.resourceBundle'", (property != null ? 1 : 0) != 0);
        o = property.getValue();
        ScannerTest.assertTrue((String)"Property bundleNames in myComponent must be instanceof ISeamValueList", (boolean)(o instanceof ISeamValueList));
        oList = (ISeamValueList)o;
        ScannerTest.assertTrue((String)"Property bundleNames misses value 'bundleA'.", (boolean)"bundleA".equals(((ISeamValueString)oList.getValues().get(0)).getValue().getValue()));
        ScannerTest.assertTrue((String)"Property bundleNames misses value 'bundleB'.", (boolean)"bundleB".equals(((ISeamValueString)oList.getValues().get(1)).getValue().getValue()));
        ISeamFactory factory = this.find(fs, "factory1");
        ScannerTest.assertTrue((String)"Declared factory 'factory1' is not found in components.xml", (factory != null ? 1 : 0) != 0);
        ISeamXmlFactory af = (ISeamXmlFactory)factory;
        ScannerTest.assertTrue((String)"Scope of 'factory1' must be 'conversation'", (af.getScope() == ScopeType.CONVERSATION ? 1 : 0) != 0);
        int duplicatedCount = 0;
        int i = 0;
        while (i < cs.length) {
            if ("duplicated".equals(cs[i].getName())) {
                ++duplicatedCount;
            }
            ++i;
        }
        ScannerTest.assertEquals((String)"There are 2 declarations of component \"duplicated\" in xml.", (int)2, (int)duplicatedCount);
        ISeamComponentDeclaration c10 = this.findDeclaration(cs, "compWithPrecedence10");
        ScannerTest.assertNotNull((Object)c10);
        ScannerTest.assertEquals((String)"10", (String)((ISeamXmlComponentDeclaration)c10).getPrecedence());
        ISeamComponentDeclaration cDefault = this.findDeclaration(cs, "compWithDefaultPrecedence");
        ScannerTest.assertNotNull((Object)cDefault);
        ScannerTest.assertEquals((String)"20", (String)((ISeamXmlComponentDeclaration)cDefault).getPrecedence());
        ISeamComponentDeclaration c20 = this.findDeclaration(cs, "compWithPrecedence20");
        ScannerTest.assertNotNull((Object)c20);
        ScannerTest.assertEquals((String)"20", (String)((ISeamXmlComponentDeclaration)c20).getPrecedence());
    }

    private ISeamComponentDeclaration findDeclaration(ISeamComponentDeclaration[] declarations, String name) {
        int i = 0;
        while (i < declarations.length) {
            if (name.equals(declarations[i].getName())) {
                return declarations[i];
            }
            ++i;
        }
        return null;
    }

    public void testJavaScanner() {
        ISeamProject seamProject = this.getSeamProject();
        IFile f = this.project.getFile("JavaSource/demo/User.java");
        ScannerTest.assertTrue((String)"Cannot find User.java in test project", (f != null && f.exists() ? 1 : 0) != 0);
        IFileScanner scanner = SeamCoreBuilder.createJavaScanner();
        ScannerTest.assertTrue((String)"Scanner cannot recognise User.java", (boolean)scanner.isRelevant(f));
        ScannerTest.assertTrue((String)"Scanner cannot recognise User.java content", (boolean)scanner.isLikelyComponentSource(f));
        ISeamComponentDeclaration[] cs = null;
        ISeamFactory[] fs = null;
        try {
            LoadedDeclarations ds = scanner.parse(f, seamProject);
            cs = ds.getComponents().toArray(new ISeamComponentDeclaration[0]);
            fs = ds.getFactories().toArray(new ISeamFactory[0]);
        }
        catch (Exception e) {
            JUnitUtils.fail((String)"Error in java scanner", (Exception)e);
        }
        ScannerTest.assertTrue((String)"Components are not found in User.java", (cs != null && cs.length > 0 ? 1 : 0) != 0);
        ISeamJavaComponentDeclaration myUser = (ISeamJavaComponentDeclaration)this.findDeclaration(cs, "myUser");
        ScannerTest.assertTrue((String)"Component declaration myUser not found", (myUser != null ? 1 : 0) != 0);
        ISeamComponent c = seamProject.getComponent("myUser");
        ScannerTest.assertTrue((String)"Seam builder must put myUser to project.", (c != null ? 1 : 0) != 0);
        ScopeType scope = myUser.getScope();
        ScannerTest.assertTrue((String)("Declared scope for myUser is Application rather than " + scope.getLabel()), (scope == ScopeType.APPLICATION ? 1 : 0) != 0);
        int precedence = myUser.getPrecedence();
        ScannerTest.assertTrue((String)("Declared precedence for myUser is 10 rather than " + precedence), (precedence == 10 ? 1 : 0) != 0);
        boolean isEntity = myUser.isEntity();
        ScannerTest.assertTrue((String)"Java source for myUser is declared as entity", (boolean)isEntity);
        Set bijected = myUser.getBijectedAttributes();
        IBijectedAttribute a1 = this.findBijectedAttribute(bijected, "address");
        ScannerTest.assertTrue((String)"Attribute 'address' is not found in bijected attributes", (a1 != null ? 1 : 0) != 0);
        ScannerTest.assertTrue((String)"Attribute 'address' is @Out annotated", (boolean)a1.isOfType(BijectedAttributeType.OUT));
        IBijectedAttribute a2 = this.findBijectedAttribute(bijected, "payment");
        ScannerTest.assertTrue((String)"Attribute 'payment' is not found in bijected attributes", (a2 != null ? 1 : 0) != 0);
        ScannerTest.assertTrue((String)"Attribute 'payment' is @In annotated", (boolean)a2.isOfType(BijectedAttributeType.IN));
        Set methods = myUser.getMethods();
        ISeamComponentMethod m = this.find(methods, "unwrapMethod");
        ScannerTest.assertTrue((String)"Declared method 'unwrapMethod' is not found in 'myUser'", (m != null ? 1 : 0) != 0);
        ScannerTest.assertTrue((String)"Method 'unwrapMethod' in 'myUser' must be create method", (boolean)m.isOfType(SeamComponentMethodType.UNWRAP));
        m = this.find(methods, "createAndDestroyMethod");
        ScannerTest.assertTrue((String)"Declared method 'createAndDestroyMethod' is not found in 'myUser'", (m != null ? 1 : 0) != 0);
        ScannerTest.assertTrue((String)"Method 'createAndDestroyMethod' in 'myUser' must be create method", (boolean)m.isOfType(SeamComponentMethodType.CREATE));
        ScannerTest.assertTrue((String)"Method 'createAndDestroyMethod' in 'myUser' must be destroy method", (boolean)m.isOfType(SeamComponentMethodType.DESTROY));
        ISeamFactory myFactory = this.find(fs, "myFactory");
        ScannerTest.assertTrue((String)"Declared factory 'myFactory' is not found in 'myUser'", (myFactory != null ? 1 : 0) != 0);
        ISeamAnnotatedFactory af = (ISeamAnnotatedFactory)myFactory;
        ScannerTest.assertTrue((String)"Scope of 'myFactory' must be 'session'", (af.getScope() == ScopeType.SESSION ? 1 : 0) != 0);
        ISeamFactory myFactory2 = this.find(fs, "myFactory");
        ScannerTest.assertTrue((String)"Declared factory 'myFactory2' is not found in 'myUser'", (myFactory2 != null ? 1 : 0) != 0);
        ISeamAnnotatedFactory af2 = (ISeamAnnotatedFactory)myFactory2;
        ScannerTest.assertTrue((String)"Scope of 'myFactory' must be 'session'", (af2.getScope() == ScopeType.SESSION ? 1 : 0) != 0);
    }

    private IBijectedAttribute findBijectedAttribute(Set<IBijectedAttribute> bijected, String name) {
        for (IBijectedAttribute a : bijected) {
            if (!name.equals(a.getName())) continue;
            return a;
        }
        return null;
    }

    public void testLibraryScanner() {
        ISeamProject seamProject = this.getSeamProject();
        IFile f = this.project.getFile("WebContent/WEB-INF/lib/jboss-seam-1.2.1.GA.jar");
        ScannerTest.assertTrue((String)"Cannot find User.java in test project", (f != null && f.exists() ? 1 : 0) != 0);
        LibraryScanner scanner = (LibraryScanner)SeamCoreBuilder.createLibraryScanner();
        ClassPath cp = ((SeamProject)seamProject).getClassPath();
        scanner.setClassPath(cp);
        cp.update();
        ScannerTest.assertTrue((String)"Scanner cannot recognise jboss-seam.jar", (boolean)scanner.isRelevant(f));
        ScannerTest.assertTrue((String)"Scanner cannot recognise jboss-seam.jar content", (boolean)scanner.isLikelyComponentSource(f));
        ISeamFactory[] factories = null;
        ISeamJavaComponentDeclaration[] componentDeclarations = null;
        try {
            LoadedDeclarations ds = scanner.parse(f, seamProject);
            factories = ds.getFactories().toArray(new ISeamFactory[0]);
            componentDeclarations = ds.getComponents().toArray(new ISeamJavaComponentDeclaration[0]);
        }
        catch (Exception e) {
            JUnitUtils.fail((String)"Error in library scanner", (Exception)e);
        }
        ScannerTest.assertTrue((String)"Factories are not found in jboss-seam.jar", (factories != null && factories.length > 0 ? 1 : 0) != 0);
        ISeamXmlFactory actor = (ISeamXmlFactory)this.find(factories, "actor");
        ScannerTest.assertTrue((String)"Factory actor is not found in jboss-seam.jar", (actor != null ? 1 : 0) != 0);
        ScannerTest.assertTrue((String)"Factory actor loaded wrong value", (boolean)"#{org.jboss.seam.core.actor}".equals(actor.getValue()));
        try {
            this.project.build(6, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (Exception e) {
            JUnitUtils.fail((String)"Cannot build", (Exception)e);
        }
        Set components = seamProject.getFactoriesByName("actor");
        ScannerTest.assertTrue((String)"Seam builder must put actor to project.", (components.size() == 1 ? 1 : 0) != 0);
        ISeamJavaComponentDeclaration d = (ISeamJavaComponentDeclaration)this.findDeclaration((ISeamComponentDeclaration[])componentDeclarations, "org.jboss.seam.core.dispatcher");
        ScannerTest.assertTrue((String)"Java declaration 'org.jboss.seam.core.dispatcher' is not found", (d != null ? 1 : 0) != 0);
        ScannerTest.assertTrue((String)"Java declaration 'org.jboss.seam.core.dispatcher' must be stateless", (boolean)d.isOfType(BeanType.STATELESS));
        ScannerTest.assertTrue((String)"Java declaration 'org.jboss.seam.core.dispatcher' must have precedence 0", (d.getPrecedence() == 0 ? 1 : 0) != 0);
        d = (ISeamJavaComponentDeclaration)this.findDeclaration((ISeamComponentDeclaration[])componentDeclarations, "org.jboss.seam.core.ejb");
        ScannerTest.assertTrue((String)"Java declaration 'org.jboss.seam.core.ejb' is not found", (d != null ? 1 : 0) != 0);
        ScannerTest.assertTrue((String)"Java declaration 'org.jboss.seam.core.dispatcher' must have precedence 0", (d.getPrecedence() == 0 ? 1 : 0) != 0);
        Set methods = d.getMethods();
        ISeamComponentMethod m = this.find(methods, "startup");
        ScannerTest.assertTrue((String)"Declared method 'startup' is not found in 'org.jboss.seam.core.ejb'", (m != null ? 1 : 0) != 0);
        ScannerTest.assertTrue((String)"Method 'startup' in 'org.jboss.seam.core.ejb' must be create method", (boolean)m.isOfType(SeamComponentMethodType.CREATE));
        m = this.find(methods, "shutdown");
        ScannerTest.assertTrue((String)"Declared method 'shutdown' is not found in 'org.jboss.seam.core.ejb'", (m != null ? 1 : 0) != 0);
        ScannerTest.assertTrue((String)"Method 'shutdown' in 'org.jboss.seam.core.ejb' must be destroy method", (boolean)m.isOfType(SeamComponentMethodType.DESTROY));
        d = (ISeamJavaComponentDeclaration)this.findDeclaration((ISeamComponentDeclaration[])componentDeclarations, "org.jboss.seam.core.eventContext");
        ScannerTest.assertTrue((String)"Java declaration 'org.jboss.seam.core.eventContext' is not found", (d != null ? 1 : 0) != 0);
        methods = d.getMethods();
        m = this.find(methods, "getContext");
        ScannerTest.assertTrue((String)"Declared method 'getContext' is not found in 'org.jboss.seam.core.eventContext'", (m != null ? 1 : 0) != 0);
        ScannerTest.assertTrue((String)"Method 'getContext' in 'org.jboss.seam.core.eventContext' must be unwrap method", (boolean)m.isOfType(SeamComponentMethodType.UNWRAP));
    }

    private ISeamComponentMethod find(Set<ISeamComponentMethod> methods, String name) {
        for (ISeamComponentMethod m : methods) {
            if (!name.equals(m.getSourceMember().getElementName())) continue;
            return m;
        }
        return null;
    }

    private ISeamFactory find(ISeamFactory[] factories, String name) {
        int i = 0;
        while (i < factories.length) {
            if (name.equals(factories[i].getName())) {
                return factories[i];
            }
            ++i;
        }
        return null;
    }

    public void testSeamProjectObjects() {
        ISeamProject seamProject = this.getSeamProject();
        ISeamComponent c = seamProject.getComponent("myPersistenceContext1");
        ScannerTest.assertNotNull((String)"Component myPersistenceContext1 not found.", (Object)c);
        ScopeType scope = c.getScope();
        ScannerTest.assertTrue((String)("Component myPersistenceContext1 has scope=" + (scope == null ? null : scope.getLabel()) + ", but has to have " + ScopeType.CONVERSATION.getLabel()), (ScopeType.CONVERSATION == scope ? 1 : 0) != 0);
        c = seamProject.getComponent("org.jboss.seam.core.resourceBundle");
        ScannerTest.assertNotNull((String)"Component org.jboss.seam.core.resourceBundle not found.", (Object)c);
        String className = c.getClassName();
        ScannerTest.assertTrue((String)("Class name of org.jboss.seam.core.resourceBundle must be org.jboss.seam.core.ResourceBundle  rather than " + className), (boolean)"org.jboss.seam.core.ResourceBundle".equals(className));
        List bundleNamesPropertyList = c.getProperties("bundleNames");
        ScannerTest.assertTrue((String)"Property bundleNames is not found", (bundleNamesPropertyList != null && bundleNamesPropertyList.size() == 1 ? 1 : 0) != 0);
        ISeamProperty bundleNamesProperty = (ISeamProperty)bundleNamesPropertyList.get(0);
        ScannerTest.assertTrue((String)"Value of bundleNames must be instanceof ISeamValueList", (boolean)(bundleNamesProperty.getValue() instanceof ISeamValueList));
        ISeamValueList bundleNames = (ISeamValueList)bundleNamesProperty.getValue();
        List valueList = bundleNames.getValues();
        ScannerTest.assertTrue((String)("There must be 2 bundle names rather than " + valueList.size()), (valueList.size() == 2 ? 1 : 0) != 0);
        ScannerTest.assertTrue((String)("First bundle name is " + ((ISeamValueString)valueList.get(0)).getValue().getValue() + " rather than bundleA"), (boolean)"bundleA".equals(((ISeamValueString)valueList.get(0)).getValue().getValue()));
        ScannerTest.assertTrue((String)("Second bundle name is " + ((ISeamValueString)valueList.get(1)).getValue().getValue() + " rather than bundleB"), (boolean)"bundleB".equals(((ISeamValueString)valueList.get(1)).getValue().getValue()));
        String[][] managerTestProperties = new String[][]{{"conversationIsLongRunningParameter", "a"}, {"parentConversationIdParameter", "b"}, {"conversationIdParameter", "c"}, {"concurrentRequestTimeout", "2"}, {"conversationTimeout", "3"}};
        this.scanSimpleProperties(seamProject, "org.jboss.seam.core.manager", managerTestProperties);
        String[][] microcontainerTestProperties = new String[][]{{"persistenceUnitName", "MyPersistenceUnit"}};
        this.scanSimpleProperties(seamProject, "org.jboss.seam.core.microcontainer", microcontainerTestProperties);
        ISeamComponent myUser = seamProject.getComponent("myUser");
        ScannerTest.assertNotNull((Object)myUser);
        Set xml = myUser.getXmlDeclarations();
        ScannerTest.assertEquals((int)1, (int)xml.size());
        ISeamComponent xyz = seamProject.getComponent("xyz");
        ScannerTest.assertNotNull((Object)xyz);
    }

    private void scanSimpleProperties(ISeamProject seamProject, String componentName, String[][] testProperties) {
        ISeamComponent c = seamProject.getComponent(componentName);
        ScannerTest.assertNotNull((String)("Component " + componentName + " not found."), (Object)c);
        int p = 0;
        while (p < testProperties.length) {
            String propertyName = testProperties[p][0];
            String expectedValue = testProperties[p][1];
            List ps = c.getProperties(propertyName);
            ScannerTest.assertTrue((String)("Property " + propertyName + " is not found"), (ps != null && ps.size() == 1 ? 1 : 0) != 0);
            ISeamProperty property = (ISeamProperty)ps.get(0);
            ISeamValueString valueObject = (ISeamValueString)property.getValue();
            String actualValue = valueObject.getValue().getValue();
            ScannerTest.assertTrue((String)("Property " + propertyName + " has value " + actualValue + " rather than " + expectedValue), (boolean)expectedValue.equals(actualValue));
            ++p;
        }
    }

    public void testInnerClass_JBIDE_1374() {
        ISeamProject seamProject = this.getSeamProject();
        ISeamComponent c = seamProject.getComponent("inner_JBIDE_1374");
        ScannerTest.assertTrue((String)"Component inner_JBIDE_1374 declared in inner static class is not found.", (c != null ? 1 : 0) != 0);
    }

    public void testInnerClassInAnnotationType_JBIDE_4144() {
        ISeamProject seamProject = this.getSeamProject();
        ISeamComponent c = seamProject.getComponent("inner_JBIDE_4144");
        ScannerTest.assertTrue((String)"Component inner_JBIDE_4144 declared in inner static class inside an annotation type is not found.", (c != null ? 1 : 0) != 0);
    }

    public void testInstallWithoutPrecedence_JBIDE_2052() {
        ISeamProject seamProject = this.getSeamProject();
        ISeamComponent c = seamProject.getComponent("installWithoutPrecedence_JBIDE_2052");
        ScannerTest.assertNotNull((String)"Component installWithoutPrecedence_JBIDE_2052 declared in class annotated with @Install(false) is not found.", (Object)c);
    }

    public void testLocation_JBIDE_2080() {
        String EJB = "org.jboss.seam.core.ejb";
        ISeamProject seamProject = this.getSeamProject();
        ISeamComponent c = seamProject.getComponent(EJB);
        ScannerTest.assertNotNull((String)("Component " + EJB + " is not found."), (Object)c);
        Set ds = c.getAllDeclarations();
        ISeamXmlComponentDeclaration xml = null;
        for (ISeamComponentDeclaration d : ds) {
            if (!(d instanceof ISeamXmlComponentDeclaration)) continue;
            xml = (ISeamXmlComponentDeclaration)d;
            break;
        }
        String MY_COMPONENT = "myComponent";
        ScannerTest.assertNotNull((String)("XML declaration for component " + MY_COMPONENT + " is not found in components.xml."), (Object)xml);
        ITextSourceReference location = xml.getLocationFor("name");
        ScannerTest.assertNotNull((String)("Location of declaration of component " + MY_COMPONENT + " in components.xml is not found."), (Object)location);
        ScannerTest.assertTrue((String)"Location should not point to 0", (location.getStartPosition() > 0 && location.getLength() > 0 ? 1 : 0) != 0);
    }

    public void _testImportAnnotatation() throws Exception {
        ISeamProject seamProject = this.getSeamProject();
        ISeamComponent c = seamProject.getComponent("animals.all");
        ISeamJavaComponentDeclaration d = c.getJavaDeclaration();
        Set vs = d.getVariablesByName("Hare");
        ScannerTest.assertTrue((String)"Cannot find Hare among all animals, import 'animal.wild' is ignored", (vs != null && !vs.isEmpty() ? 1 : 0) != 0);
        vs = d.getVariablesByName("Rabbit");
        ScannerTest.assertTrue((String)"Cannot find Rabbit among all animals, import 'animal.tame' is ignored", (vs != null && !vs.isEmpty() ? 1 : 0) != 0);
        c = seamProject.getComponent("animals.wild");
        d = c.getJavaDeclaration();
        vs = d.getVariablesByName("Hare");
        ScannerTest.assertTrue((String)"Cannot find Hare among wild animals, import 'animal.wild' is ignored", (vs != null && !vs.isEmpty() ? 1 : 0) != 0);
        vs = d.getVariablesByName("Rabbit");
        ScannerTest.assertFalse((String)"Foundd Rabbit among wild animals, import 'animal.tame' is illegally added", (vs != null && !vs.isEmpty() ? 1 : 0) != 0);
    }

    protected void tearDown() throws Exception {
        if (this.provider != null) {
            this.provider.dispose();
        }
    }
}

