/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.seam.core.test;

import junit.framework.Test;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.validation.internal.core.ValidationException;
import org.jboss.tools.seam.core.test.validation.SeamCoreValidatorWrapper;
import org.jboss.tools.seam.internal.core.validation.SeamValidationMessages;
import org.jboss.tools.test.util.ProjectImportTestSetup;
import org.jboss.tools.tests.AbstractResourceMarkerTest;

public class Seam2ValidatorTest
extends AbstractResourceMarkerTest {
    IProject projectEAR = null;
    IProject projectWAR = null;
    IProject projectEJB = null;
    ProjectImportTestSetup setup;

    protected void setUp() throws Exception {
        this.setup = new ProjectImportTestSetup((Test)this, "org.jboss.tools.seam.base.test", new String[]{"projects/Test1-ejb", "projects/Test1-ear", "projects/Test1"}, new String[]{"Test1-ejb", "Test1-ear", "Test1"});
        IProject[] projects = this.setup.importProjects();
        this.projectEJB = projects[0];
        this.projectEAR = projects[1];
        this.projectWAR = projects[2];
        this.projectEAR.build(6, null);
        this.projectEJB.build(6, null);
        this.projectWAR.build(6, null);
        this.setProject(this.projectEJB);
    }

    public void testDuplicateName() throws CoreException, ValidationException {
        IFile componentFile = this.projectEJB.getFile("ejbModule/org/domain/Test1/session/TestDuplicateNameOk.java");
        IFile componentsXml = this.projectWAR.getFile("WebContent/WEB-INF/components.xml");
        SeamCoreValidatorWrapper seamValidator = new SeamCoreValidatorWrapper(this.projectWAR);
        seamValidator.validate(componentFile);
        seamValidator.validate(componentsXml);
        Seam2ValidatorTest.assertFalse((String)"Validation problem was found", (boolean)seamValidator.isMessageCreated(SeamValidationMessages.NONUNIQUE_COMPONENT_NAME_MESSAGE, new Object[]{"org.jboss.seam.security.identity"}));
    }

    protected void tearDown() throws Exception {
        this.setup.deleteProjects();
    }
}

