/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.seam.core.test;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import junit.framework.TestCase;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.jboss.tools.common.util.FileUtil;
import org.jboss.tools.seam.core.ISeamComponent;
import org.jboss.tools.seam.core.ISeamProject;
import org.jboss.tools.seam.core.test.SeamBigProjectGenerator;
import org.jboss.tools.seam.internal.core.SeamProject;
import org.jboss.tools.test.util.JUnitUtils;
import org.jboss.tools.test.util.JobUtils;
import org.jboss.tools.test.util.ResourcesUtils;
import org.jboss.tools.test.util.TestProjectProvider;
import org.osgi.framework.Bundle;

public class SeamBigProjectTest
extends TestCase {
    static String BUNDLE = "org.jboss.tools.seam.base.test";
    IProject project;
    TestProjectProvider provider;

    protected void setUp() throws Exception {
        this.provider = new TestProjectProvider(BUNDLE, "/projects/bigProject", "bigProject", true);
        this.project = this.provider.getProject();
        IFolder folder = this.project.getFolder((IPath)new Path("src/action/p"));
        InputStream template = this.getTemplateFile();
        boolean saveAutoBuild = ResourcesUtils.setBuildAutomatically((boolean)false);
        SeamBigProjectGenerator g = new SeamBigProjectGenerator();
        g.generate((IResource)folder, template);
        this.project.build(15, (IProgressMonitor)new NullProgressMonitor());
        this.project.build(6, (IProgressMonitor)new NullProgressMonitor());
        ResourcesUtils.setBuildAutomatically((boolean)saveAutoBuild);
    }

    private InputStream getTemplateFile() {
        String entry = "/projects/template.txt";
        Bundle bundle = Platform.getBundle((String)BUNDLE);
        URL url = null;
        try {
            url = FileLocator.resolve((URL)bundle.getEntry(entry));
        }
        catch (IOException iOException) {
            return null;
        }
        try {
            return url.openStream();
        }
        catch (IOException iOException) {
            SeamBigProjectTest.fail((String)("Cannot find entry " + entry + " in " + BUNDLE));
            return null;
        }
    }

    public void testBigProject() throws IOException {
        ISeamProject sp = this.getSeamProject();
        ISeamComponent[] cs = sp.getComponents();
        int components = cs.length;
        if (components < 500) {
            SeamBigProjectTest.fail((String)("Found only " + components + " components. Must be more than 500."));
        }
        SeamProject impl = (SeamProject)sp;
        System.out.println("Full build of " + components + " components completed in " + impl.fullBuildTime + "ms");
        impl.store();
        long time = impl.reload();
        System.out.println("Reloaded " + sp.getComponents().length + " components in " + time + "ms");
        List statistics = impl.statistics;
        impl.statistics = null;
        SeamBigProjectTest.assertTrue((String)"Statistics contains less than 500 items", (statistics.size() >= 500 ? 1 : 0) != 0);
        long t1 = 0L;
        long t2 = 0L;
        int i = 0;
        while (i < 200) {
            t1 += ((Long)statistics.get(i)).longValue();
            t2 += ((Long)statistics.get(statistics.size() - 1 - i)).longValue();
            ++i;
        }
        System.out.println("First 200 paths are loaded in " + t1 + "ms");
        System.out.println("Last 200 paths are loaded in " + t2 + "ms");
        double d = 1.0 * (double)t2 / (double)t1;
        if (d > 5.0) {
            SeamBigProjectTest.fail((String)("It takes " + d + " times longer to load path in the end " + "of seam model loading than in the beginning.\n" + "That implies that time depends as N*N on the number of components N."));
        }
        this.generateLongXHTML(cs);
    }

    private ISeamProject getSeamProject() {
        ISeamProject seamProject = null;
        try {
            seamProject = (ISeamProject)this.project.getNature("org.jboss.tools.seam.core.seamnature");
        }
        catch (Exception e) {
            JUnitUtils.fail((String)"Cannot get seam nature.", (Exception)e);
        }
        SeamBigProjectTest.assertNotNull((String)"Seam project is null", (Object)seamProject);
        return seamProject;
    }

    protected void tearDown() throws Exception {
        ISeamProject sp = this.getSeamProject();
        SeamProject impl = (SeamProject)sp;
        if (impl != null) {
            impl.clearStorage();
        }
        this.provider.dispose();
    }

    private void generateLongXHTML(ISeamComponent[] cs) {
        StringBuffer sb = new StringBuffer();
        IFolder webContent = this.project.getFolder("WebContent");
        IFile tmpl = webContent.getFile("login.xhtml");
        String s = FileUtil.readFile((File)tmpl.getLocation().toFile());
        int i = s.indexOf("<h:form");
        int j = s.indexOf(">", i) + 1;
        sb.append(s.substring(0, j));
        int k = 0;
        ISeamComponent[] iSeamComponentArray = cs;
        int n = cs.length;
        int n2 = 0;
        while (n2 < n) {
            ISeamComponent c = iSeamComponentArray[n2];
            ++k;
            String n3 = c.getName();
            if (n3.startsWith("x")) {
                String q = "\n<h:inputText id=\"k" + k + "\" " + "value=\"#{" + n3 + ".value}\"/>\n";
                sb.append(q);
            }
            ++n2;
        }
        sb.append(s.substring(j));
        IFile file = webContent.getFile("long.xhtml");
        try {
            file.create((InputStream)new ByteArrayInputStream(sb.toString().getBytes()), true, (IProgressMonitor)new NullProgressMonitor());
            long time = System.currentTimeMillis();
            JobUtils.waitForIdle();
            long dt = System.currentTimeMillis() - time;
            System.out.println("validated in " + dt);
            SeamBigProjectTest.assertTrue((String)("Validator takes more than 5s (" + (double)(dt - 500L) / 1000.0 + ") for validating generated long.xhtml"), ((double)(dt - 500L) / 1000.0 < 5.0 ? 1 : 0) != 0);
        }
        catch (CoreException e) {
            JUnitUtils.fail((String)"", (Exception)((Object)e));
        }
    }
}

