/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.seam.core.test;

import junit.framework.TestCase;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IRuntimeType;
import org.eclipse.wst.server.core.IRuntimeWorkingCopy;
import org.eclipse.wst.server.core.ServerUtil;
import org.eclipse.wst.server.core.internal.RuntimeWorkingCopy;
import org.jboss.tools.seam.core.ISeamComponent;
import org.jboss.tools.seam.core.ISeamProject;
import org.jboss.tools.seam.core.SeamCorePlugin;

public class SeamEARTest
extends TestCase {
    IProject projectEAR = null;
    IProject projectWAR = null;
    IProject projectEJB = null;
    boolean makeCopy = true;

    protected void setUp() throws Exception {
        this.projectEAR = ResourcesPlugin.getWorkspace().getRoot().getProject("Test1-ear");
        SeamEARTest.assertTrue((boolean)this.projectEAR.exists());
        this.projectEJB = ResourcesPlugin.getWorkspace().getRoot().getProject("Test1-ejb");
        SeamEARTest.assertTrue((boolean)this.projectEJB.exists());
        this.projectWAR = ResourcesPlugin.getWorkspace().getRoot().getProject("Test1");
        SeamEARTest.assertTrue((boolean)this.projectWAR.exists());
        this.projectEAR.build(6, (IProgressMonitor)new NullProgressMonitor());
        this.projectEJB.build(6, (IProgressMonitor)new NullProgressMonitor());
        this.projectWAR.build(6, (IProgressMonitor)new NullProgressMonitor());
    }

    private ISeamProject getSeamProject(IProject project) throws CoreException {
        ISeamProject seamProject = null;
        seamProject = SeamCorePlugin.getSeamProject((IProject)project, (boolean)true);
        SeamEARTest.assertNotNull((String)"Seam project is null", (Object)seamProject);
        return seamProject;
    }

    public void testEarProject() throws CoreException {
        ISeamProject seamProject = this.getSeamProject(this.projectWAR);
        ISeamComponent c = seamProject.getComponent("authenticator");
        SeamEARTest.assertNotNull((String)"War project must see component 'authenticator' declared in ejb project", (Object)c);
    }

    public void testCleanEarProject() throws CoreException {
        ISeamProject seamProject = this.getSeamProject(this.projectWAR);
        ISeamComponent c = seamProject.getComponent("authenticator");
        SeamEARTest.assertNotNull((String)"War project must see component 'authenticator' declared in ejb project", (Object)c);
        this.projectWAR.build(15, (IProgressMonitor)new NullProgressMonitor());
        c = seamProject.getComponent("authenticator");
        SeamEARTest.assertNull((String)"War project must see component 'authenticator' declared in ejb project", (Object)c);
        this.projectWAR.build(6, (IProgressMonitor)new NullProgressMonitor());
        c = seamProject.getComponent("authenticator");
        SeamEARTest.assertNotNull((String)"War project must see component 'authenticator' declared in ejb project", (Object)c);
    }

    static IRuntime createRuntime(String runtimeName) throws CoreException {
        IRuntimeWorkingCopy runtime = null;
        Path jbossAsLocationPath = new Path(System.getProperty("jbosstools.test.jboss.home.4.2", "C:/jbdevstudio/jboss-eap/jboss-as"));
        IRuntimeType[] runtimeTypes = ServerUtil.getRuntimeTypes(null, null, (String)"org.jboss.ide.eclipse.as.runtime.42");
        if (runtimeTypes.length > 0) {
            runtime = runtimeTypes[0].createRuntime(null, (IProgressMonitor)new NullProgressMonitor());
            runtime.setLocation((IPath)jbossAsLocationPath);
            if (runtimeName != null) {
                runtime.setName(runtimeName);
            }
            IVMInstall defaultVM = JavaRuntime.getDefaultVMInstall();
            ((RuntimeWorkingCopy)runtime).setAttribute("PROPERTY_VM_ID", defaultVM.getId());
            ((RuntimeWorkingCopy)runtime).setAttribute("PROPERTY_VM_TYPE_ID", defaultVM.getVMInstallType().getId());
            ((RuntimeWorkingCopy)runtime).setAttribute("org.jboss.ide.eclipse.as.core.runtime.configurationName", "default");
            return runtime.save(false, (IProgressMonitor)new NullProgressMonitor());
        }
        return runtime;
    }
}

