/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.seam.core.test;

import junit.framework.TestCase;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.jboss.tools.seam.core.SeamCoreBuilder;
import org.jboss.tools.seam.core.SeamCorePlugin;
import org.jboss.tools.seam.internal.core.SeamProject;
import org.jboss.tools.test.util.JobUtils;
import org.jboss.tools.test.util.TestProjectProvider;

public class SeamModelStorageTest
extends TestCase {
    IProject project = null;
    TestProjectProvider provider = null;
    boolean makeCopy = true;

    public SeamModelStorageTest() {
        super("Seam Model Storage Test");
    }

    public void setUp() throws Exception {
        this.project = ResourcesPlugin.getWorkspace().getRoot().getProject("TestStorage");
        SeamModelStorageTest.assertNotNull((String)"Can't load TestStorage", (Object)this.project);
        if (!this.project.exists()) {
            this.provider = new TestProjectProvider("org.jboss.tools.seam.base.test", null, "TestScanner", true);
            this.project = this.provider.getProject();
        }
        this.project.build(6, null);
    }

    public void testStorage() throws Exception {
        SeamProject seam = (SeamProject)SeamCorePlugin.getSeamProject((IProject)this.project, (boolean)true);
        SeamModelStorageTest.assertNotNull((Object)seam);
        int mod = seam.getModificationsSinceLastStore();
        System.out.println("-->" + mod);
        SeamModelStorageTest.assertTrue((String)"Modification index after load must be greater than 0", (mod > 0 ? 1 : 0) != 0);
        seam.store();
        mod = seam.getModificationsSinceLastStore();
        System.out.println("-->" + mod);
        SeamModelStorageTest.assertEquals((String)"Modification index after store must be cleared", (int)0, (int)mod);
        SeamProject seamProject = (SeamProject)SeamCorePlugin.getSeamProject((IProject)this.project, (boolean)true);
        seamProject.setStoreDisabledForTesting(true);
        try {
            IFile fromFile = this.project.getFile((IPath)new Path("lib/jboss-seam-1.2.1.GA.jar"));
            IFolder lib = this.project.getFolder((IPath)new Path("WebContent/WEB-INF/lib"));
            if (!lib.exists()) {
                lib.create(true, true, null);
            }
            IFile toFile = this.project.getFile((IPath)new Path("WebContent/WEB-INF/lib/jboss-seam.jar"));
            toFile.create(fromFile.getContents(), true, (IProgressMonitor)new NullProgressMonitor());
            this.project.build(10, (IProgressMonitor)new NullProgressMonitor());
            System.out.println("-->" + mod);
            this.project.build(6, SeamCoreBuilder.BUILDER_ID, null, (IProgressMonitor)new NullProgressMonitor());
            JobUtils.waitForIdle();
            mod = seam.getModificationsSinceLastStore();
            System.out.println("-->" + mod);
            SeamModelStorageTest.assertTrue((String)"Modification index after adding new library must be greater than 0", (mod > 0 ? 1 : 0) != 0);
        }
        finally {
            seamProject.setStoreDisabledForTesting(false);
        }
    }

    protected void tearDown() throws Exception {
        if (this.provider != null) {
            this.provider.dispose();
        }
    }
}

