/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.seam.core.test;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.wst.validation.internal.core.ValidationException;
import org.jboss.tools.seam.core.SeamCorePlugin;
import org.jboss.tools.seam.core.test.validation.SeamProjectPropertyValidatorWrapper;
import org.jboss.tools.seam.internal.core.validation.SeamValidationMessages;
import org.jboss.tools.test.util.JobUtils;
import org.jboss.tools.test.util.ProjectImportTestSetup;
import org.jboss.tools.tests.AbstractResourceMarkerTest;

public class SeamProjectPropertyValidatorTest
extends AbstractResourceMarkerTest {
    IProject warProject;
    IProject ejbProject;
    IProject testProject;

    public SeamProjectPropertyValidatorTest() {
        super("Seam Project Property Validator Tests");
    }

    protected void setUp() throws Exception {
        if (this.warProject == null) {
            this.warProject = ProjectImportTestSetup.loadProject((String)"RefactoringTestProject-war");
            this.ejbProject = ProjectImportTestSetup.loadProject((String)"RefactoringTestProject-ejb");
            this.testProject = ProjectImportTestSetup.loadProject((String)"RefactoringTestProject-test");
            IEclipsePreferences pref = SeamCorePlugin.getSeamPreferences((IProject)this.ejbProject);
            pref.put("seam.parent.project", "invalidParentProjectName");
            pref.flush();
            pref = SeamCorePlugin.getSeamPreferences((IProject)this.testProject);
            pref.put("seam.parent.project", "invalidParentProjectName");
            pref.flush();
            pref = SeamCorePlugin.getSeamPreferences((IProject)this.warProject);
            pref.put("seam.runtime.name", "invalidRuntimeName");
            pref.put("seam.ejb.project", "invalidEjbProjectName");
            pref.put("seam.project.web.root.folder", "invalidWebFolderPath");
            pref.put("model.sources", "invalidModelSrcFolderPath");
            pref.put("model.package", "invalid model package name");
            pref.put("action.sources", "invalidSessionBeanSrcFolderPath");
            pref.put("action.package", "invalid session bean package name");
            pref.put("seam.test.project", "invalidTestProjectName");
            pref.put("test.sources", "invalidTestSrcFolderPath");
            pref.put("test.package", "invalid test package name");
            pref.flush();
            this.ejbProject.build(6, null);
            this.warProject.build(6, null);
            this.testProject.build(6, null);
            JobUtils.waitForIdle((long)2000L);
        }
    }

    protected void assertMarkerIsCreated(IProject project, String template, Object[] parameters) throws CoreException, ValidationException {
        SeamProjectPropertyValidatorWrapper validator = new SeamProjectPropertyValidatorWrapper(project);
        validator.validate();
        SeamProjectPropertyValidatorTest.assertTrue((String)"Error marker not found", (boolean)validator.isMessageCreated(template, parameters));
    }

    public void testProjectNameValidation() throws CoreException, ValidationException {
        this.assertMarkerIsCreated(this.ejbProject, SeamValidationMessages.INVALID_PARENT_PROJECT, new Object[]{"invalidParentProjectName", "RefactoringTestProject-ejb"});
        this.assertMarkerIsCreated(this.warProject, SeamValidationMessages.INVALID_EJB_PROJECT, new Object[]{"invalidEjbProjectName", "RefactoringTestProject-war"});
        this.assertMarkerIsCreated(this.warProject, SeamValidationMessages.INVALID_TEST_PROJECT, new Object[]{"invalidTestProjectName", "RefactoringTestProject-war"});
    }

    public void testFolderNameValidation() throws CoreException, ValidationException {
        this.assertMarkerIsCreated(this.warProject, SeamValidationMessages.INVALID_WEBFOLDER, new Object[]{"invalidWebFolderPath", "RefactoringTestProject-war"});
        this.assertMarkerIsCreated(this.warProject, SeamValidationMessages.INVALID_MODEL_SRC, new Object[]{"invalidModelSrcFolderPath", "RefactoringTestProject-war"});
        this.assertMarkerIsCreated(this.warProject, SeamValidationMessages.INVALID_ACTION_SRC, new Object[]{"invalidSessionBeanSrcFolderPath", "RefactoringTestProject-war"});
        this.assertMarkerIsCreated(this.warProject, SeamValidationMessages.INVALID_TEST_SRC, new Object[]{"invalidTestSrcFolderPath", "RefactoringTestProject-war"});
    }

    public void testPackageNameValidation() throws CoreException, ValidationException {
        this.assertMarkerIsCreated(this.warProject, SeamValidationMessages.INVALID_MODEL_PACKAGE_NAME, new Object[]{"invalid model package name", "RefactoringTestProject-war"});
        this.assertMarkerIsCreated(this.warProject, SeamValidationMessages.INVALID_ACTION_PACKAGE_NAME, new Object[]{"invalid session bean package name", "RefactoringTestProject-war"});
        this.assertMarkerIsCreated(this.warProject, SeamValidationMessages.INVALID_TEST_PACKAGE_NAME, new Object[]{"invalid test package name", "RefactoringTestProject-war"});
    }

    public void testRuntimeNameValidation() throws CoreException, ValidationException {
        this.assertMarkerIsCreated(this.warProject, SeamValidationMessages.INVALID_SEAM_RUNTIME, new Object[]{"invalidRuntimeName", "RefactoringTestProject-war"});
    }
}

