/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.seam.core.test;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.preference.IPersistentPreferenceStore;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.wst.validation.internal.core.ValidationException;
import org.jboss.tools.common.base.test.validation.TestUtil;
import org.jboss.tools.jst.web.kb.WebKbPlugin;
import org.jboss.tools.jst.web.kb.internal.validation.ELValidationMessages;
import org.jboss.tools.jst.web.kb.preferences.ELSeverityPreferences;
import org.jboss.tools.seam.core.ISeamComponent;
import org.jboss.tools.seam.core.ISeamProject;
import org.jboss.tools.seam.core.SeamComponentMethodType;
import org.jboss.tools.seam.core.SeamCorePlugin;
import org.jboss.tools.seam.core.SeamPreferences;
import org.jboss.tools.seam.core.test.validation.ELValidatorWrapper;
import org.jboss.tools.seam.core.test.validation.IValidatorSupport;
import org.jboss.tools.seam.core.test.validation.SeamCoreValidatorWrapper;
import org.jboss.tools.seam.internal.core.validation.SeamValidationMessages;
import org.jboss.tools.test.util.JobUtils;
import org.jboss.tools.tests.AbstractResourceMarkerTest;
import org.jboss.tools.tests.IMarkerFilter;

public class SeamValidatorsTest
extends AbstractResourceMarkerTest {
    public static SeamMarkerFilter SEAM_MARKER_FILTER = new SeamMarkerFilter();
    final String TARGET_FILE_NAME = "src/action/org/domain/SeamWebWarTestProject/session/StatefulComponent.java";

    public SeamValidatorsTest() {
        super("Seam Validator Tests");
    }

    public SeamValidatorsTest(String name) {
        super(name);
    }

    protected void copyContentsFile(IFile originalFile, IFile newContentFile) throws CoreException {
        SeamValidatorsTest.assertTrue((boolean)originalFile.exists());
        SeamValidatorsTest.assertTrue((boolean)newContentFile.exists());
        super.copyContentsFile(originalFile, newContentFile);
        if ("xml".equalsIgnoreCase(originalFile.getFileExtension())) {
            originalFile.setLocalTimeStamp(originalFile.getModificationStamp() + 3000L);
        }
        this.project.build(10, null);
        this.project.build(6, (IProgressMonitor)new NullProgressMonitor());
    }

    protected void setUp() throws Exception {
        this.project = ResourcesPlugin.getWorkspace().getRoot().getProject("SeamWebWarTestProject");
        SeamValidatorsTest.assertTrue((boolean)this.project.exists());
    }

    protected void tearDown() throws Exception {
    }

    private ISeamProject getSeamProject(IProject project) throws CoreException {
        ISeamProject seamProject = (ISeamProject)project.getNature("org.jboss.tools.seam.core.seamnature");
        SeamValidatorsTest.assertNotNull((String)"Seam project is null", (Object)seamProject);
        return seamProject;
    }

    public void testFactory() throws CoreException, ValidationException {
        IFile componentFile = this.project.getFile("src/action/org/domain/SeamWebWarTestProject/session/FactoryTest.java");
        this.copyContentsFile(componentFile, "src/action/org/domain/SeamWebWarTestProject/session/FactoryTest.new");
        SeamCoreValidatorWrapper seamValidator = new SeamCoreValidatorWrapper(this.project);
        seamValidator.validate(componentFile);
        SeamValidatorsTest.assertTrue((String)"Error marker not found", (boolean)seamValidator.isMessageCreated(SeamValidationMessages.UNKNOWN_FACTORY_NAME, new String[]{"somethings"}));
        this.copyContentsFile(componentFile, "src/action/org/domain/SeamWebWarTestProject/session/FactoryTest.original");
    }

    public void testJavaFileOutsideClassPath() throws CoreException {
        IFile file = this.project.getFile("WebContent/Authenticator.java");
        String[] messages = SeamValidatorsTest.getMarkersMessage((IResource)file, (IMarkerFilter)SEAM_MARKER_FILTER);
        SeamValidatorsTest.assertTrue((String)"Problem marker was found in WebContent/Authenticator.java file. Seam EL validator should not validate it.", (messages.length == 0 ? 1 : 0) != 0);
    }

    public void testJBIDE1318() throws CoreException {
        this.getSeamProject(this.project);
        IFile testJSP = this.project.getFile("WebContent/test.jsp");
        this.project.build(10, null);
        SeamValidatorsTest.assertMarkerIsNotCreated((IResource)testJSP, (String)"org.eclipse.wst.validation.problemmarker", (String)"actor cannot be resolved");
    }

    public void testVarAttributes() throws CoreException, ValidationException {
        IFile file = this.project.getFile("WebContent/varAttributes.xhtml");
        TestUtil.validate((IResource)file);
        String messagePattern = MessageFormat.format(ELValidationMessages.UNKNOWN_EL_VARIABLE_PROPERTY_NAME, "nonExistingBroken");
        List<IMarker> markers = this.getMarkersByGroupName((IResource)file, "markedSeamProject");
        StringBuffer sb = new StringBuffer("Here is a list of found markers in ").append(file.getFullPath().toOSString()).append(markers.size() == 0 ? " : [" : " : [\r\n");
        int i = 0;
        for (IMarker marker : markers) {
            String message = marker.getAttribute("message", "");
            marker.getAttribute("message", "");
            int line = marker.getAttribute("lineNumber", -1);
            String mType = marker.getType();
            sb.append(i).append(") line=\"").append(line).append("\"; type=\"").append(mType).append("\"; message=\"").append(message).append("\";\r\n");
            ++i;
        }
        sb.append("]");
        System.out.println(sb.toString());
        AbstractResourceMarkerTest.assertMarkerIsCreated((IResource)file, (String)messagePattern, (boolean)false, (int[])new int[]{49, 50, 53, 57, 64});
    }

    private List<IMarker> getMarkersByGroupName(IResource resource, String messageGroup) throws CoreException {
        ArrayList<IMarker> ms = new ArrayList<IMarker>();
        IMarker[] markers = resource.findMarkers("org.eclipse.wst.validation.problemmarker", true, 2);
        int i = 0;
        while (i < markers.length) {
            String groupName = markers[i].getAttribute("groupName", null);
            if (groupName != null && (groupName.equals(messageGroup) || groupName.equals("markedKbResource"))) {
                ms.add(markers[i]);
            }
            ++i;
        }
        return ms;
    }

    public void testMessageBundles() throws CoreException {
        IFile file = this.project.getFile("WebContent/messagesValidation.jsp");
        int number = SeamValidatorsTest.getMarkersNumberByGroupName((IResource)file, (String)"markedSeamProject");
        SeamValidatorsTest.assertEquals((String)"Problem marker was found in messagesValidation.jsp file. Validator did not recognize a message bundle.", (int)0, (int)number);
    }

    public void testJiraJbide1696() throws CoreException, ValidationException {
        IFile subclassComponentFile = this.project.getFile("src/action/org/domain/SeamWebWarTestProject/session/SubclassTestComponent.java");
        SeamCoreValidatorWrapper seamValidator = new SeamCoreValidatorWrapper(this.project);
        seamValidator.validate(subclassComponentFile);
        SeamValidatorsTest.assertTrue((String)"Error marker not found", (boolean)seamValidator.isMessageCreated(SeamValidationMessages.STATEFUL_COMPONENT_DOES_NOT_CONTAIN_REMOVE, new String[]{"testComponentJBIDE1696"}));
        IFile superclassComponentFile = this.project.getFile("src/action/org/domain/SeamWebWarTestProject/session/SuperclassTestComponent.java");
        this.copyContentsFile(superclassComponentFile, "src/action/org/domain/SeamWebWarTestProject/session/SuperclassTestComponent.withRemove");
        this.project.build(10, null);
        seamValidator = new SeamCoreValidatorWrapper(this.project);
        seamValidator.validate(subclassComponentFile);
        SeamValidatorsTest.assertTrue((String)"We changed super class of component but it still don't see changes.", (seamValidator.getMessages().size() == 0 ? 1 : 0) != 0);
    }

    public void testJiraJbide1631() throws CoreException, ValidationException {
        IFile jbide1631XHTMLFile = this.project.getFile("WebContent/JBIDE-1631.xhtml");
        IFile jbide1631XHTMLFile2 = this.project.getFile("WebContent/JBIDE-1631.1");
        this.copyContentsFile(jbide1631XHTMLFile, jbide1631XHTMLFile2);
        ELValidatorWrapper elValidator = new ELValidatorWrapper(this.project);
        elValidator.validate(jbide1631XHTMLFile);
        SeamValidatorsTest.assertTrue((String)"Error marker not found", (boolean)elValidator.isMessageCreated(ELValidationMessages.UNKNOWN_EL_VARIABLE_NAME, new Object[]{"foo1"}));
        SeamValidatorsTest.assertTrue((String)"Error marker not found", (boolean)elValidator.isMessageCreated(ELValidationMessages.UNKNOWN_EL_VARIABLE_NAME, new Object[]{"foo2"}));
    }

    public void testDuplicateComponentNameValidator() throws CoreException, ValidationException {
        this.copyContentsFile("src/action/org/domain/SeamWebWarTestProject/session/BbcComponent.java", "src/action/org/domain/SeamWebWarTestProject/session/BbcComponent.original");
        IFile bbcComponentFile = this.project.getFile("src/action/org/domain/SeamWebWarTestProject/session/BbcComponent.java");
        SeamCoreValidatorWrapper seamValidator = new SeamCoreValidatorWrapper(this.project);
        seamValidator.validate(bbcComponentFile);
        SeamValidatorsTest.assertFalse((String)"Error marker was found", (boolean)seamValidator.isMessageCreated(SeamValidationMessages.NONUNIQUE_COMPONENT_NAME_MESSAGE, new Object[]{"abcComponent"}));
        this.copyContentsFile("src/action/org/domain/SeamWebWarTestProject/session/BbcComponent.java", "src/action/org/domain/SeamWebWarTestProject/session/BbcComponent.2");
        seamValidator = new SeamCoreValidatorWrapper(this.project);
        seamValidator.validate(bbcComponentFile);
        SeamValidatorsTest.assertTrue((String)"Error marker not found", (boolean)seamValidator.isMessageCreated(SeamValidationMessages.NONUNIQUE_COMPONENT_NAME_MESSAGE, new Object[]{"abcComponent"}));
        this.copyContentsFile("src/action/org/domain/SeamWebWarTestProject/session/BbcComponent.java", "src/action/org/domain/SeamWebWarTestProject/session/BbcComponent.original");
    }

    public void testStatefulComponentWithoutRemoveMethodValidator() throws CoreException, ValidationException {
        this.project.getFile("src/action/org/domain/SeamWebWarTestProject/session/StatefulComponent.java");
        this.assertMarkerIsCreatedForLine("src/action/org/domain/SeamWebWarTestProject/session/StatefulComponent.java", "src/action/org/domain/SeamWebWarTestProject/session/StatefulComponent.2", SeamValidationMessages.STATEFUL_COMPONENT_DOES_NOT_CONTAIN_REMOVE, new Object[]{"statefulComponent"}, 16);
    }

    private void assertMarkerIsCreatedForLineOfFile(String path, String markerTemplate, Object[] parameters, int lineNumber) throws CoreException, ValidationException {
        SeamCoreValidatorWrapper validator = new SeamCoreValidatorWrapper(this.project);
        this.assertMarkerIsCreatedForLine(validator, path, markerTemplate, parameters, lineNumber);
    }

    private void assertMarkerIsCreatedForLine(String target, String newContent, String markerTemplate, Object[] parameters, int lineNumber) throws CoreException, ValidationException {
        SeamCoreValidatorWrapper validator = new SeamCoreValidatorWrapper(this.project);
        this.assertMarkerIsCreatedForLine(validator, target, newContent, markerTemplate, parameters, lineNumber);
    }

    private void assertMarkerIsCreatedForLine(IValidatorSupport validator, String target, String newContent, String markerTemplate, Object[] parameters, int lineNumber) throws CoreException, ValidationException {
        this.copyContentsFile(target, newContent);
        this.assertMarkerIsCreatedForLine(validator, target, markerTemplate, parameters, lineNumber);
    }

    private void assertMarkerIsCreatedForLine(String target, String markerTemplate, Object[] parameters, int lineNumber) throws CoreException, ValidationException {
        SeamCoreValidatorWrapper validator = new SeamCoreValidatorWrapper(this.project);
        this.assertMarkerIsCreatedForLine(validator, target, markerTemplate, parameters, lineNumber);
    }

    private void assertMarkerIsCreatedForLine(IValidatorSupport validator, String target, String markerTemplate, Object[] parameters, int lineNumber) throws CoreException, ValidationException {
        IFile targetFile = this.project.getFile(target);
        validator.validate(targetFile);
        SeamValidatorsTest.assertTrue((String)"Error marker not found", (boolean)validator.isMessageCreated(markerTemplate, parameters));
        SeamValidatorsTest.assertTrue((String)"Error marker has wrong line number", (boolean)validator.isMessageCreatedOnLine(markerTemplate, parameters, lineNumber));
    }

    private void assertMarkerIsNotCreatedForFile(String target, String newContent, String markerTemplate, Object[] parameters) throws CoreException, ValidationException {
        SeamCoreValidatorWrapper validator = new SeamCoreValidatorWrapper(this.project);
        this.assertMarkerIsNotCreatedForFile(validator, target, newContent, markerTemplate, parameters);
    }

    private void assertMarkerIsNotCreatedForFile(IValidatorSupport validator, String target, String newContent, String markerTemplate, Object[] parameters) throws CoreException, ValidationException {
        this.copyContentsFile(target, newContent);
        this.assertMarkerIsNotCreatedForFile(validator, target, markerTemplate, parameters);
    }

    private void assertMarkerIsNotCreatedForFile(String target, String markerTemplate, Object[] parameters) throws ValidationException, CoreException {
        SeamCoreValidatorWrapper validator = new SeamCoreValidatorWrapper(this.project);
        this.assertMarkerIsNotCreatedForFile(validator, target, markerTemplate, parameters);
    }

    private void assertMarkerIsNotCreatedForFile(IValidatorSupport validator, String target, String markerTemplate, Object[] parameters) throws ValidationException, CoreException {
        IFile targetFile = this.project.getFile(target);
        validator.validate(targetFile);
        SeamValidatorsTest.assertFalse((String)"Error marker was found", (boolean)validator.isMessageCreated(markerTemplate, parameters));
    }

    public void testStatefulComponentWithoutDestroyMethodValidator() throws CoreException, ValidationException {
        this.assertMarkerIsCreatedForLine("src/action/org/domain/SeamWebWarTestProject/session/StatefulComponent.java", "src/action/org/domain/SeamWebWarTestProject/session/StatefulComponent.3", SeamValidationMessages.STATEFUL_COMPONENT_DOES_NOT_CONTAIN_DESTROY, new Object[]{"statefulComponent"}, 16);
    }

    public void testStatefulComponentHasWrongScopeValidator() throws CoreException, ValidationException {
        this.assertMarkerIsCreatedForLine("src/action/org/domain/SeamWebWarTestProject/session/StatefulComponent.java", "src/action/org/domain/SeamWebWarTestProject/session/StatefulComponent.4", SeamValidationMessages.STATEFUL_COMPONENT_WRONG_SCOPE, new Object[]{"statefulComponent"}, 16);
    }

    public void testComponentTypeValidator() throws CoreException, ValidationException {
        this.assertMarkerIsCreatedForLine("WebContent/WEB-INF/components.xml", "WebContent/WEB-INF/components.2", SeamValidationMessages.UNKNOWN_COMPONENT_CLASS_NAME, new Object[]{"org.domain.SeamWebWarTestProject.session.StateComponent"}, 15);
    }

    public void testComponentWithoutSetterValidator() throws CoreException, ValidationException {
        this.assertMarkerIsCreatedForLine("WebContent/WEB-INF/components.xml", "WebContent/WEB-INF/components.3", SeamValidationMessages.UNKNOWN_COMPONENT_PROPERTY, new Object[]{"StatefulComponentWithAbcField", "statefulComponentWithAbcField", "abc"}, 16);
    }

    public void testEntityHasWrongScopeValidator() throws CoreException, ValidationException {
        this.assertMarkerIsCreatedForLine("src/action/org/domain/SeamWebWarTestProject/entity/abcEntity.java", "src/action/org/domain/SeamWebWarTestProject/entity/abcEntity.2", SeamValidationMessages.ENTITY_COMPONENT_WRONG_SCOPE, new Object[]{"abcEntity"}, 15);
    }

    public void testDuplicateDestroyMethodValidator() throws CoreException, ValidationException {
        this.assertMarkerIsCreatedForLine("src/action/org/domain/SeamWebWarTestProject/session/StatefulComponent.java", "src/action/org/domain/SeamWebWarTestProject/session/StatefulComponent.6", SeamValidationMessages.DUPLICATE_DESTROY, new Object[]{"destroyMethod"}, 34);
        this.assertMarkerIsCreatedForLine("src/action/org/domain/SeamWebWarTestProject/session/StatefulComponent.java", SeamValidationMessages.DUPLICATE_DESTROY, new Object[]{"destroyMethod2"}, 39);
    }

    public void testDuplicateCreateMethodValidator() throws CoreException, ValidationException {
        this.assertMarkerIsCreatedForLine("src/action/org/domain/SeamWebWarTestProject/session/StatefulComponent.java", "src/action/org/domain/SeamWebWarTestProject/session/StatefulComponent.7", SeamValidationMessages.DUPLICATE_CREATE, new Object[]{"createMethod"}, 36);
        this.assertMarkerIsCreatedForLine("src/action/org/domain/SeamWebWarTestProject/session/StatefulComponent.java", SeamValidationMessages.DUPLICATE_CREATE, new Object[]{"createMethod2"}, 41);
    }

    public void testDuplicateUnwrapMethodValidator() throws CoreException, ValidationException {
        this.assertMarkerIsCreatedForLine("src/action/org/domain/SeamWebWarTestProject/session/StatefulComponent.java", "src/action/org/domain/SeamWebWarTestProject/session/StatefulComponent.8", SeamValidationMessages.DUPLICATE_UNWRAP, new Object[]{"unwrapMethod"}, 40);
        this.assertMarkerIsCreatedForLine("src/action/org/domain/SeamWebWarTestProject/session/StatefulComponent.java", SeamValidationMessages.DUPLICATE_UNWRAP, new Object[]{"unwrapMethod2"}, 45);
    }

    public void testOnlyJavaBeansAndStatefulSessionBeansSupportDestroyMethodValidator() throws CoreException, ValidationException {
        this.assertMarkerIsCreatedForLine("src/action/org/domain/SeamWebWarTestProject/session/StatefulComponent.java", "src/action/org/domain/SeamWebWarTestProject/session/StatefulComponent.9", SeamValidationMessages.DESTROY_METHOD_BELONGS_TO_STATELESS_SESSION_BEAN, new Object[]{"destroyMethod"}, 25);
    }

    public void testOnlyComponentClassCanHaveCreateMethodValidator() throws CoreException, ValidationException {
        this.assertMarkerIsCreatedForLine("src/action/org/domain/SeamWebWarTestProject/session/StatefulComponent.java", "src/action/org/domain/SeamWebWarTestProject/session/StatefulComponent.10", SeamValidationMessages.CREATE_DOESNT_BELONG_TO_COMPONENT, new Object[]{"createMethod"}, 25);
    }

    public void testOnlyComponentClassCanHaveUnwrapMethodValidator() throws CoreException, ValidationException {
        this.assertMarkerIsCreatedForLine("src/action/org/domain/SeamWebWarTestProject/session/StatefulComponent.java", "src/action/org/domain/SeamWebWarTestProject/session/StatefulComponent.11", SeamValidationMessages.UNWRAP_DOESNT_BELONG_TO_COMPONENT, new Object[]{"unwrapMethod"}, 26);
    }

    public void testOnlyComponentClassCanHaveObserverMethodValidator() throws CoreException, ValidationException {
        this.assertMarkerIsCreatedForLine("src/action/org/domain/SeamWebWarTestProject/session/StatefulComponent.java", "src/action/org/domain/SeamWebWarTestProject/session/StatefulComponent.12", SeamValidationMessages.OBSERVER_DOESNT_BELONG_TO_COMPONENT, new Object[]{"observerMethod"}, 26);
    }

    public void testDuplicateRemoveMethodValidator() throws CoreException, ValidationException {
        this.assertMarkerIsCreatedForLine("src/action/org/domain/SeamWebWarTestProject/session/StatefulComponent.java", "src/action/org/domain/SeamWebWarTestProject/session/StatefulComponent.1", SeamValidationMessages.DUPLICATE_REMOVE, new Object[]{"removeMethod1"}, 18);
        this.assertMarkerIsCreatedForLine("src/action/org/domain/SeamWebWarTestProject/session/StatefulComponent.java", SeamValidationMessages.DUPLICATE_REMOVE, new Object[]{"removeMethod2"}, 22);
    }

    protected void assertMarkerIsCreated(String targetPath, String newContentPath, String pattern, int line) throws CoreException {
        IFile newContentFile = this.project.getFile(newContentPath);
        IFile targetFile = this.project.getFile(targetPath);
        this.copyContentsFile(targetFile, newContentFile);
        SeamValidatorsTest.assertMarkerIsCreated((IResource)targetFile, (String)"org.eclipse.wst.validation.problemmarker", (String)pattern, (int[])new int[]{line});
    }

    protected void assertMarkerIsCreated(String targetPath, String pattern, int line) throws CoreException {
        IFile targetFile = this.project.getFile(targetPath);
        SeamValidatorsTest.assertMarkerIsCreated((IResource)targetFile, (String)"org.eclipse.wst.validation.problemmarker", (String)pattern, (int[])new int[]{line});
    }

    public void testDuplicateRemoveMethodInComponent_Validator() throws CoreException {
        this.getSeamProject(this.project);
        IFile componentFile = this.project.getFile("src/action/org/domain/SeamWebWarTestProject/session/UsualComponent.java");
        int number = SeamValidatorsTest.getMarkersNumberByGroupName((IResource)componentFile, (String)"markedSeamProject");
        SeamValidatorsTest.assertEquals((String)"Problem marker was found in UsualComponent.java file", (int)0, (int)number);
    }

    public void testUnknownFactoryNameValidator() throws CoreException, ValidationException {
        this.assertMarkerIsNotCreatedForFile("src/action/org/domain/SeamWebWarTestProject/session/Component12.java", SeamValidationMessages.UNKNOWN_FACTORY_NAME, new Object[]{"messageList2"});
        this.assertMarkerIsCreatedForLine("src/action/org/domain/SeamWebWarTestProject/session/Component12.java", "src/action/org/domain/SeamWebWarTestProject/session/Component12.2", SeamValidationMessages.UNKNOWN_FACTORY_NAME, new Object[]{"messageList2"}, 24);
    }

    public void testDuplicateFactoryNameValidator() throws CoreException, ValidationException {
        this.assertMarkerIsNotCreatedForFile("src/action/org/domain/SeamWebWarTestProject/session/DuplicateFactory.java", SeamValidationMessages.DUPLICATE_VARIABLE_NAME, new Object[]{"testFactory1"});
        this.assertMarkerIsCreatedForLine("src/action/org/domain/SeamWebWarTestProject/session/DuplicateFactory.java", "src/action/org/domain/SeamWebWarTestProject/session/DuplicateFactory.1", SeamValidationMessages.DUPLICATE_VARIABLE_NAME, new Object[]{"testFactory1"}, 16);
        this.assertMarkerIsCreatedForLine("src/action/org/domain/SeamWebWarTestProject/session/DuplicateFactory.java", SeamValidationMessages.DUPLICATE_VARIABLE_NAME, new Object[]{"testFactory1"}, 21);
    }

    public void testMultipleDataBinderValidator() throws CoreException, ValidationException {
        this.assertMarkerIsNotCreatedForFile("src/action/org/domain/SeamWebWarTestProject/session/SelectionTest.java", SeamValidationMessages.MULTIPLE_DATA_BINDER, new Object[0]);
        this.assertMarkerIsNotCreatedForFile("src/action/org/domain/SeamWebWarTestProject/session/SelectionIndexTest.java", SeamValidationMessages.MULTIPLE_DATA_BINDER, new Object[0]);
        this.assertMarkerIsCreatedForLine("src/action/org/domain/SeamWebWarTestProject/session/SelectionTest.java", "src/action/org/domain/SeamWebWarTestProject/session/SelectionTest.2", SeamValidationMessages.MULTIPLE_DATA_BINDER, new Object[0], 21);
        this.assertMarkerIsCreatedForLine("src/action/org/domain/SeamWebWarTestProject/session/SelectionTest.java", SeamValidationMessages.MULTIPLE_DATA_BINDER, new Object[0], 24);
        this.assertMarkerIsCreatedForLine("src/action/org/domain/SeamWebWarTestProject/session/SelectionIndexTest.java", "src/action/org/domain/SeamWebWarTestProject/session/SelectionIndexTest.2", SeamValidationMessages.MULTIPLE_DATA_BINDER, new Object[0], 21);
        this.assertMarkerIsCreatedForLine("src/action/org/domain/SeamWebWarTestProject/session/SelectionIndexTest.java", SeamValidationMessages.MULTIPLE_DATA_BINDER, new Object[0], 24);
    }

    public void testUnknownDataModelNameValidator() throws CoreException, ValidationException {
        this.project.getFile("src/action/org/domain/SeamWebWarTestProject/session/SelectionTest.java");
        this.project.getFile("src/action/org/domain/SeamWebWarTestProject/session/SelectionIndexTest.java");
        this.assertMarkerIsCreatedForLine("src/action/org/domain/SeamWebWarTestProject/session/SelectionTest.java", "src/action/org/domain/SeamWebWarTestProject/session/SelectionTest.3", SeamValidationMessages.UNKNOWN_DATA_MODEL, new Object[]{"messageList2"}, 27);
        this.assertMarkerIsCreatedForLine("src/action/org/domain/SeamWebWarTestProject/session/SelectionIndexTest.java", "src/action/org/domain/SeamWebWarTestProject/session/SelectionIndexTest.3", SeamValidationMessages.UNKNOWN_DATA_MODEL, new Object[]{"messageList2"}, 27);
    }

    public void testDuplicateVariableName_Validator() throws CoreException, ValidationException {
        this.modifyPreferences();
        this.assertMarkerIsNotCreatedForFile("src/action/org/domain/SeamWebWarTestProject/session/ContextVariableTest.java", SeamValidationMessages.DUPLICATE_VARIABLE_NAME, new Object[]{"messageList"});
        this.assertMarkerIsCreatedForLine("src/action/org/domain/SeamWebWarTestProject/session/ContextVariableTest.java", "src/action/org/domain/SeamWebWarTestProject/session/ContextVariableTest.2", SeamValidationMessages.DUPLICATE_VARIABLE_NAME, new Object[]{"messageList"}, 36);
        this.assertMarkerIsCreatedForLine("src/action/org/domain/SeamWebWarTestProject/session/ContextVariableTest.java", SeamValidationMessages.DUPLICATE_VARIABLE_NAME, new Object[]{"messageList"}, 41);
    }

    public void testUnknownVariableNameValidator() throws CoreException, ValidationException {
        IFile contextVariableTestFile = this.project.getFile("src/action/org/domain/SeamWebWarTestProject/session/ContextVariableTest.java");
        String markerText = "Unknown context variable name: \"messageList5\"";
        SeamValidatorsTest.assertMarkerIsNotCreated((IResource)contextVariableTestFile, (String)"org.eclipse.wst.validation.problemmarker", (String)markerText);
        this.assertMarkerIsCreatedForLine("src/action/org/domain/SeamWebWarTestProject/session/ContextVariableTest.java", "src/action/org/domain/SeamWebWarTestProject/session/ContextVariableTest.3", SeamValidationMessages.UNKNOWN_VARIABLE_NAME, new Object[]{"messageList5"}, 22);
    }

    public void testContextVariableCannotBeResolvedValidator() throws CoreException, ValidationException {
        this.modifyPreferences();
        this.assertMarkerIsNotCreatedForFile(new ELValidatorWrapper(this.project), "WebContent/abcComponent.xhtml", ELValidationMessages.UNKNOWN_EL_VARIABLE_NAME, new Object[]{"bcComponent"});
        this.assertMarkerIsCreatedForLine(new ELValidatorWrapper(this.project), "WebContent/abcComponent.xhtml", "WebContent/abcComponent.2", ELValidationMessages.UNKNOWN_EL_VARIABLE_NAME, new Object[]{"bcComponent"}, 22);
    }

    public void testPropertyCannotBeResolvedValidator() throws CoreException, ValidationException {
        this.assertMarkerIsNotCreatedForFile(new ELValidatorWrapper(this.project), "WebContent/abcComponent.xhtml", ELValidationMessages.UNKNOWN_EL_VARIABLE_PROPERTY_NAME, new Object[]{"actionType2"});
        this.assertMarkerIsCreatedForLine(new ELValidatorWrapper(this.project), "WebContent/abcComponent.xhtml", "WebContent/abcComponent.3", ELValidationMessages.UNKNOWN_EL_VARIABLE_PROPERTY_NAME, new Object[]{"actionType2"}, 22);
    }

    public void testPropertyHasOnlySetterValidator() throws CoreException, ValidationException {
        try {
            this.enableUnpairGetterOrSetterValidation(true);
            String target = "src/action/org/domain/SeamWebWarTestProject/session/AbcComponent.java";
            this.copyContentsFile(target, "src/action/org/domain/SeamWebWarTestProject/session/AbcComponent.2");
            this.copyContentsFile("WebContent/abcComponent.xhtml", "WebContent/abcComponent.4");
            IFile targetFile = this.project.getFile(target);
            ELValidatorWrapper wrapper = new ELValidatorWrapper(this.project);
            wrapper.validate(targetFile);
            this.assertMarkerIsCreatedForLine(wrapper, "WebContent/abcComponent.xhtml", "WebContent/abcComponent.4", ELValidationMessages.UNPAIRED_GETTER_OR_SETTER, new Object[]{"actionType", "Setter", "Getter"}, 22);
        }
        finally {
            this.enableUnpairGetterOrSetterValidation(false);
        }
    }

    public void testPropertyHasOnlyGetterValidator() throws CoreException, ValidationException {
        try {
            this.enableUnpairGetterOrSetterValidation(true);
            String target = "src/action/org/domain/SeamWebWarTestProject/session/AbcComponent.java";
            this.copyContentsFile(target, "src/action/org/domain/SeamWebWarTestProject/session/AbcComponent.3");
            JobUtils.waitForIdle();
            IFile targetFile = this.project.getFile(target);
            ELValidatorWrapper wrapper = new ELValidatorWrapper(this.project);
            wrapper.validate(targetFile);
            this.assertMarkerIsCreatedForLine(wrapper, "WebContent/abcComponent.xhtml", "WebContent/abcComponent.original", ELValidationMessages.UNPAIRED_GETTER_OR_SETTER, new Object[]{"actionType", "Getter", "Setter"}, 22);
        }
        finally {
            this.enableUnpairGetterOrSetterValidation(false);
        }
    }

    private void enableUnpairGetterOrSetterValidation(boolean enable) {
        IPreferenceStore store = WebKbPlugin.getDefault().getPreferenceStore();
        store.putValue(ELSeverityPreferences.UNPAIRED_GETTER_OR_SETTER, enable ? "error" : "ignore");
        if (store instanceof IPersistentPreferenceStore) {
            try {
                ((IPersistentPreferenceStore)store).save();
            }
            catch (IOException e) {
                SeamCorePlugin.getPluginLog().logError((Throwable)e);
            }
        }
    }

    public void testInheritedMethods() throws CoreException {
        ISeamProject seamProject = this.getSeamProject(this.project);
        ISeamComponent c = seamProject.getComponent("inheritedComponent");
        SeamValidatorsTest.assertNotNull((String)"Component inheritedComponent is not found", (Object)c);
        Set ms = c.getMethodsByType(SeamComponentMethodType.DESTROY);
        SeamValidatorsTest.assertTrue((String)"Seam tools does not see @Destroy-annotated method declared in super class", (ms.size() > 0 ? 1 : 0) != 0);
        ms = c.getMethodsByType(SeamComponentMethodType.REMOVE);
        SeamValidatorsTest.assertTrue((String)"Seam tools does not see @Remove-annotated method declared in super class", (ms.size() > 0 ? 1 : 0) != 0);
        IFile f = this.project.getFile("src/action/org/domain/SeamWebWarTestProject/session/InheritedComponent.java");
        int errorsCount = SeamValidatorsTest.getMarkersNumber((IResource)f);
        SeamValidatorsTest.assertEquals((String)"Seam tools validator does not see annotated methods declared in super class", (int)0, (int)errorsCount);
    }

    public void testDuplicateComponents() throws CoreException, ValidationException {
        this.assertMarkerIsCreatedForLine("WebContent/WEB-INF/components.xml", "WebContent/WEB-INF/duplicateComponents.test", SeamValidationMessages.NONUNIQUE_COMPONENT_NAME_MESSAGE, new Object[]{"duplicateJavaAndXmlComponentName"}, 5);
        this.assertMarkerIsCreatedForLine("WebContent/WEB-INF/components.xml", SeamValidationMessages.NONUNIQUE_COMPONENT_NAME_MESSAGE, new Object[]{"duplicateJavaAndXmlComponentName"}, 8);
        this.assertMarkerIsCreatedForLine("src/action/org/domain/SeamWebWarTestProject/session/DuplicateComponent.java", SeamValidationMessages.NONUNIQUE_COMPONENT_NAME_MESSAGE, new Object[]{"duplicateJavaAndXmlComponentName"}, 5);
    }

    public void testErrorMarkerForEL() throws CoreException, ValidationException {
        this.assertMarkerIsCreatedForLine(new ELValidatorWrapper(this.project), "WebContent/markerTest.xhtml", ELValidationMessages.UNKNOWN_EL_VARIABLE_NAME, new Object[]{"testtt"}, 9);
    }

    public void testErrorMarkerInPagesXML() throws CoreException, ValidationException {
        SeamCoreValidatorWrapper seamValidator = new SeamCoreValidatorWrapper(this.project);
        this.assertMarkerIsCreatedForLine(seamValidator, "WebContent/WEB-INF/pages.xml", SeamValidationMessages.UNRESOLVED_VIEW_ID, new Object[]{"/home1.xhtml"}, 14);
        this.assertMarkerIsCreatedForLine(seamValidator, "WebContent/WEB-INF/pages.xml", SeamValidationMessages.UNRESOLVED_VIEW_ID, new Object[]{"/home2.xhtml"}, 17);
        this.assertMarkerIsCreatedForLine(seamValidator, "WebContent/WEB-INF/pages.xml", SeamValidationMessages.UNRESOLVED_VIEW_ID, new Object[]{"/home1.xhtml"}, 22);
        this.assertMarkerIsCreatedForLine(seamValidator, "WebContent/WEB-INF/pages.xml", SeamValidationMessages.UNRESOLVED_VIEW_ID, new Object[]{"/home2.xhtml"}, 23);
    }

    public static int getMarkersNumber(IResource resource) {
        return SeamValidatorsTest.getMarkersNumberByGroupName((IResource)resource, (String)"markedSeamProject");
    }

    private static boolean findLine(Integer[] lines, int number) {
        int i = 0;
        while (i < lines.length) {
            if (lines[i] == number) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void modifyPreferences() {
        IPreferenceStore store = SeamCorePlugin.getDefault().getPreferenceStore();
        store.putValue(SeamPreferences.UNKNOWN_VARIABLE_NAME, "error");
        if (store instanceof IPersistentPreferenceStore) {
            try {
                ((IPersistentPreferenceStore)store).save();
            }
            catch (IOException e) {
                SeamCorePlugin.getPluginLog().logError((Throwable)e);
            }
        }
        store = WebKbPlugin.getDefault().getPreferenceStore();
        store.putValue(ELSeverityPreferences.UNKNOWN_EL_VARIABLE_NAME, "error");
        store.putValue(ELSeverityPreferences.UNKNOWN_EL_VARIABLE_PROPERTY_NAME, "error");
        store.putValue(ELSeverityPreferences.RE_VALIDATE_UNRESOLVED_EL, "enabled");
        if (store instanceof IPersistentPreferenceStore) {
            try {
                ((IPersistentPreferenceStore)store).save();
            }
            catch (IOException e) {
                SeamCorePlugin.getPluginLog().logError((Throwable)e);
            }
        }
    }

    private void modifyPreference(String name, String value) {
        IPreferenceStore store = SeamCorePlugin.getDefault().getPreferenceStore();
        if (store instanceof IPersistentPreferenceStore) {
            try {
                ((IPersistentPreferenceStore)store).save();
            }
            catch (IOException e) {
                SeamCorePlugin.getPluginLog().logError((Throwable)e);
            }
        }
        store = WebKbPlugin.getDefault().getPreferenceStore();
        store.putValue(name, value);
        if (store instanceof IPersistentPreferenceStore) {
            try {
                ((IPersistentPreferenceStore)store).save();
            }
            catch (IOException e) {
                SeamCorePlugin.getPluginLog().logError((Throwable)e);
            }
        }
    }

    public static class SeamMarkerFilter
    implements IMarkerFilter {
        public boolean accept(IMarker marker) {
            String groupName = marker.getAttribute("groupName", null);
            return groupName != null && (groupName.equals("markedSeamProject") || groupName.equals("markedKbResource"));
        }
    }
}

