/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.seam.core.test;

import java.util.List;
import java.util.Properties;
import java.util.Set;
import junit.framework.TestCase;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.jboss.tools.common.xml.XMLUtilities;
import org.jboss.tools.seam.core.ISeamComponent;
import org.jboss.tools.seam.core.ISeamComponentDeclaration;
import org.jboss.tools.seam.core.ISeamElement;
import org.jboss.tools.seam.core.ISeamFactory;
import org.jboss.tools.seam.core.ISeamProject;
import org.jboss.tools.seam.internal.core.SeamAnnotatedFactory;
import org.jboss.tools.seam.internal.core.SeamJavaComponentDeclaration;
import org.jboss.tools.seam.internal.core.SeamProject;
import org.jboss.tools.seam.internal.core.SeamPropertiesDeclaration;
import org.jboss.tools.seam.internal.core.SeamXmlComponentDeclaration;
import org.jboss.tools.seam.internal.core.SeamXmlFactory;
import org.jboss.tools.test.util.JUnitUtils;
import org.jboss.tools.test.util.JobUtils;
import org.jboss.tools.test.util.ResourcesUtils;
import org.osgi.framework.Bundle;
import org.w3c.dom.Element;

public class SerializationTest
extends TestCase {
    IProject project = null;
    boolean makeCopy = true;

    public SerializationTest() {
        super("Seam Serialization test");
    }

    protected void setUp() throws Exception {
        this.project = ResourcesUtils.importProject((String)"org.jboss.tools.seam.base.test", (String)"/projects/TestScanner", (IProgressMonitor)new NullProgressMonitor());
        this.project.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
        this.project.build(6, null);
    }

    protected void tearDown() throws Exception {
        if (this.project == null || !this.project.exists()) {
            return;
        }
        try {
            boolean oldAutoBuilding = true;
            try {
                oldAutoBuilding = ResourcesUtils.setBuildAutomatically((boolean)false);
                JobUtils.waitForIdle((long)10L);
                this.project.delete(false, true, null);
                JobUtils.waitForIdle((long)10L);
            }
            finally {
                ResourcesUtils.setBuildAutomatically((boolean)oldAutoBuilding);
            }
        }
        catch (CoreException ex) {
            ILog log = Platform.getLog((Bundle)Platform.getBundle((String)"org.jboss.tools.tests"));
            Status error = new Status(4, "org.jboss.tools.test", "Exception occurs during project deletion", (Throwable)ex);
            log.log((IStatus)error);
        }
    }

    private ISeamProject getSeamProject() {
        ISeamProject seamProject = null;
        try {
            seamProject = (ISeamProject)this.project.getNature("org.jboss.tools.seam.core.seamnature");
        }
        catch (Exception e) {
            JUnitUtils.fail((String)"Cannot get seam nature.", (Exception)e);
        }
        SerializationTest.assertNotNull((String)"Seam project is null", (Object)seamProject);
        return seamProject;
    }

    public void testXMLSerialization() {
        ISeamFactory[] fs;
        ISeamComponent[] cs;
        Element root = XMLUtilities.createDocumentElement((String)"root");
        ISeamProject seamProject = this.getSeamProject();
        ISeamComponent[] iSeamComponentArray = cs = seamProject.getComponents();
        int n = cs.length;
        int n2 = 0;
        while (n2 < n) {
            ISeamComponent c = iSeamComponentArray[n2];
            Set ds = c.getAllDeclarations();
            for (ISeamComponentDeclaration d : ds) {
                Properties context = new Properties();
                context.put("path", d.getSourcePath());
                Element e = d.toXML(root, context);
                String cls = e.getAttribute("class");
                SeamJavaComponentDeclaration d2 = null;
                if ("java".equals(cls)) {
                    d2 = new SeamJavaComponentDeclaration();
                } else if ("xml".equals(cls)) {
                    d2 = new SeamXmlComponentDeclaration();
                } else if ("properties".equals(cls)) {
                    d2 = new SeamPropertiesDeclaration();
                }
                SerializationTest.assertNotNull((String)("Cannot restore declaration " + d.getName() + " " + d.getClass().getName()), (Object)d2);
                d2.loadXML(e, context);
                List changes = d2.merge((ISeamElement)d);
                if (changes != null && changes.size() > 0) {
                    System.out.println(String.valueOf(d.getName()) + " " + d.getClass().getName() + " " + changes.size());
                }
                root.removeChild(e);
            }
            ++n2;
        }
        ISeamFactory[] iSeamFactoryArray = fs = seamProject.getFactories();
        int n3 = fs.length;
        n = 0;
        while (n < n3) {
            ISeamFactory f = iSeamFactoryArray[n];
            Properties context = new Properties();
            context.put("path", f.getSourcePath());
            Element e = f.toXML(root, context);
            String cls = e.getAttribute("class");
            SeamXmlFactory f2 = null;
            if ("xml".equals(cls)) {
                f2 = new SeamXmlFactory();
            } else if ("java".equals(cls)) {
                f2 = new SeamAnnotatedFactory();
            }
            SerializationTest.assertNotNull((String)("Cannot restore factory declaration " + f.getName() + " " + f.getClass().getName()), (Object)f2);
            f2.loadXML(e, context);
            List changes = f2.merge((ISeamElement)f);
            if (changes != null && changes.size() > 0) {
                System.out.println(String.valueOf(f.getName()) + " " + f.getClass().getName() + " " + changes.size());
            }
            ++n;
        }
    }

    public void testLoadSerializedModelTime() {
        ISeamProject sp = this.getSeamProject();
        long time = ((SeamProject)sp).reload();
        int components = sp.getComponents().length;
        System.out.print("Reloaded " + components + " components in " + time + " ms");
        float timePerComponent = 1.0f * (float)time / (float)components;
        SerializationTest.assertTrue((String)("Loading time per component is too large: " + timePerComponent + " ms."), (timePerComponent < 30.0f ? 1 : 0) != 0);
    }

    public void testCleanBuild() {
        ISeamProject sp = this.getSeamProject();
        try {
            boolean auto = ResourcesUtils.setBuildAutomatically((boolean)false);
            sp.getProject().build(6, null);
            int components_1 = sp.getComponents().length;
            SerializationTest.assertFalse((components_1 == 0 ? 1 : 0) != 0);
            sp.getProject().build(15, null);
            int components_2 = sp.getComponents().length;
            SerializationTest.assertEquals((int)components_2, (int)0);
            sp.getProject().build(6, null);
            int components_3 = sp.getComponents().length;
            SerializationTest.assertEquals((int)components_1, (int)components_3);
            ResourcesUtils.setBuildAutomatically((boolean)auto);
        }
        catch (CoreException e) {
            JUnitUtils.fail((String)e.getMessage(), (Exception)((Object)e));
        }
    }
}

