/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.seam.core.test.project.facet;

import junit.framework.TestCase;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.jboss.tools.common.model.util.EclipseResourceUtil;
import org.jboss.tools.seam.core.ISeamProject;
import org.jboss.tools.seam.core.SeamCorePlugin;
import org.jboss.tools.seam.core.SeamProjectsSet;
import org.jboss.tools.seam.internal.core.project.facet.SeamFacetInstallDataModelProvider;
import org.jboss.tools.test.util.ResourcesUtils;

public class SeamFacetOnExistingProjectTest
extends TestCase {
    IProject project;
    ISeamProject seamProject;

    protected void setUp() throws Exception {
        this.project = ResourcesUtils.importProject((String)"org.jboss.tools.seam.core.test", (String)"projects/jsf");
        this.project.build(6, null);
        IFacetedProject fproj = ProjectFacetsManager.create((IProject)this.project);
        IProjectFacet seamFacet = ProjectFacetsManager.getProjectFacet((String)"jst.seam");
        IProjectFacetVersion seamFacetVersion = seamFacet.getVersion("2.0");
        fproj.installProjectFacet(seamFacetVersion, (Object)this.createSeamDataModel(), null);
        this.project.build(6, null);
        this.seamProject = SeamCorePlugin.getSeamProject((IProject)this.project, (boolean)false);
    }

    protected void tearDown() throws Exception {
        ResourcesUtils.deleteProject((String)this.project.getName());
    }

    public void testSeamSettings() throws CoreException {
        SeamProjectsSet projectSet = new SeamProjectsSet(this.project);
        SeamFacetOnExistingProjectTest.assertEquals((Object)EclipseResourceUtil.getJavaSourceRoot((IProject)this.project), (Object)projectSet.getActionFolder());
        SeamFacetOnExistingProjectTest.assertEquals((Object)EclipseResourceUtil.getJavaSourceRoot((IProject)this.project), (Object)projectSet.getModelFolder());
    }

    protected IDataModel createSeamDataModel() {
        IDataModel config = (IDataModel)new SeamFacetInstallDataModelProvider().create();
        config.setBooleanProperty("database.exists", true);
        config.setBooleanProperty("database.drop", false);
        config.setStringProperty("seam.project.deployment.type", "war");
        config.setStringProperty("action.package", "org.session.beans");
        config.setStringProperty("model.package", "org.entity.beans");
        config.setStringProperty("test.package", "org.test.beans");
        config.setStringProperty("seam.project.connection.profile", "noop-connection");
        config.setProperty("driver.files.array", (Object)new String[]{"noop-driver.jar"});
        config.setProperty("driver.file", (Object)"noop-driver.jar");
        config.setBooleanProperty("seam.runtime.libraries.copying", true);
        return config;
    }
}

