/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.seam.core.test.project.facet;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import junit.framework.TestCase;
import org.jboss.tools.seam.core.project.facet.SeamRuntime;
import org.jboss.tools.seam.core.project.facet.SeamRuntimeListConverter;
import org.jboss.tools.seam.core.project.facet.SeamVersion;

public class SeamRuntimeListConverterTest
extends TestCase {
    public void testSerializeSeamRuntimeListToString() {
        HashMap<String, SeamRuntime> runtimes = new HashMap<String, SeamRuntime>();
        SeamRuntime rt1 = new SeamRuntime();
        rt1.setName("rt1");
        rt1.setHomeDir("homeDir");
        rt1.setVersion(SeamVersion.parseFromString((String)"1.2"));
        runtimes.put(rt1.getName(), rt1);
        SeamRuntime rt2 = new SeamRuntime();
        rt2.setName("rt2");
        rt2.setHomeDir("homeDir");
        rt2.setVersion(SeamVersion.parseFromString((String)"1.2"));
        runtimes.put(rt2.getName(), rt2);
        SeamRuntimeListConverter converter = new SeamRuntimeListConverter();
        String config = converter.getString(runtimes);
        SeamRuntimeListConverterTest.assertNotNull((String)"Saved runtime list cannot be null", (Object)config);
        SeamRuntimeListConverterTest.assertTrue((String)"Saved list of runtimes cannot be empty.", (!"".equals(config.trim()) ? 1 : 0) != 0);
        Map result = converter.getMap(config);
        SeamRuntimeComparator comparator = new SeamRuntimeComparator();
        for (SeamRuntime runtime : runtimes.values()) {
            SeamRuntime curr = (SeamRuntime)result.get(runtime.getName());
            SeamRuntimeListConverterTest.assertEquals((String)"Saved runtime was not restored correctly", (int)0, (int)comparator.compare(runtime, curr));
        }
    }

    public void testLoadingSeamRuntimeListFromString() {
        SeamRuntimeListConverter converter = new SeamRuntimeListConverter();
        Map runtimes = converter.getMap("name|rt1|homeDir|homeDirPath1|version|1.2|default|true,name|rt2|homeDir|homeDirPath2|version|1.2|default|false");
        SeamRuntimeListConverterTest.assertNotNull((String)"Loading runtime from string is failed", runtimes.get("rt1"));
        SeamRuntimeListConverterTest.assertNotNull((String)"Loading runtime from string is failed", runtimes.get("rt2"));
        SeamRuntime rt = (SeamRuntime)runtimes.get("rt1");
        SeamRuntimeListConverterTest.assertTrue((String)"Seam Runtime loaded incorrect", ("rt1".equals(rt.getName()) && "homeDirPath1".equals(rt.getHomeDir()) && SeamVersion.SEAM_1_2 == rt.getVersion() && rt.isDefault() ? 1 : 0) != 0);
        rt = (SeamRuntime)runtimes.get("rt2");
        SeamRuntimeListConverterTest.assertTrue((String)"Seam Runtime loaded incorrect", ("rt2".equals(rt.getName()) && "homeDirPath2".equals(rt.getHomeDir()) && SeamVersion.SEAM_1_2 == rt.getVersion() && !rt.isDefault() ? 1 : 0) != 0);
        runtimes = converter.getMap("");
        SeamRuntimeListConverterTest.assertTrue((String)"Loading runtimes from empty string should produce empty map", (runtimes.size() == 0 ? 1 : 0) != 0);
        runtimes = converter.getMap(null);
        SeamRuntimeListConverterTest.assertTrue((String)"Loading runtimes from null string should produce empty map", (runtimes.size() == 0 ? 1 : 0) != 0);
    }

    public static class SeamRuntimeComparator
    implements Comparator<SeamRuntime> {
        @Override
        public int compare(SeamRuntime o1, SeamRuntime o2) {
            if (o1.getName().equals(o2.getName()) && o1.getVersion() == o2.getVersion() && o1.getHomeDir().equals(o2.getHomeDir())) {
                return 0;
            }
            return 1;
        }
    }
}

