/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.seam.core.test.project.facet;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import junit.framework.TestCase;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.jboss.tools.seam.core.SeamUtil;
import org.jboss.tools.seam.core.project.facet.SeamRuntime;
import org.jboss.tools.seam.core.project.facet.SeamRuntimeManager;
import org.jboss.tools.seam.core.project.facet.SeamVersion;
import org.osgi.framework.Bundle;

public class SeamRuntimeManagerTest
extends TestCase {
    SeamRuntimeManager manager;

    protected void setUp() throws Exception {
        super.setUp();
        this.manager = SeamRuntimeManager.getInstance();
        SeamRuntimeManagerTest.assertNotNull((String)"Cannot obtainSeamRuntimeManager instance", (Object)this.manager);
    }

    public void testGetRuntimes() throws IOException {
        Bundle seamCoreTest = Platform.getBundle((String)"org.jboss.tools.seam.core.test");
        URL seamUrl = FileLocator.resolve((URL)seamCoreTest.getEntry("/seam/seam-1.2.0"));
        File folder = new File(seamUrl.getPath());
        SeamRuntime runtime = null;
        try {
            runtime = this.manager.addRuntime("Seam 1.2.0", folder.getAbsolutePath(), SeamVersion.SEAM_1_2, true);
            SeamRuntime[] rts = this.manager.getRuntimes();
            SeamRuntimeManagerTest.assertTrue((String)"Seam runtime 'Seam 1.2.0' is not created", (rts.length > 0 ? 1 : 0) != 0);
        }
        catch (Throwable throwable) {
            if (runtime != null) {
                this.manager.removeRuntime(runtime);
            }
            throw throwable;
        }
        if (runtime != null) {
            this.manager.removeRuntime(runtime);
        }
    }

    public void testGetRuntimesSeamVersion() throws IOException {
        Bundle seamCoreTest = Platform.getBundle((String)"org.jboss.tools.seam.core.test");
        URL seamUrl = FileLocator.resolve((URL)seamCoreTest.getEntry("/seam/seam-1.2.0"));
        File folder = new File(seamUrl.getPath());
        SeamRuntime runtime = null;
        try {
            runtime = this.manager.addRuntime("Seam 1.2.0", folder.getAbsolutePath(), SeamVersion.SEAM_1_2, true);
            SeamRuntime[] rtms = this.manager.getRuntimes(SeamVersion.SEAM_1_2);
            SeamRuntimeManagerTest.assertEquals((String)"Error in obtaining seam runtimes list for Seam 1.2", (int)1, (int)rtms.length);
        }
        catch (Throwable throwable) {
            if (runtime != null) {
                this.manager.removeRuntime(runtime);
            }
            throw throwable;
        }
        if (runtime != null) {
            this.manager.removeRuntime(runtime);
        }
    }

    public void testAddRuntimeSeamRuntime() throws IOException {
        Bundle seamCoreTest = Platform.getBundle((String)"org.jboss.tools.seam.core.test");
        URL seamUrl = FileLocator.resolve((URL)seamCoreTest.getEntry("/seam/seam-1.2.1"));
        File folder = new File(seamUrl.getPath());
        SeamRuntime runtime = null;
        try {
            runtime = this.manager.addRuntime("Seam 1.2.1", folder.getAbsolutePath(), SeamVersion.SEAM_1_2, true);
            SeamRuntimeManagerTest.assertNotNull((Object)runtime);
        }
        catch (Throwable throwable) {
            if (runtime != null) {
                this.manager.removeRuntime(runtime);
            }
            throw throwable;
        }
        if (runtime != null) {
            this.manager.removeRuntime(runtime);
        }
    }

    public void testFindRuntimeByName() throws IOException {
        Bundle seamCoreTest = Platform.getBundle((String)"org.jboss.tools.seam.core.test");
        URL seamUrl = FileLocator.resolve((URL)seamCoreTest.getEntry("/seam/seam-1.2.0"));
        File folder = new File(seamUrl.getPath());
        SeamRuntime runtime = null;
        try {
            this.manager.addRuntime("Seam 1.2.0", folder.getAbsolutePath(), SeamVersion.SEAM_1_2, true);
            runtime = this.manager.findRuntimeByName("Seam 1.2.0");
            SeamRuntimeManagerTest.assertNotNull((String)"Can't find runtime 'Seam 1.2.0' is not created", (Object)runtime);
        }
        catch (Throwable throwable) {
            if (runtime != null) {
                this.manager.removeRuntime(runtime);
            }
            throw throwable;
        }
        if (runtime != null) {
            this.manager.removeRuntime(runtime);
        }
        seamUrl = FileLocator.resolve((URL)seamCoreTest.getEntry("/seam/seam-1.2.1"));
        folder = new File(seamUrl.getPath());
        runtime = null;
        try {
            this.manager.addRuntime("Seam 1.2.1", folder.getAbsolutePath(), SeamVersion.SEAM_1_2, true);
            runtime = this.manager.findRuntimeByName("Seam 1.2.1");
            SeamRuntimeManagerTest.assertNotNull((String)"Can't find runtime 'Seam 1.2.1' is not created", (Object)runtime);
        }
        finally {
            if (runtime != null) {
                this.manager.removeRuntime(runtime);
            }
        }
    }

    public void testMatchedRuntimes() {
        SeamRuntimeManagerTest.assertTrue((boolean)SeamUtil.areSeamVersionsMatched((String)"2.1", (String)"2.1.1.GA"));
        SeamRuntimeManagerTest.assertFalse((boolean)SeamUtil.areSeamVersionsMatched((String)"1.2", (String)"2.1.1.GA"));
        SeamRuntimeManagerTest.assertFalse((boolean)SeamUtil.areSeamVersionsMatched((String)"2.0", (String)"2.1.1.GA"));
        SeamRuntimeManagerTest.assertTrue((boolean)SeamUtil.areSeamVersionsMatched((String)"2.0", (String)"2.0.1.SP1"));
        SeamRuntimeManagerTest.assertTrue((boolean)SeamUtil.areSeamVersionsMatched((String)"1.2", (String)"1.2.1.GA"));
        SeamRuntimeManagerTest.assertTrue((boolean)SeamUtil.areSeamVersionsMatched((String)"1.2", (String)"1.2.0"));
        SeamRuntimeManagerTest.assertTrue((boolean)SeamUtil.areSeamVersionsMatched((String)"2", (String)"2.0.0"));
        SeamRuntimeManagerTest.assertFalse((boolean)SeamUtil.areSeamVersionsMatched((String)"2.1", (String)"2.0.0"));
    }

    public void testGetDefaultRuntime() throws IOException {
        Bundle seamCoreTest = Platform.getBundle((String)"org.jboss.tools.seam.core.test");
        URL seamUrl = FileLocator.resolve((URL)seamCoreTest.getEntry("/seam/seam-1.2.0"));
        File folder = new File(seamUrl.getPath());
        SeamRuntime runtime = null;
        try {
            runtime = this.manager.addRuntime("Seam 1.2.0", folder.getAbsolutePath(), SeamVersion.SEAM_1_2, true);
            SeamRuntimeManagerTest.assertNotNull((String)"Cannot obtain default runtime 'Seam 1.2.0'", (Object)this.manager.getDefaultRuntime(SeamVersion.SEAM_1_2));
        }
        catch (Throwable throwable) {
            if (runtime != null) {
                this.manager.removeRuntime(runtime);
            }
            throw throwable;
        }
        if (runtime != null) {
            this.manager.removeRuntime(runtime);
        }
    }
}

