/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.seam.core.test.refactoring;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.RefactoringStatusEntry;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.text.edits.MultiTextEdit;
import org.jboss.tools.common.base.test.RenameParticipantTestUtil;
import org.jboss.tools.common.util.FileUtil;
import org.jboss.tools.seam.core.ISeamComponent;
import org.jboss.tools.seam.core.ISeamProject;
import org.jboss.tools.seam.core.test.refactoring.SeamRefactoringTest;
import org.jboss.tools.seam.internal.core.refactoring.RenameComponentProcessor;
import org.jboss.tools.test.util.ResourcesUtils;
import org.junit.Assert;

public class SeamComponentRefactoringTest
extends SeamRefactoringTest {
    public SeamComponentRefactoringTest() {
        super("Seam Component Refactoring Test");
    }

    public void testSeamComponentRename() throws CoreException {
        ResourcesUtils.setBuildAutomatically((boolean)false);
        try {
            ArrayList<RenameParticipantTestUtil.TestChangeStructure> list = new ArrayList<RenameParticipantTestUtil.TestChangeStructure>();
            RenameParticipantTestUtil.TestChangeStructure structure = new RenameParticipantTestUtil.TestChangeStructure(ejbProject.getProject(), "/ejbModule/org/domain/" + warProjectName + "/session/TestComponent.java");
            RenameParticipantTestUtil.TestTextChange change = new RenameParticipantTestUtil.TestTextChange(89, 6, "\"best\"");
            structure.addTextChange(change);
            list.add(structure);
            structure = new RenameParticipantTestUtil.TestChangeStructure(warProject, "/WebContent/WEB-INF/components.xml");
            change = new RenameParticipantTestUtil.TestTextChange(1106, 4, "best");
            structure.addTextChange(change);
            change = new RenameParticipantTestUtil.TestTextChange(1934, 4, "best");
            structure.addTextChange(change);
            list.add(structure);
            structure = new RenameParticipantTestUtil.TestChangeStructure(ejbProject, "/ejbModule/org/domain/" + warProjectName + "/session/TestSeamComponent.java");
            change = new RenameParticipantTestUtil.TestTextChange(420, 11, "@In(\"best\")");
            structure.addTextChange(change);
            change = new RenameParticipantTestUtil.TestTextChange(389, 8, "(\"best\")");
            structure.addTextChange(change);
            change = new RenameParticipantTestUtil.TestTextChange(455, 16, "@Factory(\"best\")");
            structure.addTextChange(change);
            change = new RenameParticipantTestUtil.TestTextChange(529, 8, "(\"best\")");
            structure.addTextChange(change);
            change = new RenameParticipantTestUtil.TestTextChange(589, 4, "best");
            structure.addTextChange(change);
            list.add(structure);
            structure = new RenameParticipantTestUtil.TestChangeStructure(ejbProject, "/ejbModule/seam.properties");
            change = new RenameParticipantTestUtil.TestTextChange(0, 4, "best");
            structure.addTextChange(change);
            list.add(structure);
            structure = new RenameParticipantTestUtil.TestChangeStructure(warProject, "/WebContent/test.xhtml");
            change = new RenameParticipantTestUtil.TestTextChange(1088, 4, "best");
            structure.addTextChange(change);
            list.add(structure);
            structure = new RenameParticipantTestUtil.TestChangeStructure(warProject, "/WebContent/test.jsp");
            change = new RenameParticipantTestUtil.TestTextChange(227, 4, "best");
            structure.addTextChange(change);
            list.add(structure);
            structure = new RenameParticipantTestUtil.TestChangeStructure(warProject, "/src/test.properties");
            change = new RenameParticipantTestUtil.TestTextChange(29, 4, "best");
            structure.addTextChange(change);
            list.add(structure);
            this.renameComponent(seamEjbProject, "test", "best", list, 0L);
        }
        finally {
            ResourcesUtils.setBuildAutomatically((boolean)true);
        }
    }

    public void testRemaningMailSessionDeclarationInComponentsXml_JBIDE4447() throws CoreException {
        ArrayList<RenameParticipantTestUtil.TestChangeStructure> list = new ArrayList<RenameParticipantTestUtil.TestChangeStructure>();
        RenameParticipantTestUtil.TestChangeStructure structure = new RenameParticipantTestUtil.TestChangeStructure(warProject, "/WebContent/WEB-INF/components.xml");
        RenameParticipantTestUtil.TestTextChange change = new RenameParticipantTestUtil.TestTextChange(2345, 41, "name=\"org.jboss.seam.mail.newMailSession\"");
        structure.addTextChange(change);
        list.add(structure);
        this.renameComponent(seamWarProject, "org.jboss.seam.mail.mailSession", "org.jboss.seam.mail.newMailSession", list, 8000L);
    }

    private void renameComponent(ISeamProject seamProject, String componentName, String newName, List<RenameParticipantTestUtil.TestChangeStructure> changeList, long delay) throws CoreException {
        RefactoringStatusEntry entry;
        RefactoringStatusEntry[] entries;
        ISeamComponent component = seamProject.getComponent(componentName);
        SeamComponentRefactoringTest.assertNotNull((String)("Can't load component " + componentName), (Object)component);
        RenameComponentProcessor processor = new RenameComponentProcessor(component);
        processor.setNewName(newName);
        RefactoringStatus status = processor.checkInitialConditions((IProgressMonitor)new NullProgressMonitor());
        RefactoringStatusEntry[] refactoringStatusEntryArray = entries = status.getEntries();
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            entry = refactoringStatusEntryArray[n2];
            System.out.println("Refactor status - " + entry.getMessage());
            ++n2;
        }
        Assert.assertNull((String)"Rename processor returns fatal error", (Object)status.getEntryMatchingSeverity(4));
        status = processor.checkFinalConditions((IProgressMonitor)new NullProgressMonitor(), null);
        refactoringStatusEntryArray = entries = status.getEntries();
        n = entries.length;
        n2 = 0;
        while (n2 < n) {
            entry = refactoringStatusEntryArray[n2];
            System.out.println("Refactor status - " + entry.getMessage());
            ++n2;
        }
        Assert.assertNull((String)"Rename processor returns fatal error", (Object)status.getEntryMatchingSeverity(4));
        CompositeChange rootChange = (CompositeChange)processor.createChange((IProgressMonitor)new NullProgressMonitor());
        SeamComponentRefactoringTest.assertEquals((String)"There is unexpected number of changes", (int)changeList.size(), (int)rootChange.getChildren().length);
        int i = 0;
        while (i < rootChange.getChildren().length) {
            TextFileChange fileChange = (TextFileChange)rootChange.getChildren()[i];
            MultiTextEdit edit = (MultiTextEdit)fileChange.getEdit();
            RenameParticipantTestUtil.TestChangeStructure change = RenameParticipantTestUtil.findChange(changeList, (IFile)fileChange.getFile());
            if (change != null) {
                SeamComponentRefactoringTest.assertEquals((int)change.size(), (int)edit.getChildrenSize());
            }
            ++i;
        }
        rootChange.perform((IProgressMonitor)new NullProgressMonitor());
        ejbProject.build(6, null);
        warProject.build(6, null);
        SeamComponentRefactoringTest.assertNotNull((String)("Can't load component " + newName), (Object)seamProject.getComponent(newName));
        for (RenameParticipantTestUtil.TestChangeStructure changeStructure : changeList) {
            IFile file = changeStructure.getProject().getFile(changeStructure.getFileName());
            String content = null;
            try {
                content = FileUtil.readStream((IFile)file);
            }
            catch (CoreException e) {
                e.printStackTrace();
                SeamComponentRefactoringTest.fail((String)e.getMessage());
            }
            for (RenameParticipantTestUtil.TestTextChange change : changeStructure.getTextChanges()) {
                SeamComponentRefactoringTest.assertEquals((String)("There is unexpected change in resource - " + file.getName()), (String)change.getText(), (String)content.substring(change.getOffset(), change.getOffset() + change.getLength()));
            }
        }
    }
}

