/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.seam.core.test.refactoring;

import java.util.HashMap;
import junit.framework.TestCase;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.refactoring.rename.RenameJavaProjectProcessor;
import org.eclipse.jdt.internal.corext.refactoring.rename.RenamePackageProcessor;
import org.eclipse.jdt.internal.corext.refactoring.rename.RenameSourceFolderProcessor;
import org.eclipse.jdt.internal.corext.refactoring.reorg.IConfirmQuery;
import org.eclipse.jdt.internal.corext.refactoring.reorg.ICreateTargetQueries;
import org.eclipse.jdt.internal.corext.refactoring.reorg.ICreateTargetQuery;
import org.eclipse.jdt.internal.corext.refactoring.reorg.IReorgPolicy;
import org.eclipse.jdt.internal.corext.refactoring.reorg.IReorgQueries;
import org.eclipse.jdt.internal.corext.refactoring.reorg.JavaMoveProcessor;
import org.eclipse.jdt.internal.corext.refactoring.reorg.ReorgDestinationFactory;
import org.eclipse.jdt.internal.corext.refactoring.reorg.ReorgPolicyFactory;
import org.eclipse.jdt.internal.corext.refactoring.tagging.ITextUpdating;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.participants.MoveArguments;
import org.eclipse.ltk.core.refactoring.participants.MoveParticipant;
import org.eclipse.ltk.core.refactoring.participants.MoveRefactoring;
import org.eclipse.ltk.core.refactoring.participants.RefactoringArguments;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.ltk.core.refactoring.participants.RenameArguments;
import org.eclipse.ltk.core.refactoring.participants.RenameParticipant;
import org.eclipse.ltk.core.refactoring.participants.RenameProcessor;
import org.eclipse.ltk.core.refactoring.participants.RenameRefactoring;
import org.eclipse.ltk.internal.core.refactoring.resource.RenameResourceProcessor;
import org.jboss.tools.common.model.util.EclipseResourceUtil;
import org.jboss.tools.seam.core.ISeamProject;
import org.jboss.tools.seam.core.SeamCorePlugin;
import org.jboss.tools.seam.internal.core.refactoring.SeamFolderMoveParticipant;
import org.jboss.tools.seam.internal.core.refactoring.SeamFolderRenameParticipant;
import org.jboss.tools.seam.internal.core.refactoring.SeamProjectChange;
import org.jboss.tools.seam.internal.core.refactoring.SeamProjectRenameParticipant;
import org.jboss.tools.test.util.JUnitUtils;
import org.jboss.tools.test.util.JobUtils;
import org.jboss.tools.test.util.ProjectImportTestSetup;

public class SeamPropertyRefactoringTest
extends TestCase {
    static String warProjectName = "RefactoringTestProject-war";
    static String ejbProjectName = "RefactoringTestProject-ejb";
    static String testProjectName = "RefactoringTestProject-test";
    static String actionSourceFolderName = "src";
    static String modelSourceFolderName = "src";
    static String testSourceFolderName = "src";
    static String actionSourceFolderPath = "/" + ejbProjectName + "/" + actionSourceFolderName;
    static String modelSourceFolderPath = "/" + warProjectName + "/" + modelSourceFolderName;
    static String testSourceFolderPath = "/" + testProjectName + "/" + testSourceFolderName;
    static String viewFolderParentName = "webroot";
    static String viewFolderName = "WebContent";
    static String viewFolderPath = "/" + warProjectName + "/" + viewFolderParentName + "/" + viewFolderName;
    static String actionPackageName = "ejbdemo";
    static String modelPackageName = "wardemo";
    static String testPackageName = "testdemo";
    static IProject warProject;
    static IProject ejbProject;
    static IProject testProject;
    static ISeamProject seamWarProject;
    static ISeamProject seamEjbProject;
    static ISeamProject seamTestProject;

    public SeamPropertyRefactoringTest() {
        super("Seam Property Refactoring Tests");
    }

    protected void setUp() throws Exception {
        if (warProject == null) {
            warProject = ProjectImportTestSetup.loadProject((String)warProjectName);
        }
        if (ejbProject == null) {
            ejbProject = ProjectImportTestSetup.loadProject((String)ejbProjectName);
        }
        if (testProject == null) {
            testProject = ProjectImportTestSetup.loadProject((String)testProjectName);
        }
        if (seamWarProject == null) {
            seamWarProject = this.loadSeamProject(warProject);
        }
        if (seamEjbProject == null) {
            seamEjbProject = this.loadSeamProject(ejbProject);
        }
        if (seamTestProject == null) {
            seamTestProject = this.loadSeamProject(testProject);
        }
    }

    private ISeamProject loadSeamProject(IProject project) throws CoreException {
        ISeamProject seamProject = SeamCorePlugin.getSeamProject((IProject)project, (boolean)true);
        SeamPropertyRefactoringTest.assertNotNull((String)("Seam project for " + project.getName() + " is null"), (Object)seamProject);
        JobUtils.waitForIdle();
        return seamProject;
    }

    public void testWarProjectRename() throws CoreException {
        warProjectName = "NewWarProjectName";
        HashMap<String, String> preferences = new HashMap<String, String>();
        preferences.put("seam.parent.project", warProjectName);
        preferences.put("model.sources", "/" + warProjectName + "/src");
        preferences.put("seam.project.web.root.folder", "/" + warProjectName + "/webroot/WebContent");
        try {
            this.renameProject(warProject, warProjectName, preferences);
        }
        finally {
            warProjectName = "RefactoringTestProject-war";
            this.updateFields();
        }
    }

    public void testEjbProjectRename() throws CoreException {
        ejbProjectName = "NewEjbProjectName";
        HashMap<String, String> preferences = new HashMap<String, String>();
        preferences.put("seam.ejb.project", ejbProjectName);
        preferences.put("action.sources", "/" + ejbProjectName + "/src");
        try {
            this.renameProject(ejbProject, ejbProjectName, preferences);
        }
        finally {
            ejbProjectName = "RefactoringTestProject-ejb";
            this.updateFields();
        }
    }

    public void testTestProjectRename() throws CoreException {
        testProjectName = "NewTestProjectName";
        HashMap<String, String> preferences = new HashMap<String, String>();
        preferences.put("seam.test.project", testProjectName);
        preferences.put("test.sources", "/" + testProjectName + "/src");
        try {
            this.renameProject(testProject, testProjectName, preferences);
        }
        finally {
            testProjectName = "RefactoringTestProject-test";
            this.updateFields();
        }
    }

    public void testActionSourceFolderRename() throws CoreException {
        actionSourceFolderName = "newActionSrc";
        HashMap<String, String> preferences = new HashMap<String, String>();
        preferences.put("action.sources", "/RefactoringTestProject-ejb/RefactoringTestProject-ejb/" + actionSourceFolderName);
        try {
            this.renameSourceFolder(actionSourceFolderPath, actionSourceFolderName, preferences);
        }
        finally {
            actionSourceFolderName = "src";
            this.updateFields();
        }
    }

    public void testModelSourceFolderRename() throws CoreException {
        modelSourceFolderName = "newModelSrc";
        HashMap<String, String> preferences = new HashMap<String, String>();
        preferences.put("action.sources", "/RefactoringTestProject-ejb/RefactoringTestProject-war/" + modelSourceFolderName);
        try {
            this.renameSourceFolder(modelSourceFolderPath, modelSourceFolderName, preferences);
        }
        finally {
            modelSourceFolderName = "src";
            this.updateFields();
        }
    }

    public void testTestSourceFolderRename() throws CoreException {
        testSourceFolderName = "newTestSrc";
        HashMap<String, String> preferences = new HashMap<String, String>();
        preferences.put("action.sources", "/RefactoringTestProject-ejb/RefactoringTestProject-test/" + testSourceFolderName);
        try {
            this.renameSourceFolder(testSourceFolderPath, testSourceFolderName, preferences);
        }
        finally {
            testSourceFolderName = "src";
            this.updateFields();
        }
    }

    public void testViewFolderRename() throws CoreException {
        viewFolderName = "newViewFolder";
        HashMap<String, String> preferences = new HashMap<String, String>();
        preferences.put("seam.project.web.root.folder", "/RefactoringTestProject-war/webroot/" + viewFolderName);
        try {
            this.renameFolder(viewFolderPath, viewFolderName, preferences);
        }
        finally {
            viewFolderName = "WebContent";
            this.updateFields();
        }
    }

    public void testActionPackageRename() throws CoreException {
        String oldName = actionPackageName;
        actionPackageName = "newejbdemo";
        HashMap<String, String> preferences = new HashMap<String, String>();
        preferences.put("action.sources", "/RefactoringTestProject-ejb/" + actionPackageName);
        try {
            this.renamePackage(actionSourceFolderPath, oldName, actionPackageName, preferences);
        }
        finally {
            actionPackageName = "ejbdemo";
            this.updateFields();
        }
    }

    public void testModelPackageRename() throws CoreException {
        String oldName = modelPackageName;
        modelPackageName = "newwardemo";
        HashMap<String, String> preferences = new HashMap<String, String>();
        preferences.put("model.sources", "/RefactoringTestProject-war/" + modelPackageName);
        try {
            this.renamePackage(modelSourceFolderPath, oldName, modelPackageName, preferences);
        }
        finally {
            modelPackageName = "wardemo";
            this.updateFields();
        }
    }

    public void testTestPackageRename() throws CoreException {
        String oldName = testPackageName;
        testPackageName = "newtestdemo";
        HashMap<String, String> preferences = new HashMap<String, String>();
        preferences.put("test.sources", "/RefactoringTestProject-test/" + testPackageName);
        try {
            this.renamePackage(testSourceFolderPath, oldName, testPackageName, preferences);
        }
        finally {
            testPackageName = "testdemo";
            this.updateFields();
        }
    }

    public void testViewFolderMove() throws CoreException {
        viewFolderParentName = "testwebroot";
        HashMap<String, String> preferences = new HashMap<String, String>();
        preferences.put("seam.project.web.root.folder", "/RefactoringTestProject-war/" + viewFolderParentName + "/WebContent");
        try {
            this.moveFolder(viewFolderPath, "/" + warProjectName + "/" + viewFolderParentName, preferences);
        }
        finally {
            viewFolderParentName = "webroot";
            this.updateFields();
        }
    }

    private void updateFields() {
        actionSourceFolderPath = "/" + ejbProjectName + "/" + actionSourceFolderName;
        modelSourceFolderPath = "/" + warProjectName + "/" + modelSourceFolderName;
        testSourceFolderPath = "/" + testProjectName + "/" + testSourceFolderName;
        viewFolderPath = "/" + warProjectName + "/" + viewFolderParentName + "/" + viewFolderName;
    }

    private void renameSourceFolder(String folderPath, String newFolderName, HashMap<String, String> preferences) throws CoreException {
        IPackageFragmentRoot packageFragmentRoot = this.getSourceFolder(folderPath);
        IProject project = packageFragmentRoot.getResource().getProject();
        String newPath = String.valueOf(project.getFullPath().toString()) + "/" + newFolderName;
        RenameSourceFolderProcessor processor = new RenameSourceFolderProcessor(packageFragmentRoot);
        SeamFolderRenameParticipant participant = new SeamFolderRenameParticipant();
        IResource folder = ResourcesPlugin.getWorkspace().getRoot().findMember(actionSourceFolderPath);
        this.checkRename((RefactoringProcessor)processor, folder, newPath, (RenameParticipant)participant, preferences);
    }

    private IPackageFragmentRoot getSourceFolder(String folderPath) {
        IResource initSourceFolder = ResourcesPlugin.getWorkspace().getRoot().findMember(folderPath);
        SeamPropertyRefactoringTest.assertNotNull((String)("Can't find source folder: " + folderPath), (Object)initSourceFolder);
        IProject project = initSourceFolder.getProject();
        IJavaProject javaProject = EclipseResourceUtil.getJavaProject((IProject)project);
        IPackageFragmentRoot packageFragmentRoot = null;
        try {
            IPackageFragmentRoot[] roots = javaProject.getPackageFragmentRoots();
            int i = 0;
            while (i < roots.length) {
                if (roots[i].getKind() == 1 && roots[i].getResource().equals((Object)initSourceFolder)) {
                    packageFragmentRoot = roots[i];
                    break;
                }
                ++i;
            }
        }
        catch (JavaModelException e) {
            JUnitUtils.fail((String)("Exception during searching source folder: " + folderPath), (Exception)((Object)e));
        }
        SeamPropertyRefactoringTest.assertNotNull((String)("Can't find source folder: " + folderPath), packageFragmentRoot);
        return packageFragmentRoot;
    }

    private void renameFolder(String folderPath, String newFolderName, HashMap<String, String> preferences) throws CoreException {
        IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember(folderPath);
        SeamPropertyRefactoringTest.assertNotNull((String)("Can't find folder: " + folderPath), (Object)resource);
        RenameResourceProcessor processor = new RenameResourceProcessor(resource);
        RenameRefactoring refactoring = new RenameRefactoring((RenameProcessor)processor);
        processor.setNewResourceName(newFolderName);
        processor.setUpdateReferences(true);
        ITextUpdating text = (ITextUpdating)refactoring.getAdapter(ITextUpdating.class);
        if (text != null) {
            text.setUpdateTextualMatches(true);
        }
        SeamFolderRenameParticipant participant = new SeamFolderRenameParticipant();
        this.checkRename((RefactoringProcessor)processor, resource, newFolderName, (RenameParticipant)participant, preferences);
    }

    private void renamePackage(String sourceFolderPath, String oldPackageName, String newPackageName, HashMap<String, String> preferences) throws CoreException {
        IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember(sourceFolderPath);
        SeamPropertyRefactoringTest.assertNotNull((String)("Can't find source folder: " + sourceFolderPath), (Object)resource);
        IProject project = resource.getProject();
        IJavaProject javaProject = EclipseResourceUtil.getJavaProject((IProject)project);
        SeamPropertyRefactoringTest.assertNotNull((String)("Can't find java project: " + project.getName()), (Object)javaProject);
        IPackageFragmentRoot root = null;
        try {
            IPackageFragmentRoot[] roots = javaProject.getPackageFragmentRoots();
            int i = 0;
            while (i < roots.length) {
                if (roots[i].getKind() == 1 && roots[i].getResource().getFullPath().toString().equals(sourceFolderPath)) {
                    root = roots[i];
                    break;
                }
                ++i;
            }
        }
        catch (JavaModelException e) {
            JUnitUtils.fail((String)("Can't find source folder: " + sourceFolderPath), (Exception)((Object)e));
        }
        SeamPropertyRefactoringTest.assertNotNull((String)("Can't find source folder: " + sourceFolderPath), root);
        IPackageFragment oldPackage = this.findPackage(root, oldPackageName);
        SeamPropertyRefactoringTest.assertNotNull((String)("Can't find package \"" + oldPackageName + "\". So it's impossible to rename it."), (Object)oldPackage);
        RenamePackageProcessor processor = new RenamePackageProcessor(oldPackage);
        SeamFolderRenameParticipant participant = new SeamFolderRenameParticipant();
        this.checkRename((RefactoringProcessor)processor, resource, newPackageName, (RenameParticipant)participant, preferences);
    }

    private IPackageFragment findPackage(IPackageFragmentRoot root, String packageName) {
        IJavaElement[] packages = null;
        try {
            packages = root.getChildren();
        }
        catch (JavaModelException e) {
            JUnitUtils.fail((String)("Can't find package: " + packageName), (Exception)((Object)e));
        }
        IJavaElement[] iJavaElementArray = packages;
        int n = packages.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaElement javaElement = iJavaElementArray[n2];
            if (javaElement instanceof IPackageFragment && javaElement.getElementName().equals(packageName)) {
                return (IPackageFragment)javaElement;
            }
            ++n2;
        }
        return null;
    }

    private void renameProject(IProject project, String newProjectName, HashMap<String, String> preferences) throws CoreException {
        RenameJavaProjectProcessor processor = new RenameJavaProjectProcessor(JavaCore.create((IProject)project));
        SeamProjectRenameParticipant participant = new SeamProjectRenameParticipant();
        this.checkRename((RefactoringProcessor)processor, project, newProjectName, (RenameParticipant)participant, preferences);
    }

    private void moveFolder(String folderPath, String destinationFolderPath, HashMap<String, String> preferences) throws CoreException {
        IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember(folderPath);
        SeamPropertyRefactoringTest.assertNotNull((String)("Can't find folder: " + folderPath), (Object)resource);
        IResource destination = ResourcesPlugin.getWorkspace().getRoot().findMember(destinationFolderPath);
        SeamPropertyRefactoringTest.assertNotNull((String)("Can't find destination folder: " + destinationFolderPath), (Object)destination);
        IReorgPolicy.IMovePolicy policy = null;
        JavaMoveProcessor processor = null;
        try {
            policy = ReorgPolicyFactory.createMovePolicy((IResource[])new IResource[]{resource}, (IJavaElement[])new IJavaElement[0]);
            processor = new JavaMoveProcessor(policy);
            processor.setDestination(ReorgDestinationFactory.createDestination((Object)destination));
        }
        catch (JavaModelException e) {
            JUnitUtils.fail((String)("Exception during perform folder moving: " + folderPath), (Exception)((Object)e));
        }
        new MoveRefactoring(processor);
        processor.setCreateTargetQueries(new ICreateTargetQueries(){

            public ICreateTargetQuery createNewPackageQuery() {
                return null;
            }
        });
        processor.setReorgQueries(new IReorgQueries(){

            public IConfirmQuery createSkipQuery(String queryTitle, int queryID) {
                return null;
            }

            public IConfirmQuery createYesNoQuery(String queryTitle, boolean allowCancel, int queryID) {
                return null;
            }

            public IConfirmQuery createYesYesToAllNoNoToAllQuery(String queryTitle, boolean allowCancel, int queryID) {
                return null;
            }
        });
        SeamFolderMoveParticipant participant = new SeamFolderMoveParticipant();
        this.checkMove((RefactoringProcessor)processor, resource, destination, (MoveParticipant)participant, preferences);
    }

    private void checkMove(RefactoringProcessor processor, Object oldObject, Object destinationObject, MoveParticipant participant, HashMap<String, String> preferences) throws CoreException {
        MoveArguments arguments = new MoveArguments(destinationObject, true);
        participant.initialize(processor, oldObject, (RefactoringArguments)arguments);
        participant.checkConditions((IProgressMonitor)new NullProgressMonitor(), null);
        CompositeChange rootChange = (CompositeChange)participant.createChange((IProgressMonitor)new NullProgressMonitor());
        Change[] changeArray = rootChange.getChildren();
        int n = changeArray.length;
        int n2 = 0;
        while (n2 < n) {
            Change change = changeArray[n2];
            if (change instanceof SeamProjectChange) {
                SeamProjectChange seamChange = (SeamProjectChange)change;
                HashMap preferencesToCheck = seamChange.getPreferencesForTest();
                this.checkChanges(preferencesToCheck, preferences);
            }
            ++n2;
        }
    }

    private void checkRename(RefactoringProcessor processor, Object oldObject, String newName, RenameParticipant participant, HashMap<String, String> preferences) throws CoreException {
        RenameArguments arguments = new RenameArguments(newName, true);
        participant.initialize(processor, oldObject, (RefactoringArguments)arguments);
        participant.checkConditions((IProgressMonitor)new NullProgressMonitor(), null);
        CompositeChange rootChange = (CompositeChange)participant.createChange((IProgressMonitor)new NullProgressMonitor());
        Change[] changeArray = rootChange.getChildren();
        int n = changeArray.length;
        int n2 = 0;
        while (n2 < n) {
            Change change = changeArray[n2];
            if (change instanceof SeamProjectChange) {
                SeamProjectChange seamChange = (SeamProjectChange)change;
                HashMap preferencesToCheck = seamChange.getPreferencesForTest();
                this.checkChanges(preferencesToCheck, preferences);
            }
            ++n2;
        }
    }

    private void checkChanges(HashMap<String, String> preferencesToCheck, HashMap<String, String> preferences) {
        for (String key : preferencesToCheck.keySet()) {
            String value = preferences.get(key);
            SeamPropertyRefactoringTest.assertNotNull((String)("Unexpected preference " + key + " not found"), (Object)value);
            String valueToCheck = preferencesToCheck.get(key);
            SeamPropertyRefactoringTest.assertEquals((String)"Wrong preference value", (String)value, (String)valueToCheck);
        }
    }
}

