/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.seam.core.test.validation;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.validation.internal.core.ValidationException;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.wst.validation.internal.provisional.core.IValidator;
import org.jboss.tools.common.validation.ContextValidationHelper;
import org.jboss.tools.common.validation.IProjectValidationContext;
import org.jboss.tools.common.validation.IValidatingProjectSet;
import org.jboss.tools.common.validation.ValidatorManager;
import org.jboss.tools.seam.core.SeamProjectsSet;
import org.jboss.tools.seam.core.test.validation.IValidatorSupport;
import org.jboss.tools.seam.internal.core.validation.SeamCoreValidator;

public class ValidatorSupport
implements IReporter,
IValidatorSupport {
    List<IMarker> markers = new ArrayList<IMarker>();
    Set<IFile> files = new HashSet<IFile>();
    private IProject project;
    org.jboss.tools.common.validation.IValidator validator;

    public ValidatorSupport(IProject project, org.jboss.tools.common.validation.IValidator validator) {
        this.project = project;
        this.validator = validator;
    }

    @Override
    public void validate() throws ValidationException {
        ContextValidationHelper helper = new ContextValidationHelper();
        helper.setProject(this.project);
        IProjectValidationContext context = ((IValidatingProjectSet)SeamCoreValidator.getSeamValidatingProjects((IProject)this.project).getBrunches().values().iterator().next()).getRootContext();
        new SeamProjectsSet(this.project);
        this.validator.validate(this.files, this.project, helper, context, new ValidatorManager(), (IReporter)this);
    }

    @Override
    public void add(IMarker marker) {
        if (marker != null) {
            this.markers.add(marker);
        }
    }

    @Override
    public boolean isMessageCreated(String template, Object[] parameters) {
        String messagePattern = MessageFormat.format(template, parameters);
        boolean result = false;
        for (IMarker marker : this.markers) {
            String message = marker.getAttribute("message", "").toString();
            if (messagePattern.equals(message)) {
                result = true;
                break;
            }
            if (!messagePattern.matches(message)) continue;
            result = true;
            break;
        }
        return result;
    }

    @Override
    public void addFile(IFile o) {
        this.files.add(o);
    }

    @Override
    public List<IMarker> getMarkers() {
        return this.markers;
    }

    public boolean isCancelled() {
        return false;
    }

    public void addMessage(IValidator origin, IMessage message) {
    }

    public void displaySubtask(IValidator validator, IMessage message) {
    }

    public void removeAllMessages(IValidator origin) {
    }

    public void removeAllMessages(IValidator origin, Object object) {
    }

    public void removeMessageSubset(IValidator validator, Object obj, String groupName) {
    }

    public List getMessages() {
        return null;
    }

    @Override
    public void validate(IFile file) throws ValidationException {
        this.addFile(file);
        this.validate();
    }

    @Override
    public boolean isMessageCreatedOnLine(String markerTemplate, Object[] parameters, int lineNumber) throws CoreException {
        String messagePattern = MessageFormat.format(markerTemplate, parameters);
        boolean result = false;
        for (IMarker marker : this.markers) {
            Object line;
            String message = marker.getAttribute("message", "").toString();
            if (!messagePattern.matches(message) || (line = marker.getAttribute("lineNumber")) == null || !(line instanceof Integer) || (Integer)line != lineNumber) continue;
            result = true;
            break;
        }
        return result;
    }
}

