/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.seam.pages.xml.test;

import junit.framework.TestCase;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.util.EclipseResourceUtil;
import org.jboss.tools.seam.pages.xml.model.helpers.SeamPagesDiagramHelper;
import org.jboss.tools.seam.pages.xml.model.helpers.SeamPagesDiagramStructureHelper;
import org.jboss.tools.seam.pages.xml.model.impl.SeamPagesDiagramImpl;
import org.jboss.tools.test.util.ResourcesUtils;
import org.jboss.tools.test.util.xpl.EditorTestHelper;

public class SeamPagesXMLModelTest
extends TestCase {
    IProject project = null;

    public SeamPagesXMLModelTest() {
        super("Seam Scanner test");
    }

    protected void setUp() throws Exception {
        this.project = ResourcesUtils.importProject((String)"org.jboss.tools.seam.pages.xml.test", (String)"/projects/Test", (IProgressMonitor)new NullProgressMonitor());
        this.project.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
        EditorTestHelper.joinBackgroundActivities();
    }

    public void testXMLModel() {
        IFile f = this.project.getFile((IPath)new Path("pages/wiki.xml"));
        SeamPagesXMLModelTest.assertNotNull((String)"File pages/wiki.xml is not found in Test project.", (Object)f);
        XModelObject fileObject = EclipseResourceUtil.createObjectForResource((IResource)f);
        SeamPagesXMLModelTest.assertNotNull((String)"Cannot create XModel object for file pages/wiki.xml.", (Object)fileObject);
        String entity = fileObject.getModelEntity().getName();
        SeamPagesXMLModelTest.assertEquals((String)"File pages/wiki.xml is incorrectly parsed by XModel.", (String)"FileSeamPages20", (String)entity);
        XModelObject diagramXML = SeamPagesDiagramStructureHelper.instance.getProcess(fileObject);
        SeamPagesXMLModelTest.assertNotNull((String)"Cannot find XModel diagram object for file pages/wiki.xml.", (Object)diagramXML);
        if (!(diagramXML instanceof SeamPagesDiagramImpl)) {
            SeamPagesXMLModelTest.fail((String)"XModel diagram object must be instance of SeamPagesDiagramImpl.");
        }
        SeamPagesDiagramImpl impl = (SeamPagesDiagramImpl)diagramXML;
        diagramXML.getChildren();
        SeamPagesDiagramHelper h = impl.getHelper();
        this.checkTargetMatch("/docDisplay#{a}", h, "/docDisplay*");
        this.checkTargetMatch("/docDisplay", h, "/docDisplay*");
        this.checkTargetMatch("/docDispla", h, "/*");
    }

    protected void tearDown() throws Exception {
        EditorTestHelper.joinJobs((long)1000L, (long)10000L, (long)500L);
        this.project.delete(true, true, null);
    }

    private void checkTargetMatch(String targetViewId, SeamPagesDiagramHelper h, String expectedMatch) {
        String s = h.findBestMatch(targetViewId);
        SeamPagesXMLModelTest.assertEquals((String)"Match for target view id is incorrectly computed.", (String)expectedMatch, (String)s);
    }
}

