/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.batch.ui.itest;

import junit.framework.TestCase;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.sapphire.ElementList;
import org.eclipse.sapphire.ui.SapphireEditorPagePart;
import org.eclipse.ui.IEditorPart;
import org.jboss.tools.batch.ui.editor.internal.model.Analyzer;
import org.jboss.tools.batch.ui.editor.internal.model.Batchlet;
import org.jboss.tools.batch.ui.editor.internal.model.CheckpointAlgorithm;
import org.jboss.tools.batch.ui.editor.internal.model.Chunk;
import org.jboss.tools.batch.ui.editor.internal.model.Collector;
import org.jboss.tools.batch.ui.editor.internal.model.FlowElement;
import org.jboss.tools.batch.ui.editor.internal.model.Job;
import org.jboss.tools.batch.ui.editor.internal.model.JobXMLEditor;
import org.jboss.tools.batch.ui.editor.internal.model.Mapper;
import org.jboss.tools.batch.ui.editor.internal.model.Partition;
import org.jboss.tools.batch.ui.editor.internal.model.Processor;
import org.jboss.tools.batch.ui.editor.internal.model.Reader;
import org.jboss.tools.batch.ui.editor.internal.model.Reducer;
import org.jboss.tools.batch.ui.editor.internal.model.Step;
import org.jboss.tools.batch.ui.editor.internal.model.Writer;
import org.jboss.tools.test.util.WorkbenchUtils;

public abstract class AbstractBatchSapphireEditorTest
extends TestCase {
    protected IProject project;
    protected JobXMLEditor editor;

    public void setUp() {
        this.project = ResourcesPlugin.getWorkspace().getRoot().getProject(this.getProjectName());
        AbstractBatchSapphireEditorTest.assertNotNull((Object)this.project);
    }

    protected String getProjectName() {
        return "BatchTestProject";
    }

    protected void tearDown() throws Exception {
        if (this.editor != null) {
            this.editor.getSite().getPage().closeEditor((IEditorPart)this.editor, false);
            this.editor = null;
        }
        super.tearDown();
    }

    protected JobXMLEditor openEditor(String fileName) {
        IFile testfile = this.project.getFile(fileName);
        AbstractBatchSapphireEditorTest.assertTrue((String)("Test file doesn't exist: " + this.project.getName() + "/" + fileName), (testfile.exists() && testfile.isAccessible() ? 1 : 0) != 0);
        IEditorPart editorPart = WorkbenchUtils.openEditor((String)(String.valueOf(this.project.getName()) + "/" + fileName));
        AbstractBatchSapphireEditorTest.assertNotNull((Object)editorPart);
        AbstractBatchSapphireEditorTest.assertTrue((boolean)(editorPart instanceof JobXMLEditor));
        return (JobXMLEditor)editorPart;
    }

    public Job openJob(String fileName) {
        this.editor = this.openEditor(fileName);
        return this.editor.getSchema();
    }

    protected SapphireEditorPagePart getDiagramPage() {
        SapphireEditorPagePart page = this.editor.getEditorPagePart("Diagram");
        AbstractBatchSapphireEditorTest.assertNotNull((Object)page);
        return page;
    }

    protected Batchlet findBatchlet(ElementList<FlowElement> es, int i) {
        Step step = this.findStep(es, i);
        if (step != null && !step.getBatchletOrChunk().isEmpty() && step.getBatchletOrChunk().get(0) instanceof Batchlet) {
            return (Batchlet)step.getBatchletOrChunk().get(0);
        }
        return null;
    }

    protected Step findStep(ElementList<FlowElement> es, int i) {
        if (es.get(i) instanceof Step) {
            return (Step)es.get(i);
        }
        return null;
    }

    protected Partition findPartition(ElementList<FlowElement> es, int i) {
        Step step = this.findStep(es, i);
        if (step != null && step.getPartition() != null) {
            return (Partition)step.getPartition().content();
        }
        return null;
    }

    protected Chunk findChunk(ElementList<FlowElement> es, int i) {
        Step step = this.findStep(es, i);
        if (step != null && !step.getBatchletOrChunk().isEmpty() && step.getBatchletOrChunk().get(0) instanceof Chunk) {
            return (Chunk)step.getBatchletOrChunk().get(0);
        }
        return null;
    }

    protected Reader findReader(ElementList<FlowElement> es, int i) {
        Chunk chunk = this.findChunk(es, i);
        return chunk != null ? chunk.getReader() : null;
    }

    protected Processor findProcessor(ElementList<FlowElement> es, int i) {
        Chunk chunk = this.findChunk(es, i);
        return chunk != null ? (Processor)chunk.getProcessor().content() : null;
    }

    protected Writer findWriter(ElementList<FlowElement> es, int i) {
        Chunk chunk = this.findChunk(es, i);
        return chunk != null ? chunk.getWriter() : null;
    }

    protected CheckpointAlgorithm findCheckpointAlgorithm(ElementList<FlowElement> es, int i) {
        Chunk chunk = this.findChunk(es, i);
        return chunk != null ? (CheckpointAlgorithm)chunk.getCheckpointAlgorithm().content() : null;
    }

    protected Mapper findMapper(ElementList<FlowElement> es, int i) {
        Partition partition = this.findPartition(es, i);
        return partition != null ? (Mapper)partition.getMapper().content() : null;
    }

    protected Collector findCollector(ElementList<FlowElement> es, int i) {
        Partition partition = this.findPartition(es, i);
        return partition != null ? (Collector)partition.getCollector().content() : null;
    }

    protected Analyzer findAnalyzer(ElementList<FlowElement> es, int i) {
        Partition partition = this.findPartition(es, i);
        return partition != null ? (Analyzer)partition.getAnalyzer().content() : null;
    }

    protected Reducer findReducer(ElementList<FlowElement> es, int i) {
        Partition partition = this.findPartition(es, i);
        return partition != null ? (Reducer)partition.getReducer().content() : null;
    }
}

