/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.batch.ui.itest;

import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.text.hyperlink.AbstractHyperlinkDetector;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.PlatformUI;
import org.jboss.tools.jst.jsp.test.openon.HyperlinkTestUtil;
import org.jboss.tools.jst.web.ui.internal.text.ext.hyperlink.ELHyperlink;
import org.jboss.tools.jst.web.ui.internal.text.ext.hyperlink.ELHyperlinkDetector;

public class BatchELHyperlinkTest
extends TestCase {
    private static final String PROJECT_NAME = "BatchTestProject";
    public IProject project = null;

    protected void setUp() {
        this.project = ResourcesPlugin.getWorkspace().getRoot().getProject(PROJECT_NAME);
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().closeAllEditors(false);
    }

    protected void tearDown() {
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().closeAllEditors(false);
    }

    public BatchELHyperlinkTest() {
        super("Batch ELHyperlinkDetector Test");
    }

    public void testDetector() throws Exception {
        this.checkHyperlinkDetector("src/META-INF/batch-jobs/job-ca-4.xml");
    }

    public void testHyperlinks() throws Exception {
        this.checkHyperlinks("src/META-INF/batch-jobs/job-ca-4.xml");
    }

    private void checkHyperlinkDetector(String pageName) throws Exception {
        List<HyperlinkTestUtil.TestRegion> regionList = this.getTestRegionList();
        HyperlinkTestUtil.checkRegionsInTextEditor((IProject)this.project, (String)pageName, regionList, (AbstractHyperlinkDetector)new ELHyperlinkDetector());
    }

    private void checkHyperlinks(String pageName) throws Exception {
        List<HyperlinkTestUtil.TestRegion> regionList = this.getTestRegionList();
        HyperlinkTestUtil.checkHyperlinksInTextEditor((IProject)this.project, (String)pageName, regionList, (AbstractHyperlinkDetector)new ELHyperlinkDetector());
    }

    private List<HyperlinkTestUtil.TestRegion> getTestRegionList() {
        ArrayList<HyperlinkTestUtil.TestRegion> regionList = new ArrayList<HyperlinkTestUtil.TestRegion>();
        String message = NLS.bind((String)"Property {0} at {1}:{2}", (Object[])new Object[]{"p1", 2, 18});
        regionList.add(new HyperlinkTestUtil.TestRegion("'p1'", new HyperlinkTestUtil.TestHyperlink[]{new HyperlinkTestUtil.TestHyperlink(ELHyperlink.class, message)}));
        return regionList;
    }
}

