/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.batch.ui.itest;

import java.text.MessageFormat;
import org.eclipse.sapphire.ElementList;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.ui.forms.swt.MasterDetailsEditorPage;
import org.eclipse.wst.sse.ui.StructuredTextEditor;
import org.jboss.tools.batch.internal.core.validation.BatchValidationMessages;
import org.jboss.tools.batch.ui.editor.internal.model.Chunk;
import org.jboss.tools.batch.ui.editor.internal.model.Flow;
import org.jboss.tools.batch.ui.editor.internal.model.FlowElement;
import org.jboss.tools.batch.ui.editor.internal.model.Job;
import org.jboss.tools.batch.ui.editor.internal.model.JobXMLEditor;
import org.jboss.tools.batch.ui.editor.internal.model.Processor;
import org.jboss.tools.batch.ui.editor.internal.model.RefAttributeElement;
import org.jboss.tools.batch.ui.editor.internal.model.Step;
import org.jboss.tools.batch.ui.itest.AbstractBatchSapphireEditorTest;

public class BatchEditorTest
extends AbstractBatchSapphireEditorTest {
    public void testEditor() {
        JobXMLEditor jobEditor = this.editor = this.openEditor("src/META-INF/batch-jobs/job.xml");
        Job job = jobEditor.getSchema();
        BatchEditorTest.assertNotNull((Object)job);
        ElementList es = job.getFlowElements();
        BatchEditorTest.assertEquals((int)1, (int)es.size());
        Step step = (Step)es.get(0);
        ElementList ch = step.getBatchletOrChunk();
        Chunk chunk = (Chunk)ch.iterator().next();
        BatchEditorTest.assertEquals((String)"myReader", (String)((String)chunk.getReader().getRef().content()));
        BatchEditorTest.assertEquals((String)"myItemWriter", (String)((String)chunk.getWriter().getRef().content()));
        BatchEditorTest.assertEquals((String)"myItemProcessor", (String)((String)((Processor)chunk.getProcessor().content()).getRef().content()));
        StructuredTextEditor textEditor = jobEditor.getSourceEditor();
        BatchEditorTest.assertNotNull((Object)textEditor);
        MasterDetailsEditorPage formEditor = jobEditor.getFormEditor();
        BatchEditorTest.assertNotNull((Object)formEditor);
    }

    public void testValidation() {
        JobXMLEditor jobEditor = this.editor = this.openEditor("src/META-INF/batch-jobs/job-validation-1.xml");
        Job job = jobEditor.getSchema();
        ElementList es = job.getFlowElements();
        Step step = (Step)es.get(0);
        Status status = step.getId().validation();
        BatchEditorTest.assertTrue((boolean)status.ok());
        step = (Step)es.get(1);
        status = step.getId().validation();
        BatchEditorTest.assertFalse((boolean)status.ok());
        Flow flow = (Flow)es.get(2);
        status = flow.getId().validation();
        BatchEditorTest.assertFalse((boolean)status.ok());
    }

    public void testRestartableInvalid() throws Exception {
        JobXMLEditor jobEditor = this.editor = this.openEditor("src/META-INF/batch-jobs/job-restartable-invalid.xml");
        Job job = jobEditor.getSchema();
        Value restartable = job.getRestartable();
        BatchEditorTest.assertEquals((String)"xxxx", (String)restartable.text());
        BatchEditorTest.assertEquals((Object)Boolean.TRUE, (Object)restartable.content());
        Status s = restartable.validation();
        BatchEditorTest.assertFalse((boolean)s.ok());
    }

    public void testRestartableValid() throws Exception {
        JobXMLEditor jobEditor = this.editor = this.openEditor("src/META-INF/batch-jobs/job-restartable-valid.xml");
        Job job = jobEditor.getSchema();
        Value restartable = job.getRestartable();
        BatchEditorTest.assertEquals((String)"false", (String)restartable.text());
        BatchEditorTest.assertEquals((Object)Boolean.FALSE, (Object)restartable.content());
        Status s = restartable.validation();
        BatchEditorTest.assertTrue((boolean)s.ok());
    }

    public void testBatchletRefValidation() throws Exception {
        Job job = this.openJob("src/META-INF/batch-jobs/job3.xml");
        ElementList es = job.getFlowElements();
        this.assertRefValidation((RefAttributeElement)this.findBatchlet((ElementList<FlowElement>)es, 0), null);
        this.assertRefValidation((RefAttributeElement)this.findBatchlet((ElementList<FlowElement>)es, 2), BatchValidationMessages.BATCHLET_IS_NOT_FOUND);
        this.assertRefValidation((RefAttributeElement)this.findBatchlet((ElementList<FlowElement>)es, 1), BatchValidationMessages.BATCHLET_IS_EXPECTED);
    }

    public void testReaderRefValidation() throws Exception {
        Job job = this.openJob("src/META-INF/batch-jobs/job7.xml");
        ElementList es = job.getFlowElements();
        this.assertRefValidation((RefAttributeElement)this.findReader((ElementList<FlowElement>)es, 0), null);
        this.assertRefValidation((RefAttributeElement)this.findReader((ElementList<FlowElement>)es, 1), BatchValidationMessages.READER_IS_NOT_FOUND);
        this.assertRefValidation((RefAttributeElement)this.findReader((ElementList<FlowElement>)es, 2), BatchValidationMessages.READER_IS_EXPECTED);
    }

    public void testProcessorRefValidation() throws Exception {
        Job job = this.openJob("src/META-INF/batch-jobs/job7.xml");
        ElementList es = job.getFlowElements();
        this.assertRefValidation((RefAttributeElement)this.findProcessor((ElementList<FlowElement>)es, 0), null);
        this.assertRefValidation((RefAttributeElement)this.findProcessor((ElementList<FlowElement>)es, 1), BatchValidationMessages.PROCESSOR_IS_NOT_FOUND);
        this.assertRefValidation((RefAttributeElement)this.findProcessor((ElementList<FlowElement>)es, 2), BatchValidationMessages.PROCESSOR_IS_EXPECTED);
    }

    public void testWriterRefValidation() throws Exception {
        Job job = this.openJob("src/META-INF/batch-jobs/job7.xml");
        ElementList es = job.getFlowElements();
        this.assertRefValidation((RefAttributeElement)this.findWriter((ElementList<FlowElement>)es, 0), null);
        this.assertRefValidation((RefAttributeElement)this.findWriter((ElementList<FlowElement>)es, 1), BatchValidationMessages.WRITER_IS_NOT_FOUND);
        this.assertRefValidation((RefAttributeElement)this.findWriter((ElementList<FlowElement>)es, 2), BatchValidationMessages.WRITER_IS_EXPECTED);
    }

    public void testCheckpointAlgorithmRefValidation() throws Exception {
        Job job = this.openJob("src/META-INF/batch-jobs/job7.xml");
        ElementList es = job.getFlowElements();
        this.assertRefValidation((RefAttributeElement)this.findCheckpointAlgorithm((ElementList<FlowElement>)es, 0), null);
        this.assertRefValidation((RefAttributeElement)this.findCheckpointAlgorithm((ElementList<FlowElement>)es, 1), BatchValidationMessages.CHECKPOINT_ALGORITHM_IS_NOT_FOUND);
        this.assertRefValidation((RefAttributeElement)this.findCheckpointAlgorithm((ElementList<FlowElement>)es, 2), BatchValidationMessages.CHECKPOINT_ALGORITHM_IS_EXPECTED);
    }

    public void testJobListenerRefValidation() throws Exception {
        Job job = this.openJob("src/META-INF/batch-jobs/job8.xml");
        ElementList es = job.getListeners();
        this.assertRefValidation((RefAttributeElement)es.get(0), null);
        this.assertRefValidation((RefAttributeElement)es.get(1), BatchValidationMessages.JOB_LISTENER_IS_NOT_FOUND);
        this.assertRefValidation((RefAttributeElement)es.get(2), BatchValidationMessages.JOB_LISTENER_IS_EXPECTED);
    }

    public void testStepListenerRefValidation() throws Exception {
        Job job = this.openJob("src/META-INF/batch-jobs/job9.xml");
        ElementList es = this.findStep((ElementList<FlowElement>)job.getFlowElements(), 0).getListeners();
        this.assertRefValidation((RefAttributeElement)es.get(2), null);
        this.assertRefValidation((RefAttributeElement)es.get(1), BatchValidationMessages.STEP_LISTENER_IS_NOT_FOUND);
        this.assertRefValidation((RefAttributeElement)es.get(0), BatchValidationMessages.STEP_LISTENER_IS_EXPECTED);
    }

    public void testMapperRefValidation() throws Exception {
        Job job = this.openJob("src/META-INF/batch-jobs/job10.xml");
        ElementList es = job.getFlowElements();
        this.assertRefValidation((RefAttributeElement)this.findMapper((ElementList<FlowElement>)es, 0), null);
        this.assertRefValidation((RefAttributeElement)this.findMapper((ElementList<FlowElement>)es, 1), BatchValidationMessages.MAPPER_IS_NOT_FOUND);
        this.assertRefValidation((RefAttributeElement)this.findMapper((ElementList<FlowElement>)es, 2), BatchValidationMessages.MAPPER_IS_EXPECTED);
    }

    public void testCollectorRefValidation() throws Exception {
        Job job = this.openJob("src/META-INF/batch-jobs/job10.xml");
        ElementList es = job.getFlowElements();
        this.assertRefValidation((RefAttributeElement)this.findCollector((ElementList<FlowElement>)es, 0), null);
        this.assertRefValidation((RefAttributeElement)this.findCollector((ElementList<FlowElement>)es, 1), BatchValidationMessages.COLLECTOR_IS_NOT_FOUND);
        this.assertRefValidation((RefAttributeElement)this.findCollector((ElementList<FlowElement>)es, 2), BatchValidationMessages.COLLECTOR_IS_EXPECTED);
    }

    public void testAnalyzerRefValidation() throws Exception {
        Job job = this.openJob("src/META-INF/batch-jobs/job10.xml");
        ElementList es = job.getFlowElements();
        this.assertRefValidation((RefAttributeElement)this.findAnalyzer((ElementList<FlowElement>)es, 0), null);
        this.assertRefValidation((RefAttributeElement)this.findAnalyzer((ElementList<FlowElement>)es, 1), BatchValidationMessages.ANALYZER_IS_NOT_FOUND);
        this.assertRefValidation((RefAttributeElement)this.findAnalyzer((ElementList<FlowElement>)es, 2), BatchValidationMessages.ANALYZER_IS_EXPECTED);
    }

    public void testReducerRefValidation() throws Exception {
        Job job = this.openJob("src/META-INF/batch-jobs/job10.xml");
        ElementList es = job.getFlowElements();
        this.assertRefValidation((RefAttributeElement)this.findReducer((ElementList<FlowElement>)es, 0), null);
        this.assertRefValidation((RefAttributeElement)this.findReducer((ElementList<FlowElement>)es, 1), BatchValidationMessages.REDUCER_IS_NOT_FOUND);
        this.assertRefValidation((RefAttributeElement)this.findReducer((ElementList<FlowElement>)es, 2), BatchValidationMessages.REDUCER_IS_EXPECTED);
    }

    void assertRefValidation(RefAttributeElement artifact, String messagePattern) {
        BatchEditorTest.assertNotNull((Object)artifact);
        Status status = artifact.getRef().validation();
        if (messagePattern == null) {
            BatchEditorTest.assertTrue((boolean)status.ok());
        } else {
            BatchEditorTest.assertFalse((boolean)status.ok());
            String message = MessageFormat.format(messagePattern, artifact.getRef().content());
            BatchEditorTest.assertEquals((String)message, (String)status.message());
        }
    }
}

