/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.batch.ui.itest;

import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.text.hyperlink.AbstractHyperlinkDetector;
import org.eclipse.ui.PlatformUI;
import org.jboss.tools.batch.ui.hyperlink.BatchHyperlinkDetector;
import org.jboss.tools.common.text.ext.hyperlink.OpenJavaElementHyperlink;
import org.jboss.tools.common.text.ext.hyperlink.xml.XMLJumpToHyperlink;
import org.jboss.tools.jst.jsp.test.openon.HyperlinkTestUtil;

public class BatchHyperlinkDetectorTest
extends TestCase {
    private static final String PROJECT_NAME = "BatchTestProject";
    public IProject project = null;

    protected void setUp() {
        this.project = ResourcesPlugin.getWorkspace().getRoot().getProject(PROJECT_NAME);
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().closeAllEditors(false);
    }

    protected void tearDown() {
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().closeAllEditors(false);
    }

    public BatchHyperlinkDetectorTest() {
        super("BatchHyperlinkDetector Test");
    }

    public void testDetector() throws Exception {
        this.checkHyperlinkDetector("src/META-INF/batch-jobs/job-openon-1.xml");
    }

    public void testHyperlinks() throws Exception {
        this.checkHyperlinks("src/META-INF/batch-jobs/job-openon-1.xml");
    }

    public void testHyperlinksInExternalFile() throws Exception {
        ArrayList<HyperlinkTestUtil.TestRegion> regionList = new ArrayList<HyperlinkTestUtil.TestRegion>();
        regionList.add(new HyperlinkTestUtil.TestRegion("myBatchletStep2", new HyperlinkTestUtil.TestHyperlink[]{new HyperlinkTestUtil.TestHyperlink(XMLJumpToHyperlink.class, "Go to '<step id=\"myBatchletStep2\">'")}));
        regionList.add(new HyperlinkTestUtil.TestRegion("ref=", new HyperlinkTestUtil.TestHyperlink[0]));
        regionList.add(new HyperlinkTestUtil.TestRegion("myBatchletStep3", new HyperlinkTestUtil.TestHyperlink[]{new HyperlinkTestUtil.TestHyperlink(XMLJumpToHyperlink.class, "Go to '<step id=\"myBatchletStep3\">'")}));
        regionList.add(new HyperlinkTestUtil.TestRegion("myBatchletStep2", new HyperlinkTestUtil.TestHyperlink[]{new HyperlinkTestUtil.TestHyperlink(XMLJumpToHyperlink.class, "Go to '<step id=\"myBatchletStep2\">'")}));
        HyperlinkTestUtil.checkRegionsForExternalFile((String)"src/org/jboss/tools/batch/ui/itest/job-openon-1.xml", regionList, (AbstractHyperlinkDetector)new BatchHyperlinkDetector());
    }

    private void checkHyperlinkDetector(String pageName) throws Exception {
        List<HyperlinkTestUtil.TestRegion> regionList = this.getTestRegionList();
        HyperlinkTestUtil.checkRegionsInTextEditor((IProject)this.project, (String)pageName, regionList, (AbstractHyperlinkDetector)new BatchHyperlinkDetector());
    }

    private void checkHyperlinks(String pageName) throws Exception {
        List<HyperlinkTestUtil.TestRegion> regionList = this.getTestRegionList();
        HyperlinkTestUtil.checkRegionsInTextEditor((IProject)this.project, (String)pageName, regionList, (AbstractHyperlinkDetector)new BatchHyperlinkDetector());
    }

    private List<HyperlinkTestUtil.TestRegion> getTestRegionList() {
        ArrayList<HyperlinkTestUtil.TestRegion> regionList = new ArrayList<HyperlinkTestUtil.TestRegion>();
        regionList.add(new HyperlinkTestUtil.TestRegion("myBatchletStep2", new HyperlinkTestUtil.TestHyperlink[]{new HyperlinkTestUtil.TestHyperlink(XMLJumpToHyperlink.class, "Go to '<step id=\"myBatchletStep2\">'")}));
        regionList.add(new HyperlinkTestUtil.TestRegion("ref=", new HyperlinkTestUtil.TestHyperlink[0]));
        regionList.add(new HyperlinkTestUtil.TestRegion("batchlet1", new HyperlinkTestUtil.TestHyperlink[]{new HyperlinkTestUtil.TestHyperlink(OpenJavaElementHyperlink.class, "Open Class 'batch.MyBatchlet'")}));
        regionList.add(new HyperlinkTestUtil.TestRegion("worktime", new HyperlinkTestUtil.TestHyperlink[]{new HyperlinkTestUtil.TestHyperlink(OpenJavaElementHyperlink.class, "Open Field 'batch.MyBatchlet.time'")}));
        regionList.add(new HyperlinkTestUtil.TestRegion("myMapper", new HyperlinkTestUtil.TestHyperlink[]{new HyperlinkTestUtil.TestHyperlink(OpenJavaElementHyperlink.class, "Open Class 'batchlib.MyMapper'")}));
        regionList.add(new HyperlinkTestUtil.TestRegion("myCollector", new HyperlinkTestUtil.TestHyperlink[]{new HyperlinkTestUtil.TestHyperlink(OpenJavaElementHyperlink.class, "Open Class 'batchlib.MyCollector'")}));
        regionList.add(new HyperlinkTestUtil.TestRegion("myAnalyzer", new HyperlinkTestUtil.TestHyperlink[]{new HyperlinkTestUtil.TestHyperlink(OpenJavaElementHyperlink.class, "Open Class 'batchlib.MyAnalyzer'")}));
        regionList.add(new HyperlinkTestUtil.TestRegion("myReducer", new HyperlinkTestUtil.TestHyperlink[]{new HyperlinkTestUtil.TestHyperlink(OpenJavaElementHyperlink.class, "Open Class 'batchlib.MyReducer'")}));
        regionList.add(new HyperlinkTestUtil.TestRegion("myBatchletStep3", new HyperlinkTestUtil.TestHyperlink[]{new HyperlinkTestUtil.TestHyperlink(XMLJumpToHyperlink.class, "Go to '<step id=\"myBatchletStep3\">'")}));
        regionList.add(new HyperlinkTestUtil.TestRegion("myBatchletStep2", new HyperlinkTestUtil.TestHyperlink[]{new HyperlinkTestUtil.TestHyperlink(XMLJumpToHyperlink.class, "Go to '<step id=\"myBatchletStep2\">'")}));
        regionList.add(new HyperlinkTestUtil.TestRegion("batchlet1", new HyperlinkTestUtil.TestHyperlink[]{new HyperlinkTestUtil.TestHyperlink(OpenJavaElementHyperlink.class, "Open Class 'batch.MyBatchlet'")}));
        regionList.add(new HyperlinkTestUtil.TestRegion("batchlet1", new HyperlinkTestUtil.TestHyperlink[]{new HyperlinkTestUtil.TestHyperlink(OpenJavaElementHyperlink.class, "Open Class 'batch.MyBatchlet'")}));
        regionList.add(new HyperlinkTestUtil.TestRegion("myAnalyzer", new HyperlinkTestUtil.TestHyperlink[]{new HyperlinkTestUtil.TestHyperlink(OpenJavaElementHyperlink.class, "Open Class 'batchlib.MyAnalyzer'")}));
        regionList.add(new HyperlinkTestUtil.TestRegion("myReducer", new HyperlinkTestUtil.TestHyperlink[]{new HyperlinkTestUtil.TestHyperlink(OpenJavaElementHyperlink.class, "Open Class 'batchlib.MyReducer'")}));
        regionList.add(new HyperlinkTestUtil.TestRegion("myMapper", new HyperlinkTestUtil.TestHyperlink[]{new HyperlinkTestUtil.TestHyperlink(OpenJavaElementHyperlink.class, "Open Class 'batchlib.MyMapper'")}));
        regionList.add(new HyperlinkTestUtil.TestRegion("myCollector", new HyperlinkTestUtil.TestHyperlink[]{new HyperlinkTestUtil.TestHyperlink(OpenJavaElementHyperlink.class, "Open Class 'batchlib.MyCollector'")}));
        return regionList;
    }
}

