/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.batch.ui.itest;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import junit.framework.TestCase;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jface.text.hyperlink.AbstractHyperlinkDetector;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.jboss.tools.batch.core.IBatchArtifact;
import org.jboss.tools.batch.core.IBatchProperty;
import org.jboss.tools.batch.internal.core.impl.BatchProject;
import org.jboss.tools.batch.internal.core.impl.BatchProjectFactory;
import org.jboss.tools.batch.internal.core.impl.BatchUtil;
import org.jboss.tools.batch.ui.hyperlink.BatchHyperlinkMessages;
import org.jboss.tools.batch.ui.hyperlink.BatchPropertyDialog;
import org.jboss.tools.batch.ui.hyperlink.BatchPropertyHyperlink;
import org.jboss.tools.batch.ui.hyperlink.BatchPropertyHyperlinkDetector;
import org.jboss.tools.common.model.util.EclipseResourceUtil;
import org.jboss.tools.common.util.EclipseJavaUtil;
import org.jboss.tools.jst.jsp.test.openon.HyperlinkTestUtil;

public class BatchPropertyHyperlinkDetectorTest
extends TestCase {
    private static final String PROJECT_NAME = "BatchTestProject";
    public IProject project = null;

    protected void setUp() {
        this.project = ResourcesPlugin.getWorkspace().getRoot().getProject(PROJECT_NAME);
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().closeAllEditors(false);
    }

    protected void tearDown() {
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().closeAllEditors(false);
    }

    public BatchPropertyHyperlinkDetectorTest() {
        super("BatchHyperlinkDetector Test");
    }

    public void testDetector() throws Exception {
        this.checkHyperlinkDetector("src/batch/SearchableBatchlet.java");
    }

    public void testBatchPropertyDialog() throws CoreException {
        String path = "src/batch/SearchableBatchlet.java";
        IFile file = this.project.getFile(path);
        BatchPropertyHyperlinkDetectorTest.assertTrue((boolean)file.exists());
        BatchProject batchProject = (BatchProject)BatchProjectFactory.getBatchProjectWithProgress((IProject)this.project);
        BatchPropertyHyperlinkDetectorTest.assertNotNull((Object)batchProject);
        IJavaProject javaProject = EclipseResourceUtil.getJavaProject((IProject)this.project);
        BatchPropertyHyperlinkDetectorTest.assertNotNull((Object)javaProject);
        IType type = EclipseJavaUtil.findType((IJavaProject)javaProject, (String)"batch.SearchableBatchlet");
        BatchPropertyHyperlinkDetectorTest.assertNotNull((Object)type);
        IField field = EclipseJavaUtil.findField((IType)type, (String)"otherName");
        BatchPropertyHyperlinkDetectorTest.assertNotNull((Object)field);
        IBatchArtifact artifact = batchProject.getArtifact(type);
        BatchPropertyHyperlinkDetectorTest.assertNotNull((Object)artifact);
        IBatchProperty batchProperty = artifact.getProperty(field);
        BatchPropertyHyperlinkDetectorTest.assertNotNull((Object)batchProperty);
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        BatchPropertyDialog dialog = new BatchPropertyDialog(display.getActiveShell(), batchProperty);
        dialog.setBlockOnOpen(false);
        dialog.open();
        HashMap references = dialog.getDisplayedReferences();
        IFile jobXMLFile = this.project.getFile("src/META-INF/batch-jobs/job-search.xml");
        BatchPropertyHyperlinkDetectorTest.assertTrue((boolean)jobXMLFile.exists());
        List list = (List)references.get(jobXMLFile);
        BatchPropertyHyperlinkDetectorTest.assertNotNull((Object)list);
        BatchPropertyHyperlinkDetectorTest.assertEquals((int)1, (int)list.size());
        BatchUtil.NodePathTextSourceReference reference = (BatchUtil.NodePathTextSourceReference)list.get(0);
        BatchPropertyHyperlinkDetectorTest.assertNotNull((Object)reference);
    }

    private void checkHyperlinkDetector(String pageName) throws Exception {
        List<HyperlinkTestUtil.TestRegion> regionList = this.getTestRegionList();
        HyperlinkTestUtil.checkRegions((IProject)this.project, (String)pageName, regionList, (AbstractHyperlinkDetector)new BatchPropertyHyperlinkDetector());
    }

    private List<HyperlinkTestUtil.TestRegion> getTestRegionList() {
        ArrayList<HyperlinkTestUtil.TestRegion> regionList = new ArrayList<HyperlinkTestUtil.TestRegion>();
        regionList.add(new HyperlinkTestUtil.TestRegion("SearchableBatchlet", new HyperlinkTestUtil.TestHyperlink[0]));
        regionList.add(new HyperlinkTestUtil.TestRegion("Inject", new HyperlinkTestUtil.TestHyperlink[]{new HyperlinkTestUtil.TestHyperlink(BatchPropertyHyperlink.class, "Show All Batch Property References")}));
        regionList.add(new HyperlinkTestUtil.TestRegion("BatchProperty", new HyperlinkTestUtil.TestHyperlink[]{new HyperlinkTestUtil.TestHyperlink(BatchPropertyHyperlink.class, "Show All Batch Property References")}));
        regionList.add(new HyperlinkTestUtil.TestRegion("String", new HyperlinkTestUtil.TestHyperlink[]{new HyperlinkTestUtil.TestHyperlink(BatchPropertyHyperlink.class, BatchHyperlinkMessages.SHOW_ALL_BATCH_PROPERTY_REFERENCES)}));
        regionList.add(new HyperlinkTestUtil.TestRegion("otherName", new HyperlinkTestUtil.TestHyperlink[]{new HyperlinkTestUtil.TestHyperlink(BatchPropertyHyperlink.class, BatchHyperlinkMessages.SHOW_ALL_BATCH_PROPERTY_REFERENCES)}));
        return regionList;
    }
}

