/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.batch.ui.itest;

import java.util.ArrayList;
import junit.framework.TestCase;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.ui.search.IQueryParticipant;
import org.eclipse.ui.PlatformUI;
import org.jboss.tools.batch.ui.participants.BatchArtifactSearchParticipant;
import org.jboss.tools.common.base.test.kb.QueryParticipantTestUtils;

public class BatchQueryParticipantTest
extends TestCase {
    private static final String PROJECT_NAME = "BatchTestProject";
    public IProject project = null;

    protected void setUp() {
        this.project = ResourcesPlugin.getWorkspace().getRoot().getProject(PROJECT_NAME);
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().closeAllEditors(false);
    }

    protected void tearDown() {
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().closeAllEditors(false);
    }

    public BatchQueryParticipantTest() {
        super("Batch Search Participants Test");
    }

    public void testBatchArtifactSearch() throws CoreException {
        ArrayList<QueryParticipantTestUtils.MatchStructure> matches = new ArrayList<QueryParticipantTestUtils.MatchStructure>();
        matches.add(new QueryParticipantTestUtils.MatchStructure("/BatchTestProject/src/META-INF/batch-jobs/job-search.xml", "searchableBatchlet"));
        matches.add(new QueryParticipantTestUtils.MatchStructure("/BatchTestProject/src/META-INF/batch-jobs/job-search.xml", "searchableBatchlet"));
        QueryParticipantTestUtils.testSearchParticipant((IProject)this.project, (String)"src/batch/SearchableBatchlet.java", (int)3, (String)"SearchableBatchlet", (String)"", (IQueryParticipant)new BatchArtifactSearchParticipant(), matches);
    }

    public void testWriterSearch() throws CoreException {
        ArrayList<QueryParticipantTestUtils.MatchStructure> matches = new ArrayList<QueryParticipantTestUtils.MatchStructure>();
        matches.add(new QueryParticipantTestUtils.MatchStructure("/BatchTestProject/src/META-INF/batch-jobs/job-search.xml", "rewriter"));
        QueryParticipantTestUtils.testSearchParticipant((IProject)this.project, (String)"src/batch/SearchableWriter.java", (int)3, (String)"SearchableWriter", (String)"", (IQueryParticipant)new BatchArtifactSearchParticipant(), matches);
    }

    public void testBatchArtifactPropertySearch() throws CoreException {
        ArrayList<QueryParticipantTestUtils.MatchStructure> matches = new ArrayList<QueryParticipantTestUtils.MatchStructure>();
        matches.add(new QueryParticipantTestUtils.MatchStructure("/BatchTestProject/src/META-INF/batch-jobs/job-search.xml", "secondName"));
        QueryParticipantTestUtils.testSearchParticipant((IProject)this.project, (String)"src/batch/SearchableBatchlet.java", (int)1, (String)"otherName", (String)"", (IQueryParticipant)new BatchArtifactSearchParticipant(), matches);
    }

    public void testClassSearch() throws CoreException {
        ArrayList<QueryParticipantTestUtils.MatchStructure> matches = new ArrayList<QueryParticipantTestUtils.MatchStructure>();
        matches.add(new QueryParticipantTestUtils.MatchStructure("/BatchTestProject/src/META-INF/batch-jobs/job-search.xml", "batch.SearchableException"));
        matches.add(new QueryParticipantTestUtils.MatchStructure("/BatchTestProject/src/META-INF/batch-jobs/job-search.xml", "batch.SearchableException"));
        matches.add(new QueryParticipantTestUtils.MatchStructure("/BatchTestProject/src/META-INF/batch-jobs/job-search.xml", "batch.SearchableException"));
        QueryParticipantTestUtils.testSearchParticipant((IProject)this.project, (String)"src/batch/SearchableException.java", (int)3, (String)"SearchableException", (String)"", (IQueryParticipant)new BatchArtifactSearchParticipant(), matches);
    }
}

