/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.batch.ui.itest;

import junit.framework.TestCase;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.ui.PlatformUI;
import org.jboss.tools.batch.ui.quickfixes.CreateBatchArtifactQuickFix;
import org.jboss.tools.common.base.test.MarkerResolutionTestUtil;
import org.jboss.tools.test.util.JobUtils;

public class BatchQuickFixTest
extends TestCase {
    public static final String PROBLEM_TYPE = "org.jboss.tools.batch.core.batchproblem";
    private static final String PROJECT_NAME = "BatchTestProject";
    public IProject project = null;

    protected void setUp() {
        this.project = ResourcesPlugin.getWorkspace().getRoot().getProject(PROJECT_NAME);
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().closeAllEditors(false);
    }

    protected void tearDown() throws CoreException {
        String[] filesToDelete;
        JobUtils.runDeferredEvents();
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().closeAllEditors(false);
        String[] stringArray = filesToDelete = new String[]{"src/batch/AnyJobListener.java", "src/batch/AnyStepListener.java", "src/batch/AnyBatchlet.java", "src/batchlib/AnyPartitionMapper.java", "src/batchlib/AnyPartitionCollector.java", "src/batchlib/AnyPartitionAnalyzer.java", "src/batchlib/AnyPartitionReducer.java", "src/batch/AnyItemReader.java", "src/batch/AnyItemProcessor.java", "src/batch/AnyItemWriter.java", "src/batch/AnyCheckpointAlgorithm.java", "src/batch/AnyDecider.java"};
        int n = filesToDelete.length;
        int n2 = 0;
        while (n2 < n) {
            String fileName = stringArray[n2];
            IFile file = this.project.getFile(fileName);
            file.delete(true, (IProgressMonitor)new NullProgressMonitor());
            ++n2;
        }
    }

    public BatchQuickFixTest() {
        super("Batch Quick Fix Test");
    }

    private void checkBatchQuickFix(int quickFixId) throws CoreException {
        MarkerResolutionTestUtil.checkResolution((IProject)this.project, (String[])new String[]{"src/META-INF/batch-jobs/job-quickfix.xml"}, (String)PROBLEM_TYPE, (String)"Message_id", (int)quickFixId, CreateBatchArtifactQuickFix.class);
    }

    public void testCreateBatchletQuickFix() throws CoreException {
        this.checkBatchQuickFix(1);
    }

    public void testCreateJobListenerQuickFix() throws CoreException {
        this.checkBatchQuickFix(2);
    }

    public void testCreateStepListenerQuickFix() throws CoreException {
        this.checkBatchQuickFix(3);
    }

    public void testCreateDeciderQuickFix() throws CoreException {
        this.checkBatchQuickFix(4);
    }

    public void testCreateCheckpointAlgorithmQuickFix() throws CoreException {
        this.checkBatchQuickFix(5);
    }

    public void testCreateItemReaderQuickFix() throws CoreException {
        this.checkBatchQuickFix(6);
    }

    public void testCreateItemWriterQuickFix() throws CoreException {
        this.checkBatchQuickFix(7);
    }

    public void testCreateItemProcessorQuickFix() throws CoreException {
        this.checkBatchQuickFix(8);
    }

    public void testCreatePartitionMapperQuickFix() throws CoreException {
        this.checkBatchQuickFix(9);
    }

    public void testCreatePartitionAnalyzerQuickFix() throws CoreException {
        this.checkBatchQuickFix(10);
    }

    public void testCreatePartitionCollectorQuickFix() throws CoreException {
        this.checkBatchQuickFix(11);
    }

    public void testCreatePartitionReducerQuickFix() throws CoreException {
        this.checkBatchQuickFix(12);
    }
}

