/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.batch.ui.itest;

import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.internal.corext.refactoring.rename.RenameFieldProcessor;
import org.eclipse.jdt.internal.corext.refactoring.rename.RenameTypeProcessor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.ltk.core.refactoring.participants.RefactoringParticipant;
import org.eclipse.ltk.core.refactoring.participants.RenameProcessor;
import org.eclipse.ui.PlatformUI;
import org.jboss.tools.batch.ui.participants.BatchArtifactRenameParticipant;
import org.jboss.tools.common.base.test.AbstractRefactorTest;
import org.jboss.tools.common.base.test.RenameParticipantTestUtil;

public class BatchRenameParticipantTest
extends AbstractRefactorTest {
    private static final String PROJECT_NAME = "BatchTestProject";
    public IProject project = null;

    protected void setUp() {
        this.project = ResourcesPlugin.getWorkspace().getRoot().getProject(PROJECT_NAME);
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().closeAllEditors(false);
    }

    protected void tearDown() {
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().closeAllEditors(false);
    }

    public BatchRenameParticipantTest() {
        super("Batch Rename Participants Test");
    }

    public void testBatchArtifactRename() throws CoreException, BadLocationException {
        ArrayList<RenameParticipantTestUtil.TestChangeStructure> list = new ArrayList<RenameParticipantTestUtil.TestChangeStructure>();
        RenameParticipantTestUtil.TestChangeStructure structure = new RenameParticipantTestUtil.TestChangeStructure(this.project, "/src/META-INF/batch-jobs/job-refactor.xml");
        RenameParticipantTestUtil.TestTextChange change = new RenameParticipantTestUtil.TestTextChange("renamableBatchlet", 17, "abcdmableBatchlet");
        structure.addTextChange(change);
        list.add(structure);
        IType type = RenameParticipantTestUtil.getJavaType((IProject)this.project, (String)"batch.RenamableBatchlet");
        RenameTypeProcessor renameProcessor = new RenameTypeProcessor(type);
        RenameParticipantTestUtil.checkRenameParticipant((IJavaElement)type, (RenameProcessor)renameProcessor, (RefactoringParticipant)new BatchArtifactRenameParticipant(), (String)"abcdmableBatchlet", list);
    }

    public void testBatchPropertyRename() throws CoreException, BadLocationException {
        ArrayList<RenameParticipantTestUtil.TestChangeStructure> list = new ArrayList<RenameParticipantTestUtil.TestChangeStructure>();
        RenameParticipantTestUtil.TestChangeStructure structure = new RenameParticipantTestUtil.TestChangeStructure(this.project, "/src/META-INF/batch-jobs/job-refactor.xml");
        RenameParticipantTestUtil.TestTextChange change = new RenameParticipantTestUtil.TestTextChange("otherName", 9, "abcdeName");
        structure.addTextChange(change);
        list.add(structure);
        IField field = RenameParticipantTestUtil.getJavaField((IProject)this.project, (String)"batch.RenamablePropertyBatchlet", (String)"otherName");
        RenameFieldProcessor renameProcessor = new RenameFieldProcessor(field);
        RenameParticipantTestUtil.checkRenameParticipant((IJavaElement)field, (RenameProcessor)renameProcessor, (RefactoringParticipant)new BatchArtifactRenameParticipant(), (String)"abcdeName", list);
    }

    public void testClassRename() throws CoreException, BadLocationException {
        ArrayList<RenameParticipantTestUtil.TestChangeStructure> list = new ArrayList<RenameParticipantTestUtil.TestChangeStructure>();
        RenameParticipantTestUtil.TestChangeStructure structure = new RenameParticipantTestUtil.TestChangeStructure(this.project, "/src/META-INF/batch-jobs/job-refactor.xml");
        RenameParticipantTestUtil.TestTextChange change = new RenameParticipantTestUtil.TestTextChange("batch.SecondRenamableException", 30, "batch.AbcdefRenamableException");
        structure.addTextChange(change);
        list.add(structure);
        change = new RenameParticipantTestUtil.TestTextChange("batch.SecondRenamableException", 30, "batch.AbcdefRenamableException");
        structure.addTextChange(change);
        IType type = RenameParticipantTestUtil.getJavaType((IProject)this.project, (String)"batch.SecondRenamableException");
        RenameTypeProcessor renameProcessor = new RenameTypeProcessor(type);
        RenameParticipantTestUtil.checkRenameParticipant((IJavaElement)type, (RenameProcessor)renameProcessor, (RefactoringParticipant)new BatchArtifactRenameParticipant(), (String)"AbcdefRenamableException", list);
    }

    public void testClassRename2() throws CoreException, BadLocationException {
        ArrayList<RenameParticipantTestUtil.TestChangeStructure> list = new ArrayList<RenameParticipantTestUtil.TestChangeStructure>();
        RenameParticipantTestUtil.TestChangeStructure structure = new RenameParticipantTestUtil.TestChangeStructure(this.project, "/src/META-INF/batch-jobs/job-refactor.xml");
        RenameParticipantTestUtil.TestTextChange change = new RenameParticipantTestUtil.TestTextChange("batch.RenamableException", 24, "batch.RenamableExceptio2");
        structure.addTextChange(change);
        list.add(structure);
        IType type = RenameParticipantTestUtil.getJavaType((IProject)this.project, (String)"batch.RenamableException");
        RenameTypeProcessor renameProcessor = new RenameTypeProcessor(type);
        RenameParticipantTestUtil.checkRenameParticipant((IJavaElement)type, (RenameProcessor)renameProcessor, (RefactoringParticipant)new BatchArtifactRenameParticipant(), (String)"RenamableExceptio2", list);
    }
}

